/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.provider.ProviderUtil;

public class Util {
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Util.class);

    private Util() {
    }

    public static String getResourceName(UriInfo uriInfo) {
        return Util.upperCaseFirstLetter(Util.eleminateHypen(Util.getName(uriInfo.getPath(), '/')));
    }

    public static String getParentName(UriInfo uriInfo) {
        if (uriInfo == null) {
            return null;
        }
        return Util.getParentName(uriInfo.getPath());
    }

    public static String getName(String typeName) {
        return Util.getName(typeName, '.');
    }

    public static String getName(String typeName, char delimiter) {
        int index;
        if (typeName == null || "".equals(typeName)) {
            return typeName;
        }
        if (typeName.length() - 1 == typeName.lastIndexOf(delimiter)) {
            typeName = typeName.substring(0, typeName.length() - 1);
        }
        if (typeName != null && typeName.length() > 0 && (index = typeName.lastIndexOf(delimiter)) != -1) {
            return typeName.substring(index + 1);
        }
        return typeName;
    }

    public static String getParentName(String url) {
        if (url == null || "".equals(url)) {
            return url;
        }
        String name = Util.getName(url, '/');
        int nameIndex = url.indexOf(name, url.indexOf(":") + 1);
        return Util.getName(url.substring(0, nameIndex - 1), '/');
    }

    public static String eleminateHypen(String string) {
        if (string != null && string.length() > 0) {
            int index = string.indexOf(45);
            while (index != -1) {
                string = index == 0 ? string.substring(1) : (index == string.length() - 1 ? string.substring(0, string.length() - 1) : string.substring(0, index) + Util.upperCaseFirstLetter(string.substring(index + 1)));
                index = string.indexOf(45);
            }
        }
        return string;
    }

    public static String decode(String string) {
        String ret = string;
        try {
            ret = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ret;
    }

    public static String upperCaseFirstLetter(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    protected static String getHtml(String message, UriInfo uriInfo, boolean delete) {
        String result = ProviderUtil.getHtmlHeader(uriInfo.getBaseUri().toASCIIString());
        String uri = uriInfo.getAbsolutePath().toString();
        if (delete) {
            uri = uri + "/..";
        }
        String name = Util.upperCaseFirstLetter(Util.eleminateHypen(Util.getName(uri, '/')));
        String parentName = Util.upperCaseFirstLetter(Util.eleminateHypen(Util.getParentName(uri)));
        result = result + "<h1>" + name + "</h1>";
        result = result + message;
        result = result + "<a href=\"" + uri + "\">Back</a>";
        result = result + "</body></html>";
        return result;
    }

    public static String methodNameFromDtdName(String elementName, String prefix) {
        return Util.methodNameFromBeanName(Util.eleminateHypen(elementName), prefix);
    }

    public static String methodNameFromBeanName(String elementName, String prefix) {
        if (null == elementName || null == prefix || prefix.length() <= 0) {
            return elementName;
        }
        String methodName = Util.upperCaseFirstLetter(elementName);
        methodName = prefix + methodName;
        return methodName;
    }
}

