/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import com.sun.enterprise.v3.common.ActionReporter;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.api.ActionReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/json", "application/x-javascript"})
public class ActionReportResultJsonProvider
extends BaseProvider<ActionReportResult> {
    public ActionReportResultJsonProvider() {
        super(ActionReportResult.class, MediaType.APPLICATION_JSON_TYPE);
    }

    @Override
    public String getContent(ActionReportResult proxy) {
        ActionReporter ar = proxy.getActionReport();
        String JSONP = this.getCallBackJSONP();
        try {
            JSONObject result = this.processReport(ar);
            int indent = this.getFormattingIndentLevel();
            if (indent > -1) {
                return result.toString(indent);
            }
            if (JSONP == null) {
                return result.toString();
            }
            return JSONP + "(" + result.toString() + ")";
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected JSONObject processReport(ActionReporter ar) throws JSONException {
        List subReports;
        List children;
        Properties extraProperties;
        JSONObject result = new JSONObject();
        result.put("message", (Object)ar.getMessage());
        result.put("command", (Object)ar.getActionDescription());
        result.put("exit_code", (Object)ar.getActionExitCode());
        Properties properties = ar.getTopMessagePart().getProps();
        if (properties != null && !properties.isEmpty()) {
            result.put("properties", (Map)properties);
        }
        if ((extraProperties = ar.getExtraProperties()) != null && !extraProperties.isEmpty()) {
            result.put("extraProperties", (Object)this.getExtraProperties(result, extraProperties));
        }
        if ((children = ar.getTopMessagePart().getChildren()) != null && !children.isEmpty()) {
            result.put("children", (Object)this.processChildren(children));
        }
        if ((subReports = ar.getSubActionsReport()) != null && !subReports.isEmpty()) {
            result.put("subReports", (Object)this.processSubReports(subReports));
        }
        return result;
    }

    protected JSONArray processChildren(List<ActionReport.MessagePart> parts) throws JSONException {
        JSONArray array = new JSONArray();
        for (ActionReport.MessagePart part : parts) {
            JSONObject object = new JSONObject();
            object.put("message", (Object)part.getMessage());
            object.put("properties", (Map)part.getProps());
            List children = part.getChildren();
            if (children.size() > 0) {
                object.put("children", (Object)this.processChildren(part.getChildren()));
            }
            array.put((Object)object);
        }
        return array;
    }

    protected JSONArray processSubReports(List<ActionReporter> subReports) throws JSONException {
        JSONArray array = new JSONArray();
        for (ActionReporter subReport : subReports) {
            array.put((Object)this.processReport(subReport));
        }
        return array;
    }

    protected JSONObject getExtraProperties(JSONObject object, Properties props) throws JSONException {
        JSONObject extraProperties = new JSONObject();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = entry.getKey().toString();
            Object value = this.getJsonObject(entry.getValue());
            extraProperties.put(key, value);
        }
        return extraProperties;
    }

    protected Object getJsonObject(Object object) throws JSONException {
        Object result = null;
        result = object instanceof Collection ? this.processCollection((Collection)object) : (object instanceof Map ? this.processMap((Map)object) : (object == null ? JSONObject.NULL : object));
        return result;
    }

    protected JSONArray processCollection(Collection c) throws JSONException {
        JSONArray result = new JSONArray();
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object item = this.getJsonObject(i.next());
            result.put(item);
        }
        return result;
    }

    protected JSONObject processMap(Map map) throws JSONException {
        JSONObject result = new JSONObject();
        for (Map.Entry entry : map.entrySet()) {
            result.put(entry.getKey().toString(), this.getJsonObject(entry.getValue()));
        }
        return result;
    }

    protected <T> T getFieldValue(ActionReporter ar, String name, T type) {
        try {
            Class<?> clazz = ar.getClass().getSuperclass();
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return (T)field.get(ar);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

