/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.config.serverbeans.Domain;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.glassfish.admin.rest.generator.ClassWriter;
import org.glassfish.admin.rest.generator.CommandResourceMetaData;
import org.glassfish.admin.rest.generator.ResourcesGeneratorBase;
import org.glassfish.admin.rest.resources.GeneratorResource;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestRedirect;
import org.glassfish.api.admin.RestRedirects;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;

@Path(value="/status/")
public class StatusGenerator {
    @Context
    protected Habitat habitat;
    protected StringBuilder status = new StringBuilder();
    private Set<String> commandsUsed = new TreeSet<String>();
    private Set<String> allCommands = new TreeSet<String>();
    private Set<String> restRedirectCommands = new TreeSet<String>();

    @GET
    @Produces(value={"text/plain"})
    public String get() {
        this.status.append("Status of Command usage\n");
        try {
            Domain entity = (Domain)this.habitat.getComponent(Domain.class);
            Dom dom = Dom.unwrap((ConfigBeanProxy)entity);
            DomDocument document = dom.document;
            ConfigModel rootModel = dom.document.getRoot().model;
            NOOPResourcesGenerator resourcesGenerator = new NOOPResourcesGenerator();
            resourcesGenerator.generateSingle(rootModel, document);
            resourcesGenerator.endGeneration();
        }
        catch (Exception ex) {
            Logger.getLogger(GeneratorResource.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.status.append("-------All Commands:\n");
        for (String ss : this.commandsUsed) {
            this.status.append(ss + "\n");
        }
        this.listOfCommands();
        for (String ss : this.commandsUsed) {
            this.allCommands.remove(ss);
        }
        this.status.append("-------Missing Commands:\n");
        for (String ss : this.allCommands) {
            this.status.append(ss + "\n");
        }
        this.status.append("-------REST-REDIRECT Commands:\n");
        for (String ss : this.restRedirectCommands) {
            this.status.append(ss + "\n");
        }
        return this.status.toString();
    }

    public void listOfCommands() {
        CommandRunner cr = (CommandRunner)this.habitat.getComponent(CommandRunner.class);
        RestActionReporter ar = new RestActionReporter();
        ParameterMap parameters = new ParameterMap();
        cr.getCommandInvocation("list-commands", (ActionReport)ar).parameters(parameters).execute();
        List children = ar.getTopMessagePart().getChildren();
        for (ActionReport.MessagePart part : children) {
            this.allCommands.add(part.getMessage());
        }
        ar = new RestActionReporter();
        parameters = new ParameterMap();
        parameters.add((Object)"DEFAULT", (Object)"_");
        cr.getCommandInvocation("list-commands", (ActionReport)ar).parameters(parameters).execute();
        children = ar.getTopMessagePart().getChildren();
        for (ActionReport.MessagePart part : children) {
            this.allCommands.add(part.getMessage());
        }
    }

    class NOOPResourcesGenerator
    extends ResourcesGeneratorBase {
        NOOPResourcesGenerator() {
        }

        public ClassWriter getClassWriter(String className, String baseClassName, String resourcePath) {
            return new NOOPClassWriter(className, baseClassName, resourcePath);
        }

        public String endGeneration() {
            return "done";
        }

        public void configModelVisited(ConfigModel model) {
            Class<?> cbp = null;
            try {
                cbp = ((ClassLoader)model.classLoaderHolder.get()).loadClass(model.targetTypeName);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            RestRedirects restRedirects = cbp.getAnnotation(RestRedirects.class);
            if (restRedirects != null) {
                RestRedirect[] values;
                for (RestRedirect r : values = restRedirects.value()) {
                    StatusGenerator.this.commandsUsed.add(r.commandName());
                    StatusGenerator.this.restRedirectCommands.add(r.commandName());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NOOPClassWriter
    implements ClassWriter {
        public NOOPClassWriter(String className, String baseClassName, String resourcePath) {
            StatusGenerator.this.status.append(className);
            StatusGenerator.this.status.append("\n");
        }

        @Override
        public void createGetCommandResourcePaths(List<CommandResourceMetaData> commandMetaData) {
            for (CommandResourceMetaData metaData : commandMetaData) {
                StatusGenerator.this.status.append("   ");
                StatusGenerator.this.status.append(metaData.command);
                StatusGenerator.this.commandsUsed.add(metaData.command);
                StatusGenerator.this.status.append("\n");
            }
            StatusGenerator.this.status.append("\n");
        }

        @Override
        public void createGetCommandResource(String commandResourceClassName, String resourcePath) {
        }

        @Override
        public void createCommandResourceConstructor(String commandResourceClassName, String commandName, String httpMethod, boolean linkedToParent, CommandResourceMetaData.ParameterMetaData[] commandParams, String commandDisplayName, String commandAction) {
        }

        @Override
        public void createCustomResourceMapping(String resourceClassName, String mappingPath) {
        }

        @Override
        public void done() {
        }

        @Override
        public void createGetDeleteCommand(String commandName) {
            StatusGenerator.this.status.append("   ");
            StatusGenerator.this.status.append(commandName);
            StatusGenerator.this.status.append("\n");
            StatusGenerator.this.commandsUsed.add(commandName);
        }

        @Override
        public void createGetPostCommand(String commandName) {
            StatusGenerator.this.status.append("   ");
            StatusGenerator.this.status.append(commandName);
            StatusGenerator.this.status.append("\n");
            StatusGenerator.this.commandsUsed.add(commandName);
        }

        @Override
        public void createGetChildResource(String path, String childResourceClassName) {
        }

        @Override
        public void createGetChildResourceForListResources(String keyAttributeName, String childResourceClassName) {
        }

        @Override
        public void createGetPostCommandForCollectionLeafResource(String commandName) {
            StatusGenerator.this.status.append("   ");
            StatusGenerator.this.status.append(commandName);
            StatusGenerator.this.status.append("\n");
            StatusGenerator.this.commandsUsed.add(commandName);
        }

        @Override
        public void createGetDeleteCommandForCollectionLeafResource(String commandName) {
            StatusGenerator.this.status.append("   ");
            StatusGenerator.this.status.append(commandName);
            StatusGenerator.this.status.append("\n");
            StatusGenerator.this.commandsUsed.add(commandName);
        }

        @Override
        public void createGetDisplayNameForCollectionLeafResource(String displayName) {
        }
    }
}

