/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.v3.common.ActionReporter;
import java.util.Properties;
import java.util.TreeMap;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.config.support.PropertyResolver;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="__resolve-tokens")
@Scoped(value=PerLookup.class)
public class GetTokensCommand
implements AdminCommand {
    @Inject
    private Domain domain;
    @Inject
    private Habitat habitat;
    @Param(separator=44, primary=true)
    String[] tokens;
    @Param(name="check-system-properties", defaultValue="false")
    boolean checkSystemProperties;
    @Param(optional=true)
    String target = "server";

    public void execute(AdminCommandContext context) {
        ActionReporter report = (ActionReporter)context.getActionReport();
        PropertyResolver resolver = new PropertyResolver(this.domain, this.target);
        String sep = "";
        String eol = System.getProperty("line.separator");
        StringBuilder output = new StringBuilder();
        TreeMap<String, String> values = new TreeMap<String, String>();
        Properties properties = new Properties();
        properties.put("tokens", values);
        for (String token : this.tokens) {
            String value = resolver.getPropertyValue(token);
            if (value == null && this.checkSystemProperties) {
                value = System.getProperty(token);
            }
            output.append(sep).append(token).append(" = ").append(value);
            sep = eol;
            values.put(token, value);
        }
        report.setMessage(output.toString());
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        report.setExtraProperties(properties);
    }
}

