/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.jersey.api.core.ResourceContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.RestService;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.results.OptionsResult;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionLeafResource {
    @Context
    protected HttpHeaders requestHeaders;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected ResourceContext resourceContext;
    @Context
    protected Habitat habitat;
    protected List<String> entity;
    protected Dom parent;
    protected String tagName;
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CollectionLeafResource.class);

    public void setEntity(List<String> p) {
        this.entity = p;
    }

    public List<String> getEntity() {
        return this.entity;
    }

    public void setParentAndTagName(Dom parent, String tagName) {
        this.parent = parent;
        this.tagName = tagName;
        this.entity = parent.leafElements(tagName);
    }

    @GET
    @Produces(value={"text/html;qs=2", "application/json", "application/xml", "application/x-www-form-urlencoded"})
    public ActionReportResult get(@QueryParam(value="expandLevel") @DefaultValue(value="1") int expandLevel) {
        if (this.getEntity() == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return this.buildActionReportResult();
    }

    @POST
    @Produces(value={"text/html;qs=2", "application/json", "application/xml", "application/x-www-form-urlencoded"})
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public ActionReportResult create(HashMap<String, String> data) {
        if (data.containsKey("operation") && data.get("operation").equals("__deleteoperation")) {
            data.remove("operation");
            return this.delete(data);
        }
        String postCommand = this.getPostCommand();
        Map<String, String> payload = this.processData(data, postCommand);
        return this.runCommand(postCommand, payload, "rest.resource.create.message", "\"{0}\" created successfully.", "rest.resource.post.forbidden", "POST on \"{0}\" is forbidden.");
    }

    @DELETE
    @Produces(value={"text/html;qs=2", "application/json", "application/xml", "application/x-www-form-urlencoded"})
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public ActionReportResult delete(HashMap<String, String> data) {
        ResourceUtil.addQueryString((MultivaluedMap<String, String>)this.uriInfo.getQueryParameters(), data);
        String deleteCommand = this.getDeleteCommand();
        return this.runCommand(deleteCommand, this.processData(data, deleteCommand), "rest.resource.delete.message", "\"{0}\" deleted successfully.", "rest.resource.delete.forbidden", "DELETE on \"{0}\" is forbidden.");
    }

    @OPTIONS
    @Produces(value={"application/json", "text/html;qs=2", "application/xml"})
    public ActionReportResult options() {
        return this.buildActionReportResult();
    }

    protected ActionReportResult buildActionReportResult() {
        RestActionReporter ar = new RestActionReporter();
        String typeKey = Util.upperCaseFirstLetter(Util.decode(this.getName()));
        ar.setActionDescription(typeKey);
        ar.getExtraProperties().put("leafList", this.getEntity());
        OptionsResult optionsResult = new OptionsResult(Util.getResourceName(this.uriInfo));
        Map<String, MethodMetaData> mmd = this.getMethodMetaData();
        optionsResult.putMethodMetaData("GET", mmd.get("GET"));
        optionsResult.putMethodMetaData("POST", mmd.get("POST"));
        ResourceUtil.addMethodMetaData((ActionReport)ar, mmd);
        return new ActionReportResult(ar, optionsResult);
    }

    protected Map<String, MethodMetaData> getMethodMetaData() {
        String deleteCommand;
        TreeMap<String, MethodMetaData> mmd = new TreeMap<String, MethodMetaData>();
        mmd.put("GET", new MethodMetaData());
        String postCommand = this.getPostCommand();
        if (postCommand != null) {
            MethodMetaData postMethodMetaData = ResourceUtil.getMethodMetaData(postCommand, this.habitat, RestService.logger);
            postMethodMetaData.setDescription("Create");
            mmd.put("POST", postMethodMetaData);
        }
        if ((deleteCommand = this.getDeleteCommand()) != null) {
            MethodMetaData deleteMethodMetaData = ResourceUtil.getMethodMetaData(deleteCommand, this.habitat, RestService.logger);
            deleteMethodMetaData.setDescription("Delete");
            mmd.put("DELETE", deleteMethodMetaData);
        }
        return mmd;
    }

    private void addDefaultParameter(Map<String, String> data) {
        int index = this.uriInfo.getAbsolutePath().getPath().lastIndexOf(47);
        String defaultParameterValue = this.uriInfo.getAbsolutePath().getPath().substring(index + 1);
        data.put("DEFAULT", defaultParameterValue);
    }

    protected String getPostCommand() {
        return null;
    }

    protected String getDeleteCommand() {
        return null;
    }

    protected String getName() {
        return Util.getResourceName(this.uriInfo);
    }

    private ActionReportResult runCommand(String commandName, Map<String, String> data, String successMsgKey, String successMsg, String operationForbiddenMsgKey, String operationForbiddenMsg) {
        try {
            if (data.containsKey("error")) {
                String errorMessage = localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax.");
                return ResourceUtil.getActionReportResult(400, errorMessage, this.requestHeaders, this.uriInfo);
            }
            ResourceUtil.purgeEmptyEntries(data);
            ResourceUtil.adjustParameters(data);
            String attributeName = data.get("DEFAULT");
            if (null != commandName) {
                String typeOfResult = ResourceUtil.getResultType(this.requestHeaders);
                RestActionReporter actionReport = ResourceUtil.runCommand(commandName, data, this.habitat, typeOfResult);
                ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
                if (exitCode != ActionReport.ExitCode.FAILURE) {
                    String successMessage = localStrings.getLocalString(successMsgKey, successMsg, new Object[]{attributeName});
                    return ResourceUtil.getActionReportResult(200, successMessage, this.requestHeaders, this.uriInfo);
                }
                String errorMessage = this.getErrorMessage(data, (ActionReport)actionReport);
                return ResourceUtil.getActionReportResult(400, errorMessage, this.requestHeaders, this.uriInfo);
            }
            String message = localStrings.getLocalString(operationForbiddenMsgKey, operationForbiddenMsg, new Object[]{this.uriInfo.getAbsolutePath()});
            return ResourceUtil.getActionReportResult(403, message, this.requestHeaders, this.uriInfo);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private String getErrorMessage(Map<String, String> data, ActionReport ar) {
        String message = ar.getMessage();
        return message;
    }

    private Map<String, String> processData(Map<String, String> data, String command) {
        HashMap<String, String> results = new HashMap<String, String>();
        if (command == null || !command.contains("jvm-options")) {
            return data;
        }
        StringBuilder options = new StringBuilder();
        String sep = "";
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String key = entry.getKey();
            if ("target".equals(key) || "profiler".equals(key)) {
                results.put(key, entry.getValue());
                continue;
            }
            options.append(sep).append(entry.getKey());
            String value = entry.getValue();
            if (value != null && !value.isEmpty()) {
                options.append("=").append(entry.getValue());
            }
            sep = ":";
        }
        results.put("id", options.toString());
        return results;
    }
}

