/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.clientutils.MarshallingUtils;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.external.statistics.Statistic;
import org.glassfish.external.statistics.Stats;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.datatree.TreeNode;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="domain{path:.*}")
@Produces(value={"text/html;qs=2", "application/json", "application/xml", "application/x-www-form-urlencoded"})
@Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
public class MonitoringResource {
    @PathParam(value="path")
    String path;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected Habitat habitat;
    SecureAdmin secureAdmin;
    SSLUtils sslUtils;

    @GET
    @Produces(value={"application/json", "application/xml", "text/html;qs=2"})
    public ActionReportResult getChildNodes() {
        String root;
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        RestActionReporter ar = new RestActionReporter();
        ar.setActionDescription("Monitoring Data");
        ar.setMessage("");
        ar.setSuccess();
        ActionReportResult result = new ActionReportResult(ar);
        MonitoringRuntimeDataRegistry monitoringRegistry = (MonitoringRuntimeDataRegistry)this.habitat.getComponent(MonitoringRuntimeDataRegistry.class);
        if (this.path == null) {
            return result;
        }
        if (monitoringRegistry == null) {
            return result;
        }
        String currentInstanceName = System.getProperty("com.sun.aas.instanceName");
        if (this.path.equals("") || this.path.equals("/")) {
            TreeNode serverNode = monitoringRegistry.get(currentInstanceName);
            if (serverNode != null) {
                if (!serverNode.getEnabledChildNodes().isEmpty()) {
                    list.add(serverNode);
                    this.constructEntity(list, ar);
                }
                return result;
            }
            return result;
        }
        if (this.path.startsWith("/")) {
            this.path = this.path.substring(1);
        }
        if (!this.path.startsWith(currentInstanceName)) {
            this.proxyRequestForInstanceData(ar);
            return result;
        }
        this.path = this.path.replaceAll("\\.", "\\\\.");
        String dottedName = this.path.replace('/', '.');
        int index = dottedName.indexOf(46);
        if (index != -1) {
            root = dottedName.substring(0, dottedName.indexOf(46));
            dottedName = dottedName.substring(dottedName.indexOf(46) + 1);
        } else {
            root = dottedName;
            dottedName = "";
        }
        TreeNode rootNode = monitoringRegistry.get(root);
        if (rootNode == null) {
            return result;
        }
        TreeNode currentNode = dottedName.length() > 0 ? rootNode.getNode(dottedName) : rootNode;
        if (currentNode == null) {
            return result;
        }
        if (currentNode.hasChildNodes()) {
            list.addAll(currentNode.getEnabledChildNodes());
        } else {
            Object r = currentNode.getValue();
            System.out.println("result: " + r);
            list.add(currentNode);
        }
        this.constructEntity(list, ar);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proxyRequestForInstanceData(RestActionReporter ar) {
        block7: {
            String targetInstanceName = this.path.substring(0, this.path.indexOf(47));
            Client client = null;
            try {
                String jsonDoc;
                Map responseMap;
                Map resultExtraProperties;
                client = Client.create();
                Domain domain = (Domain)this.habitat.getComponent(Domain.class);
                Server server = domain.getServerNamed(targetInstanceName);
                if (server == null) break block7;
                String forwardURL = this.uriInfo.getAbsolutePathBuilder().host(server.getAdminHost()).port(server.getAdminPort()).build(new Object[0]).toASCIIString();
                WebResource.Builder resourceBuilder = client.resource(forwardURL).accept(new String[]{"application/json"});
                this.addAuthenticationInfo(client, resourceBuilder, server);
                ClientResponse response = (ClientResponse)resourceBuilder.get(ClientResponse.class);
                ClientResponse.Status status = ClientResponse.Status.fromStatusCode((int)response.getStatus());
                if (status.getFamily() != Response.Status.Family.SUCCESSFUL || (resultExtraProperties = (Map)(responseMap = MarshallingUtils.buildMapFromDocument(jsonDoc = (String)response.getEntity(String.class))).get("extraProperties")) == null) break block7;
                Properties responseExtraProperties = ar.getExtraProperties();
                responseExtraProperties.put("entity", resultExtraProperties.get("entity"));
                Map childResources = (Map)resultExtraProperties.get("childResources");
                for (Map.Entry entry : childResources.entrySet()) {
                    String targetURL = null;
                    try {
                        URL originalURL = new URL((String)entry.getValue());
                        targetURL = this.uriInfo.getBaseUriBuilder().replacePath(originalURL.getFile()).build(new Object[0]).toASCIIString();
                    }
                    catch (MalformedURLException e) {
                        // empty catch block
                    }
                    entry.setValue(targetURL);
                }
                responseExtraProperties.put("childResources", childResources);
            }
            finally {
                if (client != null) {
                    client.destroy();
                }
            }
        }
    }

    private void constructEntity(List<TreeNode> nodeList, RestActionReporter ar) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (TreeNode node : nodeList) {
            if (node.hasChildNodes()) continue;
            Object value = node.getValue();
            if (value == null) {
                return;
            }
            try {
                if (value instanceof Statistic) {
                    Statistic statisticObject = (Statistic)value;
                    Map<String, Object> data = ProviderUtil.getStatistic(statisticObject);
                    map.put(node.getName(), data);
                    continue;
                }
                if (value instanceof Stats) {
                    TreeMap<String, Map<String, Object>> subMap = new TreeMap<String, Map<String, Object>>();
                    for (Statistic statistic : ((Stats)value).getStatistics()) {
                        Map<String, Object> data2 = ProviderUtil.getStatistic(statistic);
                        subMap.put(statistic.getName(), data2);
                    }
                    map.put(node.getName(), subMap);
                    continue;
                }
                map.put(node.getName(), ProviderUtil.jsonValue(value));
            }
            catch (Exception exception) {}
        }
        ar.getExtraProperties().put("entity", map);
        TreeMap<String, String> links = new TreeMap<String, String>();
        for (TreeNode node : nodeList) {
            if (!node.hasChildNodes()) continue;
            String name = node.getName();
            name = name.replaceAll("\\\\.", "\\.");
            links.put(name, ProviderUtil.getElementLink(this.uriInfo, name));
        }
        ar.getExtraProperties().put("childResources", links);
    }

    private void addAuthenticationInfo(Client client, WebResource.Builder resourceBuilder, Server server) {
        SecureAdmin secureAdmin = this.getSecureAdmin();
        if (SecureAdmin.Util.isEnabled((SecureAdmin)secureAdmin)) {
            HTTPSProperties httpsProperties = new HTTPSProperties((HostnameVerifier)new BasicHostnameVerifier(server.getAdminHost()), this.getSSLUtils().getAdminSSLContext(SecureAdmin.Util.DASAlias((SecureAdmin)secureAdmin), "TLS"));
            client.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", httpsProperties);
        } else {
            resourceBuilder.header("X-GlassFish-admin", (Object)SecureAdmin.Util.configuredAdminIndicator((SecureAdmin)secureAdmin));
        }
    }

    private SSLUtils getSSLUtils() {
        if (this.sslUtils == null) {
            this.sslUtils = (SSLUtils)this.habitat.getComponent(SSLUtils.class);
        }
        return this.sslUtils;
    }

    private SecureAdmin getSecureAdmin() {
        if (this.secureAdmin == null) {
            this.secureAdmin = (SecureAdmin)this.habitat.getComponent(SecureAdmin.class);
        }
        return this.secureAdmin;
    }

    private static class BasicHostnameVerifier
    implements HostnameVerifier {
        private final String host;

        public BasicHostnameVerifier(String host) {
            if (host == null) {
                throw new IllegalArgumentException("null host");
            }
            this.host = host;
        }

        public boolean verify(String s, SSLSession sslSession) {
            return this.host.equals(s);
        }
    }
}

