/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.RestService;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.resources.TemplateResource;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.results.OptionsResult;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.RestRedirect;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TemplateListOfResource {
    private static final String QUERY_PARAMETERS = "queryParameters";
    private static final String MESSAGE_PARAMETERS = "messageParameters";
    @Context
    protected HttpHeaders requestHeaders;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected ResourceContext resourceContext;
    @Context
    protected Habitat habitat;
    protected List<Dom> entity;
    protected Dom parent;
    protected String tagName;
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(TemplateListOfResource.class);

    @GET
    @Produces(value={"text/html;qs=2", "application/json", "application/xml"})
    public Response get(@QueryParam(value="expandLevel") @DefaultValue(value="1") int expandLevel) {
        return Response.ok().entity((Object)this.buildActionReportResult()).build();
    }

    @POST
    @Produces(value={"text/html;qs=2", "application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public Response createResource(HashMap<String, String> data) {
        try {
            if (data.containsKey("error")) {
                String errorMessage = localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax.");
                ActionReportResult arr = ResourceUtil.getActionReportResult(400, errorMessage, this.requestHeaders, this.uriInfo);
                return Response.status((int)400).entity((Object)arr).build();
            }
            ResourceUtil.purgeEmptyEntries(data);
            String commandName = this.getPostCommand();
            String resourceToCreate = this.uriInfo.getAbsolutePath() + "/";
            if (null != commandName) {
                ResourceUtil.adjustParameters(data);
                resourceToCreate = data.containsKey("name") ? resourceToCreate + data.get("name") : resourceToCreate + data.get("DEFAULT");
                String typeOfResult = ResourceUtil.getResultType(this.requestHeaders);
                RestActionReporter actionReport = ResourceUtil.runCommand(commandName, data, this.habitat, typeOfResult);
                ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
                if (exitCode != ActionReport.ExitCode.FAILURE) {
                    String successMessage = localStrings.getLocalString("rest.resource.create.message", "\"{0}\" created successfully.", new Object[]{resourceToCreate});
                    ActionReportResult arr = ResourceUtil.getActionReportResult(201, successMessage, this.requestHeaders, this.uriInfo);
                    return Response.ok((Object)arr).build();
                }
                String errorMessage = this.getErrorMessage(data, (ActionReport)actionReport);
                ActionReportResult arr = ResourceUtil.getActionReportResult(400, errorMessage, this.requestHeaders, this.uriInfo);
                return Response.status((int)400).entity((Object)arr).build();
            }
            ActionReportResult arr = ResourceUtil.getActionReportResult(400, "No CRUD Create possible.", this.requestHeaders, this.uriInfo);
            return Response.status((int)500).entity((Object)arr).build();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    public Response post(FormDataMultiPart formData) {
        HashMap<String, String> data = TemplateResource.createDataBasedOnForm(formData);
        return this.createResource(data, data.get("name"));
    }

    @OPTIONS
    @Produces(value={"application/json", "text/html", "application/xml"})
    public Response options() {
        return Response.ok().entity((Object)this.buildActionReportResult()).build();
    }

    public void setEntity(List<Dom> p) {
        this.entity = p;
    }

    public List<Dom> getEntity() {
        return this.entity;
    }

    public void setParentAndTagName(Dom parent, String tagName) {
        this.parent = parent;
        this.tagName = tagName;
        if (parent != null) {
            this.entity = parent.nodeElements(tagName);
        }
    }

    public String getPostCommand() {
        ConfigModel.Property p = this.parent.model.getElement(this.tagName);
        if (p == null) {
            ConfigModel.Property childElement = this.parent.model.getElement("*");
            if (childElement != null) {
                ConfigModel.Node node = (ConfigModel.Node)childElement;
                ConfigModel childModel = node.getModel();
                List<ConfigModel> subChildConfigModels = ResourceUtil.getRealChildConfigModels(childModel, this.parent.document);
                for (ConfigModel subChildConfigModel : subChildConfigModels) {
                    if (!subChildConfigModel.getTagName().equals(this.tagName)) continue;
                    return ResourceUtil.getCommand(RestRedirect.OpType.POST, subChildConfigModel);
                }
            }
        } else {
            ConfigModel.Node n = (ConfigModel.Node)p;
            return ResourceUtil.getCommand(RestRedirect.OpType.POST, n.getModel());
        }
        return null;
    }

    public String[][] getCommandResourcesPaths() {
        return new String[0][];
    }

    public static Class<? extends ConfigBeanProxy> getElementTypeByName(Dom parentDom, String elementName) throws ClassNotFoundException {
        DomDocument document = parentDom.document;
        ConfigModel.Property a = parentDom.model.getElement(elementName);
        if (a != null) {
            if (a.isLeaf()) {
                return null;
            }
            ConfigModel childModel = ((ConfigModel.Node)a).getModel();
            return ((ClassLoader)childModel.classLoaderHolder.get()).loadClass(childModel.targetTypeName);
        }
        ConfigModel model = document.getModelByElementName(elementName);
        if (model != null) {
            return ((ClassLoader)model.classLoaderHolder.get()).loadClass(model.targetTypeName);
        }
        return null;
    }

    protected ActionReportResult buildActionReportResult() {
        if (this.entity == null) {
            String errorMessage = localStrings.getLocalString("rest.resource.erromessage.noentity", "Resource not found.");
            return ResourceUtil.getActionReportResult(404, errorMessage, this.requestHeaders, this.uriInfo);
        }
        RestActionReporter ar = new RestActionReporter();
        String typeKey = Util.upperCaseFirstLetter(Util.decode(Util.getName(this.uriInfo.getPath(), '/')));
        ar.setActionDescription(typeKey);
        OptionsResult optionsResult = new OptionsResult(Util.getResourceName(this.uriInfo));
        Map<String, MethodMetaData> mmd = this.getMethodMetaData();
        optionsResult.putMethodMetaData("GET", mmd.get("GET"));
        optionsResult.putMethodMetaData("POST", mmd.get("POST"));
        ResourceUtil.addMethodMetaData((ActionReport)ar, mmd);
        ar.getExtraProperties().put("childResources", ResourceUtil.getResourceLinks(this.getEntity(), this.uriInfo));
        ar.getExtraProperties().put("commands", ResourceUtil.getCommandLinks(this.getCommandResourcesPaths()));
        return new ActionReportResult(ar, optionsResult);
    }

    private Response createResource(HashMap<String, String> data, String resourceToCreate) {
        try {
            if (data.containsKey("error")) {
                String errorMessage = localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax.");
                return Response.status((int)400).entity((Object)ResourceUtil.getActionReportResult(400, errorMessage, this.requestHeaders, this.uriInfo)).build();
            }
            ResourceUtil.purgeEmptyEntries(data);
            String commandName = this.getPostCommand();
            ResourceUtil.defineDefaultParameters(data);
            if (resourceToCreate == null || resourceToCreate.equals("")) {
                String newResourceName = data.get("DEFAULT");
                if (newResourceName.contains("/")) {
                    newResourceName = Util.getName(newResourceName, '/');
                } else if (newResourceName.contains("\\")) {
                    newResourceName = Util.getName(newResourceName, '\\');
                }
                resourceToCreate = this.uriInfo.getAbsolutePath() + "/" + newResourceName;
            } else {
                resourceToCreate = this.uriInfo.getAbsolutePath() + "/" + resourceToCreate;
            }
            if (null != commandName) {
                String typeOfResult = ResourceUtil.getResultType(this.requestHeaders);
                RestActionReporter actionReport = ResourceUtil.runCommand(commandName, data, this.habitat, typeOfResult);
                ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
                if (exitCode != ActionReport.ExitCode.FAILURE) {
                    String successMessage = localStrings.getLocalString("rest.resource.create.message", "\"{0}\" created successfully.", new Object[]{resourceToCreate});
                    return Response.ok().entity((Object)ResourceUtil.getActionReportResult(201, successMessage, this.requestHeaders, this.uriInfo)).build();
                }
                String errorMessage = this.getErrorMessage(data, (ActionReport)actionReport);
                return Response.status((int)400).entity((Object)ResourceUtil.getActionReportResult(400, errorMessage, this.requestHeaders, this.uriInfo)).build();
            }
            String message = localStrings.getLocalString("rest.resource.post.forbidden", "POST on \"{0}\" is forbidden.", new Object[]{resourceToCreate});
            return Response.status((int)403).entity((Object)ResourceUtil.getActionReportResult(403, message, this.requestHeaders, this.uriInfo)).build();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Map<String, MethodMetaData> getMethodMetaData() {
        TreeMap<String, MethodMetaData> map = new TreeMap<String, MethodMetaData>();
        map.put("GET", new MethodMetaData());
        String command = this.getPostCommand();
        if (command != null) {
            MethodMetaData postMethodMetaData = ResourceUtil.getMethodMetaData(command, this.habitat, RestService.logger);
            if (Util.getResourceName(this.uriInfo).equals("Application")) {
                postMethodMetaData.setIsFileUploadOperation(true);
            }
            map.put("POST", postMethodMetaData);
        }
        return map;
    }

    private String getErrorMessage(HashMap<String, String> data, ActionReport ar) {
        String message = ar.getMessage();
        return message;
    }
}

