/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.rest.generator.ClassWriter;
import org.glassfish.admin.rest.generator.GeneratorException;
import org.glassfish.admin.rest.generator.ResourcesGeneratorBase;
import org.glassfish.admin.rest.generator.TextClassWriter;
import org.jvnet.hk2.component.Habitat;

public class TextResourcesGenerator
extends ResourcesGeneratorBase {
    private File generationDir;

    public TextResourcesGenerator(String outputDir, Habitat habitat) {
        super(habitat);
        this.generationDir = new File(outputDir);
        this.generationDir.mkdirs();
    }

    public ClassWriter getClassWriter(String className, String baseClassName, String resourcePath) {
        TextClassWriter writer = null;
        try {
            writer = new TextClassWriter(this.habitat, this.generationDir, className, baseClassName, resourcePath);
        }
        catch (IOException e) {
            Logger.getLogger(TextResourcesGenerator.class.getName()).log(Level.SEVERE, e.getMessage());
            throw new GeneratorException(e);
        }
        return writer;
    }

    public String endGeneration() {
        File file = new File(this.generationDir + "/codegeneration.properties");
        try {
            file.createNewFile();
            FileWriter fstream = new FileWriter(file);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write("generation_date=" + new Date() + "\n");
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "Code Generation done at : " + this.generationDir;
    }
}

