/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.RestService;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.results.OptionsResult;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ParameterMap;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateExecCommand {
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(TemplateExecCommand.class);
    @Context
    protected HttpHeaders requestHeaders;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected Habitat habitat;
    protected String resourceName;
    protected String commandName;
    protected String commandDisplayName;
    protected String commandMethod;
    protected String commandAction;
    protected boolean isLinkedToParent = false;
    protected Logger logger = Logger.getLogger(TemplateExecCommand.class.getName());

    public TemplateExecCommand(String resourceName, String commandName, String commandMethod, String commandAction, String commandDisplayName, boolean isLinkedToParent) {
        this.resourceName = resourceName;
        this.commandName = commandName;
        this.commandMethod = commandMethod;
        this.commandAction = commandAction;
        this.commandDisplayName = commandDisplayName;
        this.isLinkedToParent = isLinkedToParent;
    }

    @OPTIONS
    @Produces(value={"application/json", "text/html;qs=2", "application/xml"})
    public ActionReportResult options() {
        RestActionReporter ar = new RestActionReporter();
        ar.setExtraProperties(new Properties());
        ar.setActionDescription(this.commandDisplayName);
        OptionsResult optionsResult = new OptionsResult(this.resourceName);
        HashMap<String, MethodMetaData> mmd = new HashMap<String, MethodMetaData>();
        MethodMetaData methodMetaData = ResourceUtil.getMethodMetaData(this.commandName, this.getCommandParams(), this.habitat, RestService.logger);
        optionsResult.putMethodMetaData(this.commandMethod, methodMetaData);
        mmd.put(this.commandMethod, methodMetaData);
        ResourceUtil.addMethodMetaData((ActionReport)ar, mmd);
        ActionReportResult ret = new ActionReportResult(ar, null, optionsResult);
        ret.setCommandDisplayName(this.commandDisplayName);
        return ret;
    }

    protected Response executeCommand(ParameterMap data) {
        RestActionReporter actionReport = ResourceUtil.runCommand(this.commandName, data, this.habitat, ResourceUtil.getResultType(this.requestHeaders));
        ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
        ActionReportResult option = this.options();
        ActionReportResult results = new ActionReportResult(this.commandName, actionReport, option.getMetaData());
        results.getActionReport().getExtraProperties().putAll((Map<?, ?>)option.getActionReport().getExtraProperties());
        results.setCommandDisplayName(this.commandDisplayName);
        int status = 200;
        if (exitCode == ActionReport.ExitCode.FAILURE) {
            status = 500;
        }
        results.setStatusCode(status);
        return Response.status((int)status).entity((Object)results).build();
    }

    protected HashMap<String, String> getCommandParams() {
        return null;
    }

    protected void processCommandParams(ParameterMap data) {
        HashMap<String, String> commandParams = this.getCommandParams();
        if (commandParams != null) {
            for (Map.Entry<String, String> entry : commandParams.entrySet()) {
                String value = entry.getValue();
                if (!"$grandparent".equals(value)) continue;
                entry.setValue(Util.getGrandparentName(this.uriInfo));
            }
            if (this.isLinkedToParent) {
                ResourceUtil.resolveParentParamValue(commandParams, this.uriInfo);
            }
            for (Map.Entry<String, String> entry : commandParams.entrySet()) {
                data.add((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
    }

    protected void addQueryString(MultivaluedMap<String, String> qs, ParameterMap data) {
        for (Map.Entry entry : qs.entrySet()) {
            String key = (String)entry.getKey();
            for (String value : (List)entry.getValue()) {
                data.add((Object)key, (Object)value);
            }
        }
    }

    protected void adjustParameters(ParameterMap data) {
        if (data != null) {
            boolean isRenamed;
            if (!data.containsKey((Object)"DEFAULT") && !(isRenamed = this.renameParameter(data, "name", "DEFAULT"))) {
                this.renameParameter(data, "id", "DEFAULT");
            }
            data.remove((Object)"jsoncallback");
            data.remove((Object)"_");
        }
    }

    protected boolean renameParameter(ParameterMap data, String parameterToRename, String newName) {
        if (data.containsKey((Object)parameterToRename)) {
            List value = data.get((Object)parameterToRename);
            data.remove((Object)parameterToRename);
            data.set((Object)newName, (Collection)value);
            return true;
        }
        return false;
    }

    protected void purgeEmptyEntries(ParameterMap data) {
        HashSet keyToRemove = new HashSet();
        Set entries = data.entrySet();
        for (Map.Entry entry : entries) {
            if (entry.getValue() != null && !((List)entry.getValue()).isEmpty()) continue;
            keyToRemove.add(entry.getKey());
        }
        if ("true".equals(data.getOne((Object)"__remove_empty_entries__"))) {
            data.remove((Object)"__remove_empty_entries__");
            Set entries2 = data.entrySet();
            for (Map.Entry entry : entries2) {
                if (((List)entry.getValue()).size() != 1 || !((String)((List)entry.getValue()).get(0)).equals("")) continue;
                keyToRemove.add(entry.getKey());
            }
        }
        for (String k : keyToRemove) {
            data.remove((Object)k);
        }
    }

    protected String getParent(UriInfo uriInfo) {
        List segments = uriInfo.getPathSegments(true);
        String parent = ((PathSegment)segments.get(segments.size() - 2)).getPath();
        return parent;
    }
}

