/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.config.serverbeans.Domain;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.glassfish.admin.rest.RestService;
import org.glassfish.admin.rest.generator.ClassWriter;
import org.glassfish.admin.rest.generator.CommandResourceMetaData;
import org.glassfish.admin.rest.generator.ResourcesGeneratorBase;
import org.glassfish.admin.rest.resources.GeneratorResource;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestRedirect;
import org.glassfish.api.admin.RestRedirects;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/status/")
public class StatusGenerator {
    @Context
    protected Habitat habitat;
    protected StringBuilder status = new StringBuilder();
    private Set<String> commandsUsed = new TreeSet<String>();
    private Set<String> allCommands = new TreeSet<String>();
    private Set<String> restRedirectCommands = new TreeSet<String>();
    private Map<String, String> commandsToResources = new TreeMap<String, String>();
    private Map<String, String> resourcesToDeleteCommands = new TreeMap<String, String>();
    private Properties propsI18N = new Properties();

    @GET
    @Produces(value={"text/plain"})
    public String get() {
        try {
            Domain entity = (Domain)this.habitat.getComponent(Domain.class);
            Dom dom = Dom.unwrap((ConfigBeanProxy)entity);
            DomDocument document = dom.document;
            ConfigModel rootModel = dom.document.getRoot().model;
            NOOPResourcesGenerator resourcesGenerator = new NOOPResourcesGenerator(this.habitat);
            resourcesGenerator.generateSingle(rootModel, document);
            resourcesGenerator.endGeneration();
        }
        catch (Exception ex) {
            Logger.getLogger(GeneratorResource.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.status.append("\n------------------------");
        this.status.append("All Commands used in REST Admin:\n");
        for (String ss : this.commandsUsed) {
            this.status.append(ss + "\n");
        }
        this.listOfCommands();
        for (String ss : this.commandsUsed) {
            this.allCommands.remove(ss);
        }
        this.status.append("\n------------------------");
        this.status.append("Missing Commands not used in REST Admin:\n");
        for (String ss : this.allCommands) {
            if (this.hasTargetParam(ss).booleanValue()) {
                this.status.append(ss + "          has a target param " + "\n");
                continue;
            }
            this.status.append(ss + "\n");
        }
        this.status.append("\n------------------------");
        this.status.append("REST-REDIRECT Commands defined on ConfigBeans:\n");
        for (String ss : this.restRedirectCommands) {
            this.status.append(ss + "\n");
        }
        this.status.append("\n------------------------");
        this.status.append("Commands to Resources Mapping Usage in REST Admin:\n");
        for (String ss : this.commandsToResources.keySet()) {
            if (this.hasTargetParam(ss).booleanValue()) {
                this.status.append(ss + "   :::target:::   " + this.commandsToResources.get(ss) + "\n");
                continue;
            }
            this.status.append(ss + "      :::      " + this.commandsToResources.get(ss) + "\n");
        }
        this.status.append("\n------------------------");
        this.status.append("Resources with Delete Commands in REST Admin (not counting RESTREDIRECT:\n");
        for (String ss : this.resourcesToDeleteCommands.keySet()) {
            this.status.append(ss + "      :::      " + this.resourcesToDeleteCommands.get(ss) + "\n");
        }
        try {
            FileOutputStream f = new FileOutputStream(System.getProperty("user.home") + "/GlassFishI18NData.properties");
            this.propsI18N.store(f, "");
            f.close();
        }
        catch (Exception ex) {
            Logger.getLogger(StatusGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.status.toString();
    }

    public void listOfCommands() {
        CommandRunner cr = (CommandRunner)this.habitat.getComponent(CommandRunner.class);
        RestActionReporter ar = new RestActionReporter();
        ParameterMap parameters = new ParameterMap();
        cr.getCommandInvocation("list-commands", (ActionReport)ar).parameters(parameters).execute();
        List children = ar.getTopMessagePart().getChildren();
        for (ActionReport.MessagePart part : children) {
            this.allCommands.add(part.getMessage());
        }
        ar = new RestActionReporter();
        parameters = new ParameterMap();
        parameters.add((Object)"DEFAULT", (Object)"_");
        cr.getCommandInvocation("list-commands", (ActionReport)ar).parameters(parameters).execute();
        children = ar.getTopMessagePart().getChildren();
        for (ActionReport.MessagePart part : children) {
            this.allCommands.add(part.getMessage());
        }
    }

    public Boolean hasTargetParam(String command) {
        try {
            if (command != null) {
                Collection<CommandModel.ParamModel> params = this.getParamMetaData(command);
                for (CommandModel.ParamModel paramModel : params) {
                    if (!paramModel.getName().equals("target")) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public Collection<CommandModel.ParamModel> getParamMetaData(String commandName) {
        CommandRunner cr = (CommandRunner)this.habitat.getComponent(CommandRunner.class);
        CommandModel cm = cr.getModel(commandName, RestService.logger);
        Collection params = cm.getParameters();
        return params;
    }

    class NOOPResourcesGenerator
    extends ResourcesGeneratorBase {
        public NOOPResourcesGenerator(Habitat h) {
            super(h);
        }

        public ClassWriter getClassWriter(String className, String baseClassName, String resourcePath) {
            return new NOOPClassWriter(className, baseClassName, resourcePath);
        }

        public String endGeneration() {
            return "done";
        }

        public void configModelVisited(ConfigModel model) {
            for (String a : model.getAttributeNames()) {
                StatusGenerator.this.propsI18N.setProperty(model.targetTypeName + "." + a, "");
            }
            Class<?> cbp = null;
            try {
                cbp = ((ClassLoader)model.classLoaderHolder.get()).loadClass(model.targetTypeName);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return;
            }
            RestRedirects restRedirects = cbp.getAnnotation(RestRedirects.class);
            if (restRedirects != null) {
                RestRedirect[] values;
                for (RestRedirect r : values = restRedirects.value()) {
                    StatusGenerator.this.commandsUsed.add(r.commandName());
                    StatusGenerator.this.restRedirectCommands.add(r.commandName());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NOOPClassWriter
    implements ClassWriter {
        private String className;

        public NOOPClassWriter(String className, String baseClassName, String resourcePath) {
            this.className = className;
            if (baseClassName.equals("TemplateRestResource")) {
                StatusGenerator.this.resourcesToDeleteCommands.put(className, "");
            }
        }

        @Override
        public void createGetCommandResourcePaths(List<CommandResourceMetaData> commandMetaData) {
            for (CommandResourceMetaData metaData : commandMetaData) {
                StatusGenerator.this.commandsUsed.add(metaData.command);
                if (StatusGenerator.this.commandsToResources.containsKey(metaData.command)) {
                    String val = (String)StatusGenerator.this.commandsToResources.get(metaData.command) + ", " + this.className;
                    StatusGenerator.this.commandsToResources.put(metaData.command, val);
                    continue;
                }
                StatusGenerator.this.commandsToResources.put(metaData.command, this.className);
            }
        }

        @Override
        public void createGetCommandResource(String commandResourceClassName, String resourcePath) {
        }

        @Override
        public void createCommandResourceConstructor(String commandResourceClassName, String commandName, String httpMethod, boolean linkedToParent, CommandResourceMetaData.ParameterMetaData[] commandParams, String commandDisplayName, String commandAction) {
        }

        @Override
        public void createCustomResourceMapping(String resourceClassName, String mappingPath) {
        }

        @Override
        public void done() {
        }

        @Override
        public void createGetDeleteCommand(String commandName) {
            StatusGenerator.this.commandsUsed.add(commandName);
            if (StatusGenerator.this.commandsToResources.containsKey(commandName)) {
                String val = (String)StatusGenerator.this.commandsToResources.get(commandName) + ", " + this.className;
                StatusGenerator.this.commandsToResources.put(commandName, val);
            } else {
                StatusGenerator.this.commandsToResources.put(commandName, this.className);
            }
            StatusGenerator.this.resourcesToDeleteCommands.put(this.className, commandName);
        }

        @Override
        public void createGetPostCommand(String commandName) {
            StatusGenerator.this.commandsUsed.add(commandName);
            if (StatusGenerator.this.commandsToResources.containsKey(commandName)) {
                String val = (String)StatusGenerator.this.commandsToResources.get(commandName) + ", " + this.className;
                StatusGenerator.this.commandsToResources.put(commandName, val);
            } else {
                StatusGenerator.this.commandsToResources.put(commandName, this.className);
            }
        }

        @Override
        public void createGetChildResource(String path, String childResourceClassName) {
        }

        @Override
        public void createGetChildResourceForListResources(String keyAttributeName, String childResourceClassName) {
        }

        @Override
        public void createGetPostCommandForCollectionLeafResource(String commandName) {
            StatusGenerator.this.commandsUsed.add(commandName);
            if (StatusGenerator.this.commandsToResources.containsKey(commandName)) {
                String val = (String)StatusGenerator.this.commandsToResources.get(commandName) + ", " + this.className;
                StatusGenerator.this.commandsToResources.put(commandName, val);
            } else {
                StatusGenerator.this.commandsToResources.put(commandName, this.className);
            }
        }

        @Override
        public void createGetDeleteCommandForCollectionLeafResource(String commandName) {
            StatusGenerator.this.commandsUsed.add(commandName);
            if (StatusGenerator.this.commandsToResources.containsKey(commandName)) {
                String val = (String)StatusGenerator.this.commandsToResources.get(commandName) + ", " + this.className;
                StatusGenerator.this.commandsToResources.put(commandName, val);
            } else {
                StatusGenerator.this.commandsToResources.put(commandName, this.className);
            }
        }

        @Override
        public void createGetDisplayNameForCollectionLeafResource(String displayName) {
        }
    }
}

