/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.adapter;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.module.common_impl.LogHelper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.AdminAdapter;
import com.sun.enterprise.v3.admin.adapter.AdminEndpointDecider;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.login.LoginException;
import org.glassfish.admin.rest.LazyJerseyInterface;
import org.glassfish.admin.rest.RestService;
import org.glassfish.admin.rest.SessionManager;
import org.glassfish.admin.rest.provider.ActionReportResultHtmlProvider;
import org.glassfish.admin.rest.provider.ActionReportResultJsonProvider;
import org.glassfish.admin.rest.provider.ActionReportResultXmlProvider;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.Adapter;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.event.RestrictTo;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.internal.api.AdminAccessController;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RestAdapter
extends HttpHandler
implements Adapter,
PostConstruct,
EventListener {
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(RestAdapter.class);
    @Inject
    volatile AdminService as = null;
    @Inject
    Events events;
    @Inject
    Habitat habitat;
    @Inject(name="default-instance-name")
    Config config;
    CountDownLatch latch = new CountDownLatch(1);
    @Inject
    ServerContext sc;
    @Inject
    ServerEnvironment serverEnvironment;
    private volatile LazyJerseyInterface lazyJerseyInterface = null;
    @Inject
    private Logger logger;
    private Map<Integer, String> httpStatus = new HashMap<Integer, String>(){
        {
            this.put(404, "Resource not found");
            this.put(500, "A server error occurred. Please check the server logs.");
        }
    };
    private volatile HttpHandler adapter = null;
    private boolean isRegistered = false;
    private AdminEndpointDecider epd = null;

    protected RestAdapter() {
        this.setAllowEncodedSlash(true);
    }

    public void postConstruct() {
        this.epd = new AdminEndpointDecider(this.config, this.logger);
        this.events.register((EventListener)this);
    }

    public HttpHandler getHttpService() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void service(Request req, Response res) {
        LogHelper.getDefaultLogger().finer("Rest adapter !");
        LogHelper.getDefaultLogger().finer("Received resource request: " + req.getRequestURI());
        try {
            String message;
            res.setCharacterEncoding("UTF-8");
            if (!this.latch.await(20L, TimeUnit.SECONDS)) {
                String msg = localStrings.getLocalString("rest.adapter.server.wait", "Server cannot process this command at this time, please wait");
                this.reportError(req, res, 503, msg);
                return;
            }
            if (this.serverEnvironment.isInstance() && !Method.GET.equals(req.getMethod())) {
                String msg = localStrings.getLocalString("rest.resource.only.GET.on.instance", "Only GET requests are allowed on an instance that is not DAS.");
                this.reportError(req, res, 403, msg);
                return;
            }
            if (!this.authenticate(req)) {
                String msg = localStrings.getLocalString("rest.adapter.auth.userpassword", "Invalid user name or password");
                res.setHeader("WWW-Authenticate", "BASIC");
                this.reportError(req, res, 401, msg);
                return;
            }
            if (this.adapter == null) {
                Class<HttpHandler> msg = HttpHandler.class;
                // MONITORENTER : org.glassfish.grizzly.http.server.HttpHandler.class
                if (this.adapter == null) {
                    this.exposeContext();
                }
                // MONITOREXIT : msg
            }
            this.adapter.service(req, res);
            int status = res.getStatus();
            if (status >= 200) {
                if (status <= 299) return;
            }
            if ((message = this.httpStatus.get(status)) != null) return;
            message = "Request returned " + status;
            return;
        }
        catch (InterruptedException e) {
            String msg = localStrings.getLocalString("rest.adapter.server.wait", "Server cannot process this command at this time, please wait");
            this.reportError(req, res, 503, msg);
            return;
        }
        catch (IOException e) {
            String msg = localStrings.getLocalString("rest.adapter.server.ioexception", "REST: IO Exception " + e.getLocalizedMessage());
            this.reportError(req, res, 503, msg);
            return;
        }
        catch (LoginException e) {
            String msg = localStrings.getLocalString("rest.adapter.auth.error", "Error authenticating");
            this.reportError(req, res, 401, msg);
            return;
        }
        catch (Exception e) {
            StringWriter result = new StringWriter();
            PrintWriter printWriter = new PrintWriter(result);
            e.printStackTrace(printWriter);
            String msg = localStrings.getLocalString("rest.adapter.server.exception", "REST:  Exception " + result.toString());
            this.reportError(req, res, 503, msg);
            return;
        }
    }

    private boolean authenticate(Request req) throws LoginException, IOException {
        boolean authenticated = this.authenticateViaAnonymousUser(req);
        if (!(authenticated || (authenticated = this.authenticateViaLocalPassword(req)) || (authenticated = this.authenticateViaRestToken(req)))) {
            authenticated = this.authenticateViaAdminRealm(req);
        }
        return authenticated;
    }

    private boolean authenticateViaAnonymousUser(Request req) {
        return false;
    }

    private boolean authenticateViaRestToken(Request req) {
        boolean authenticated = false;
        Cookie[] cookies = req.getCookies();
        String restToken = null;
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"gfresttoken".equals(cookie.getName())) continue;
                restToken = cookie.getValue();
            }
        }
        if (restToken != null) {
            authenticated = SessionManager.getSessionManager().authenticate(restToken, req);
        }
        return authenticated;
    }

    private boolean authenticateViaLocalPassword(Request req) {
        Cookie[] cookies = req.getCookies();
        boolean authenticated = false;
        String uid = RestService.getRestUID();
        if (uid != null && cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("gfrestuid") || !cookie.getValue().equals(uid)) continue;
                authenticated = true;
                break;
            }
        }
        return authenticated;
    }

    private boolean authenticateViaAdminRealm(Request req) throws LoginException, IOException {
        String[] up = AdminAdapter.getUserPassword((Request)req);
        String user = up[0];
        String password = up.length > 1 ? up[1] : "";
        AdminAccessController authenticator = (AdminAccessController)this.habitat.getByContract(AdminAccessController.class);
        if (authenticator != null) {
            return authenticator.loginAsAdmin(user, password, this.as.getAuthRealmName(), req.getRemoteHost(), this.getAuthRelatedHeaders(req), req.getUserPrincipal()) != AdminAccessController.Access.NONE;
        }
        return true;
    }

    private Map<String, String> getAuthRelatedHeaders(Request req) {
        HashMap<String, String> authRelatedHeaders = Collections.EMPTY_MAP;
        String adminIndicatorHeader = req.getHeader("X-GlassFish-admin");
        if (adminIndicatorHeader != null) {
            authRelatedHeaders = new HashMap<String, String>(1);
            authRelatedHeaders.put("X-GlassFish-admin", adminIndicatorHeader);
        }
        return authRelatedHeaders;
    }

    public void fireAdapterEvent(String type, Object data) {
    }

    public void event(@RestrictTo(value="server_ready") EventListener.Event event) {
        if (event.is(EventTypes.SERVER_READY)) {
            this.latch.countDown();
            this.logger.fine("Ready to receive REST resource requests");
        }
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public void setRegistered(boolean isRegistered) {
        this.isRegistered = isRegistered;
    }

    public int getListenPort() {
        return this.epd.getListenPort();
    }

    public InetAddress getListenAddress() {
        return this.epd.getListenAddress();
    }

    public List<String> getVirtualServers() {
        return this.epd.getAsadminHosts();
    }

    protected abstract Set<Class<?>> getResourcesConfig();

    private String getAcceptedMimeType(Request req) {
        String type = null;
        String requestURI = req.getRequestURI();
        HashSet<String> acceptableTypes = new HashSet<String>(){
            {
                this.add("html");
                this.add("xml");
                this.add("json");
            }
        };
        if (requestURI.indexOf(46) != -1) {
            type = requestURI.substring(requestURI.indexOf(46) + 1);
        } else {
            String accept;
            String userAgent = req.getHeader("User-Agent");
            if (userAgent != null && (accept = req.getHeader("Accept")) != null) {
                if (accept.indexOf("html") != -1) {
                    return "html";
                }
                StringTokenizer st = new StringTokenizer(accept, ",");
                while (st.hasMoreElements()) {
                    String scheme = st.nextToken();
                    if (!acceptableTypes.contains(scheme = scheme.substring(scheme.indexOf(47) + 1))) continue;
                    type = scheme;
                    break;
                }
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LazyJerseyInterface getLazyJersey() {
        if (this.lazyJerseyInterface != null) {
            return this.lazyJerseyInterface;
        }
        Class<HttpHandler> clazz = HttpHandler.class;
        synchronized (HttpHandler.class) {
            if (this.lazyJerseyInterface == null) {
                try {
                    Class<?> lazyInitClass = Class.forName("org.glassfish.admin.rest.LazyJerseyInit");
                    this.lazyJerseyInterface = (LazyJerseyInterface)lazyInitClass.newInstance();
                }
                catch (Exception ex) {
                    this.logger.log(Level.SEVERE, "Error trying to call org.glassfish.admin.rest.LazyJerseyInit via instrospection: ", ex);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.lazyJerseyInterface;
        }
    }

    private void exposeContext() throws EndpointRegistrationException {
        String context = this.getContextRoot();
        this.logger.fine("Exposing rest resource context root: " + context);
        if (context != null || !"".equals(context)) {
            Set<Class<?>> classes = this.getResourcesConfig();
            this.adapter = this.lazyJerseyInterface.exposeContext(classes, this.sc, this.habitat);
            this.logger.info("Listening to REST requests at context: " + context + "/domain");
        }
    }

    private void reportError(Request req, Response res, int statusCode, String msg) {
        try {
            BaseProvider provider;
            RestActionReporter report = new RestActionReporter();
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setActionDescription("Error");
            report.setMessage(msg);
            String type = this.getAcceptedMimeType(req);
            if ("xml".equals(type)) {
                res.setContentType("application/xml");
                provider = new ActionReportResultXmlProvider();
            } else if ("json".equals(type)) {
                res.setContentType("application/json");
                provider = new ActionReportResultJsonProvider();
            } else {
                res.setContentType("text/html");
                provider = new ActionReportResultHtmlProvider();
            }
            res.setStatus(statusCode);
            res.getOutputStream().write(provider.getContent(new ActionReportResult(report)).getBytes());
            res.getOutputStream().flush();
            res.finish();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

