/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.config;

import com.sun.grizzly.DefaultProtocolChainInstanceHandler;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolChainInstanceHandler;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.UDPSelectorHandler;
import com.sun.grizzly.arp.AsyncFilter;
import com.sun.grizzly.arp.DefaultAsyncHandler;
import com.sun.grizzly.config.GrizzlyConfigException;
import com.sun.grizzly.config.GrizzlyServiceListener;
import com.sun.grizzly.config.HttpProtocolFilter;
import com.sun.grizzly.config.WebProtocolHandler;
import com.sun.grizzly.config.dom.FileCache;
import com.sun.grizzly.config.dom.Http;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Ssl;
import com.sun.grizzly.config.dom.ThreadPool;
import com.sun.grizzly.config.dom.Transport;
import com.sun.grizzly.filter.ReadFilter;
import com.sun.grizzly.http.HttpProtocolChain;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.StatsThreadPool;
import com.sun.grizzly.http.portunif.HttpProtocolFinder;
import com.sun.grizzly.portunif.PUPreProcessor;
import com.sun.grizzly.tcp.Adapter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyEmbeddedHttp
extends SelectorThread {
    private volatile ProtocolFilter httpProtocolFilterWrapper;
    private final AtomicBoolean algorithmInitialized = new AtomicBoolean(false);
    private volatile Collection<ProtocolFilter> defaultHttpFilters;
    private boolean isHttpSecured = false;
    private UDPSelectorHandler udpSelectorHandler;
    private static final Object LOCK_OBJECT = new Object();
    public static String DEFAULT_ALGORITHM_CLASS_NAME = DEFAULT_ALGORITHM;
    protected static final ResourceBundle _rb = logger.getResourceBundle();
    private String defaultVirtualServer;
    private GrizzlyServiceListener service;

    public GrizzlyEmbeddedHttp(GrizzlyServiceListener grizzlyServiceListener) {
        this.service = grizzlyServiceListener;
        this.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
    }

    protected void initAlgorithm() {
        if (!this.algorithmInitialized.getAndSet(true)) {
            try {
                this.algorithmClass = Class.forName(DEFAULT_ALGORITHM_CLASS_NAME);
                defaultAlgorithmInstalled = true;
            }
            catch (ClassNotFoundException e) {
                logger.severe(e.getMessage());
                super.initAlgorithm();
            }
        }
    }

    protected void initController() {
        super.initController();
        DefaultProtocolChainInstanceHandler instanceHandler = new DefaultProtocolChainInstanceHandler(){
            private final ConcurrentLinkedQueue<ProtocolChain> chains = new ConcurrentLinkedQueue();

            public ProtocolChain poll() {
                ProtocolChain protocolChain = this.chains.poll();
                if (protocolChain == null) {
                    protocolChain = new HttpProtocolChain();
                    ((HttpProtocolChain)protocolChain).enableRCM(GrizzlyEmbeddedHttp.this.rcmSupport);
                    GrizzlyEmbeddedHttp.this.configureFilters(protocolChain);
                }
                return protocolChain;
            }

            public boolean offer(ProtocolChain instance) {
                return this.chains.offer(instance);
            }
        };
        this.controller.setProtocolChainInstanceHandler((ProtocolChainInstanceHandler)instanceHandler);
        this.controller.setReadThreadsCount(this.readThreadsCount);
        if (this.portUnificationFilter != null) {
            this.controller.addSelectorHandler((SelectorHandler)this.createUDPSelectorHandler());
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                GrizzlyEmbeddedHttp.this.stopEndpoint();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopEndpoint() {
        try {
            super.stopEndpoint();
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Unable to stop properly", t);
        }
        finally {
            try {
                if (this.selectorHandler != null && this.selectorHandler.getSelector() != null) {
                    this.selectorHandler.getSelector().close();
                }
            }
            catch (IOException ex) {}
            try {
                if (this.udpSelectorHandler != null && this.udpSelectorHandler.getSelector() != null) {
                    this.udpSelectorHandler.getSelector().close();
                }
            }
            catch (IOException ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<ProtocolFilter> getDefaultHttpProtocolFilters() {
        if (this.defaultHttpFilters == null) {
            Object object = LOCK_OBJECT;
            synchronized (object) {
                if (this.defaultHttpFilters == null) {
                    ArrayList<ProtocolFilter> tmpList = new ArrayList<ProtocolFilter>(4);
                    if (this.rcmSupport) {
                        tmpList.add(this.createRaFilter());
                    }
                    tmpList.add(this.createHttpParserFilter());
                    this.defaultHttpFilters = tmpList;
                }
            }
        }
        return this.defaultHttpFilters;
    }

    protected ProtocolFilter createReadFilter() {
        ReadFilter readFilter = new ReadFilter();
        readFilter.setContinuousExecution(Boolean.valueOf(System.getProperty("v3.grizzly.readFilter.continuousExecution", "false")).booleanValue());
        return readFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpProtocolFilter getHttpProtocolFilter() {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            if (this.httpProtocolFilterWrapper == null) {
                this.initAlgorithm();
                ProtocolFilter wrappedFilter = this.createHttpParserFilter();
                this.httpProtocolFilterWrapper = new HttpProtocolFilter(wrappedFilter, this);
            }
        }
        return (HttpProtocolFilter)this.httpProtocolFilterWrapper;
    }

    protected UDPSelectorHandler createUDPSelectorHandler() {
        if (this.udpSelectorHandler == null) {
            this.udpSelectorHandler = new UDPSelectorHandler();
            this.udpSelectorHandler.setPort(this.port);
            this.udpSelectorHandler.setThreadPool(this.threadPool);
        }
        return this.udpSelectorHandler;
    }

    protected void configureSelectorHandler(UDPSelectorHandler selectorHandler) {
        selectorHandler.setPort(this.port);
        selectorHandler.setReuseAddress(this.getReuseAddress());
        selectorHandler.setThreadPool(this.threadPool);
    }

    public boolean isHttpSecured() {
        return this.isHttpSecured;
    }

    public void setHttpSecured(boolean httpSecured) {
        this.isHttpSecured = httpSecured;
    }

    public void configure(boolean isWebProfile, NetworkListener networkListener, Habitat habitat) {
        Protocol httpProtocol = networkListener.findProtocol();
        Http http = httpProtocol.getHttp();
        Transport transport = networkListener.findTransport();
        ThreadPool pool = networkListener.findThreadPool();
        this.setPort(Integer.parseInt(networkListener.getPort()));
        try {
            this.setAddress(InetAddress.getByName(networkListener.getAddress()));
        }
        catch (UnknownHostException e) {
            logger.log(Level.WARNING, "Invalid address for {0}: {1}", new Object[]{networkListener.getName(), networkListener.getAddress()});
        }
        this.configureHttpListenerProperty(http, transport, httpProtocol.getSsl());
        this.configureKeepAlive(http);
        this.configureHttpProtocol(http);
        this.configureThreadPool(http, pool);
        this.configureFileCache(http.getFileCache());
        this.defaultVirtualServer = http.getDefaultVirtualServer();
        String acceptorThreads = transport.getAcceptorThreads();
        try {
            int readController = Integer.parseInt(acceptorThreads) - 1;
            if (readController > 0) {
                this.setSelectorReadThreadsCount(readController);
            }
        }
        catch (NumberFormatException nfe) {
            logger.log(Level.WARNING, "pewebcontainer.invalid_acceptor_threads", new Object[]{acceptorThreads, transport.getName()});
        }
        Boolean enableComet = this.toBoolean(http.getEnableCometSupport());
        if (enableComet.booleanValue() && !"admin-listener".equalsIgnoreCase(networkListener.getName())) {
            this.configureComet(habitat);
        }
        if (!isWebProfile) {
            this.configurePortUnification();
        }
    }

    protected void configurePortUnification() {
        ArrayList<HttpProtocolFinder> protocolFinders = new ArrayList<HttpProtocolFinder>();
        protocolFinders.add(new HttpProtocolFinder());
        ArrayList<WebProtocolHandler> protocolHandlers = new ArrayList<WebProtocolHandler>();
        protocolHandlers.add(new WebProtocolHandler(this.getWebProtocolHandlerMode(), this));
        this.configurePortUnification(protocolFinders, protocolHandlers, this.getPuPreProcessors());
    }

    List<PUPreProcessor> getPuPreProcessors() {
        return new ArrayList<PUPreProcessor>();
    }

    WebProtocolHandler.Mode getWebProtocolHandlerMode() {
        return WebProtocolHandler.Mode.HTTP;
    }

    private final void configureComet(Habitat habitat) {
        AsyncFilter cometFilter = (AsyncFilter)habitat.getComponent(AsyncFilter.class, "comet");
        if (cometFilter != null) {
            this.setEnableAsyncExecution(true);
            this.asyncHandler = new DefaultAsyncHandler();
            this.asyncHandler.addAsyncFilter(cometFilter);
            this.setAsyncHandler(this.asyncHandler);
        }
    }

    private void configureFileCache(FileCache cache) {
        if (cache == null) {
            return;
        }
        boolean enabled = this.toBoolean(cache.getEnabled());
        this.setFileCacheIsEnabled(enabled);
        this.setLargeFileCacheEnabled(enabled);
        this.setSecondsMaxAge(Integer.parseInt(cache.getMaxAgeSeconds()));
        this.setMaxCacheEntries(Integer.parseInt(cache.getMaxFilesCount()));
        this.setMaxLargeCacheSize(Integer.parseInt(cache.getMaxCacheSizeBytes()));
    }

    private void configureHttpListenerProperty(Http http, Transport transport, Ssl ssl) throws NumberFormatException {
        if (transport.getBufferSizeBytes() != null) {
            this.setBufferSize(Integer.parseInt(transport.getBufferSizeBytes()));
        }
        try {
            this.setAdapter((Adapter)Class.forName(http.getAdapter()).newInstance());
        }
        catch (Exception e) {
            throw new GrizzlyConfigException(e.getMessage(), e);
        }
        if (http.getMaxConnections() != null) {
            this.setMaxKeepAliveRequests(Integer.parseInt(http.getMaxConnections()));
        }
        if (http.getEnableAuthPassThrough() != null) {
            this.setProperty("authPassthroughEnabled", this.toBoolean(http.getEnableAuthPassThrough()));
        }
        if (http.getMaxPostSizeBytes() != null) {
            this.setMaxPostSize(Integer.parseInt(http.getMaxPostSizeBytes()));
        }
        if (http.getCompression() != null) {
            this.setCompression(http.getCompression());
        }
        if (http.getCompressableMimeType() != null) {
            this.setCompressableMimeTypes(http.getCompressableMimeType());
        }
        if (http.getNoCompressionUserAgents() != null) {
            this.setNoCompressionUserAgents(http.getNoCompressionUserAgents());
        }
        if (http.getCompressionMinSizeBytes() != null) {
            this.setCompressionMinSize(Integer.parseInt(http.getCompressionMinSizeBytes()));
        }
        if (http.getRestrictedUserAgents() != null) {
            this.setRestrictedUserAgents(http.getRestrictedUserAgents());
        }
        if (http.getEnableRcmSupport() != null) {
            this.enableRcmSupport(this.toBoolean(http.getEnableRcmSupport()));
        }
        if (http.getConnectionUploadTimeoutMillis() != null) {
            this.setUploadTimeout(Integer.parseInt(http.getConnectionUploadTimeoutMillis()));
        }
        if (http.getDisableUploadTimeout() != null) {
            this.setDisableUploadTimeout(this.toBoolean(http.getDisableUploadTimeout()));
        }
        if (http.getChunkingDisabled() != null) {
            this.setProperty("chunking-disabled", this.toBoolean(http.getChunkingDisabled()));
        }
        this.configSslOptions(ssl);
        if (http.getUriEncoding() != null) {
            this.setProperty("uriEncoding", http.getUriEncoding());
        }
        if (transport.getTcpNoDelay() != null) {
            this.setTcpNoDelay(this.toBoolean(transport.getTcpNoDelay()));
        }
        if (http.getTraceEnabled() != null) {
            this.setProperty("traceEnabled", this.toBoolean(http.getTraceEnabled()));
        }
    }

    private void configSslOptions(Ssl ssl) {
        if (ssl != null) {
            if (ssl.getCrlFile() != null) {
                this.setProperty("crlFile", ssl.getCrlFile());
            }
            if (ssl.getTrustAlgorithm() != null) {
                this.setProperty("trustAlgorithm", ssl.getTrustAlgorithm());
            }
            if (ssl.getTrustMaxCertLengthBytes() != null) {
                this.setProperty("trustMaxCertLength", ssl.getTrustMaxCertLengthBytes());
            }
        }
    }

    private void configureHttpProtocol(Http http) {
        if (http == null) {
            return;
        }
        this.setForcedRequestType(http.getForcedResponseType());
        this.setDefaultResponseType(http.getDefaultResponseType());
    }

    private void configureKeepAlive(Http http) {
        int timeoutInSeconds = 60;
        int maxConnections = 256;
        if (http != null) {
            String msg;
            try {
                timeoutInSeconds = Integer.parseInt(http.getTimeoutSeconds());
            }
            catch (NumberFormatException ex) {
                msg = _rb.getString("pewebcontainer.invalidKeepAliveTimeout");
                msg = MessageFormat.format(msg, http.getTimeoutSeconds(), Integer.toString(timeoutInSeconds));
                logger.log(Level.WARNING, msg, ex);
            }
            try {
                maxConnections = Integer.parseInt(http.getMaxConnections());
            }
            catch (NumberFormatException ex) {
                msg = _rb.getString("pewebcontainer.invalidKeepAliveMaxConnections");
                msg = MessageFormat.format(msg, http.getMaxConnections(), Integer.toString(maxConnections));
                logger.log(Level.WARNING, msg, ex);
            }
        }
        this.setKeepAliveTimeoutInSeconds(timeoutInSeconds);
        this.setMaxKeepAliveRequests(maxConnections);
    }

    private void configureThreadPool(Http http, ThreadPool threadPool) {
        if (threadPool == null) {
            return;
        }
        try {
            int maxQueueSize = threadPool.getMaxQueueSize() != null ? Integer.MAX_VALUE : Integer.parseInt(threadPool.getMaxQueueSize());
            int minThreads = Integer.parseInt(threadPool.getMinThreadPoolSize());
            int maxThreads = Integer.parseInt(threadPool.getMaxThreadPoolSize());
            int keepAlive = Integer.parseInt(http.getTimeoutSeconds());
            int timeout = Integer.parseInt(threadPool.getIdleThreadTimeoutSeconds());
            StatsThreadPool pool = new StatsThreadPool(minThreads, maxThreads, maxQueueSize, keepAlive, TimeUnit.SECONDS){};
            this.setThreadPool((ExecutorService)pool);
            this.setMaxHttpHeaderSize(Integer.parseInt(http.getHeaderBufferLengthBytes()));
            List<String> l = ManagementFactory.getRuntimeMXBean().getInputArguments();
            boolean debugMode = false;
            for (String s : l) {
                if (!s.trim().startsWith("-Xrunjdwp:")) continue;
                debugMode = true;
                break;
            }
            if (!debugMode) {
                this.setTransactionTimeout(timeout * 1000);
            } else {
                this.setTransactionTimeout(-1);
            }
        }
        catch (NumberFormatException ex) {
            logger.log(Level.WARNING, " Invalid thread-pool attribute", ex);
        }
    }

    private boolean toBoolean(String value) {
        String v = null != value ? value.trim() : value;
        return "true".equals(v) || "yes".equals(v) || "on".equals(v) || "1".equals(v);
    }

    public String getDefaultVirtualServer() {
        return this.defaultVirtualServer;
    }
}

