/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.AbstractMain;
import com.sun.enterprise.glassfish.bootstrap.ClassPathBuilder;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.logging.Logger;

public abstract class ASMainOSGi
extends AbstractMain {
    protected ClassLoader launcherCL;
    protected File fwDir;
    private String[] additionalJars = new String[0];

    public void run(Logger logger, String ... args) throws Exception {
        this.setFwDir();
        super.run(logger, args);
        this.setSystemProperties();
        this.setupLauncherClassLoader();
        this.launchOSGiFW();
    }

    protected abstract void setFwDir();

    void setUpCache(File sourceDir, File cacheDir) throws IOException {
        System.setProperty("org.osgi.framework.storage", cacheDir.getCanonicalPath());
        super.setUpCache(sourceDir, cacheDir);
    }

    protected abstract void addFrameworkJars(ClassPathBuilder var1) throws IOException;

    protected abstract void launchOSGiFW() throws Exception;

    protected void setSystemProperties() throws MalformedURLException, Exception {
        super.setSystemProperties();
        System.setProperty("org.jvnet.hk2.osgimain.bundlesDir", new File(this.glassfishDir, "modules/").getAbsolutePath());
        if (System.getProperty("org.jvnet.hk2.osgimain.autostartBundles") == null) {
            String bundlePaths = "org.apache.felix.shell.jar, org.apache.felix.shell.remote.jar, org.apache.felix.configadmin.jar, org.apache.felix.fileinstall.jar, osgi-adapter.jar";
            System.setProperty("org.jvnet.hk2.osgimain.autostartBundles", "org.apache.felix.shell.jar, org.apache.felix.shell.remote.jar, org.apache.felix.configadmin.jar, org.apache.felix.fileinstall.jar, osgi-adapter.jar");
        }
    }

    private void setupLauncherClassLoader() throws Exception {
        ClassLoader extCL = ClassLoader.getSystemClassLoader().getParent();
        ClassPathBuilder cpb = new ClassPathBuilder(extCL);
        try {
            this.addFrameworkJars(cpb);
            this.addJDKToolsJar(cpb);
            this.findDerbyClient(cpb);
            File moduleDir = this.bootstrapFile.getParentFile();
            cpb.addGlob(moduleDir, this.additionalJars);
            this.launcherCL = cpb.create();
        }
        catch (IOException e) {
            throw new Error(e);
        }
        Thread.currentThread().setContextClassLoader(this.launcherCL);
    }

    protected void addJDKToolsJar(ClassPathBuilder cpb) {
        try {
            File jdkToolsJar = this.helper.getJDKToolsJar();
            if (jdkToolsJar.exists()) {
                cpb.addJar(jdkToolsJar);
            } else {
                this.logger.fine("JDK tools.jar does not exist at " + jdkToolsJar);
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private void findDerbyClient(ClassPathBuilder cpb) throws IOException {
        String derbyHome = System.getProperty("AS_DERBY_INSTALL");
        File derbyLib = null;
        if (derbyHome != null) {
            derbyLib = new File(derbyHome, "lib");
        }
        if (!(derbyLib != null && derbyLib.exists() || System.getProperty("java.version").compareTo("1.6") <= 0)) {
            File jdkHome = new File(System.getProperty("java.home"));
            derbyLib = new File(jdkHome, "../db/lib");
        }
        if (!derbyLib.exists()) {
            this.logger.info("Cannot find javadb client jar file, jdbc driver not available");
            return;
        }
        cpb.addGlob(derbyLib, "derby*.jar");
    }

    long getSettingsLastModification() {
        return this.getLastModified(this.fwDir, 0L);
    }

    Logger getLogger() {
        return this.logger;
    }

    boolean createCache(File cacheDir) throws IOException {
        return cacheDir.mkdirs();
    }
}

