/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="redeploy")
@Scoped(value=PerLookup.class)
@I18n(value="redeploy.command")
public class ReDeployCommand
implements AdminCommand {
    @Inject
    CommandRunner commandRunner;
    @Inject
    Deployment deployment;
    @Param(optional=false)
    String name;
    @Param(primary=true, optional=true)
    String path = null;
    @Param(optional=true)
    Properties properties = null;
    boolean skipParamValidation = true;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ReDeployCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (!this.validateParameters(this.name, report)) {
            return;
        }
        DeployCommandParameters params = new DeployCommandParameters(new File(this.path));
        params.force = true;
        params.name = this.name;
        params.properties = this.properties;
        this.commandRunner.doCommand("deploy", (Object)params, report, context.getInboundPayload(), context.getOutboundPayload());
    }

    boolean validateParameters(String name, ActionReport report) {
        if (!this.deployment.isRegistered(name)) {
            report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{name}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        if (this.path == null && !Boolean.parseBoolean(ConfigBeansUtilities.getDirectoryDeployed((String)name))) {
            report.setMessage(localStrings.getLocalString("redeploy.command.cannot.redeploy", "Cannot redeploy this app {0} without specify the operand.", new Object[]{name}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        String string = this.path = this.path == null ? ConfigBeansUtilities.getLocation((String)name) : this.path;
        if (this.path == null) {
            report.setMessage(localStrings.getLocalString("redeploy.command.invalid.path", "Cannot determine the path of application."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }
}

