/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.CommandModel;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandModelImpl
extends CommandModel {
    final Map<String, CommandModel.ParamModel> params = new LinkedHashMap<String, CommandModel.ParamModel>();
    final String commandName;
    final I18n i18n;

    public CommandModelImpl(Class<? extends AdminCommand> commandType) {
        this.commandName = commandType.getAnnotation(Service.class).name();
        this.i18n = commandType.getAnnotation(I18n.class);
        this.init(commandType);
    }

    CommandModelImpl() {
        this.commandName = null;
        this.i18n = null;
    }

    void init(Class commandType) {
        for (Class currentClazz = commandType; currentClazz != null; currentClazz = currentClazz.getSuperclass()) {
            for (Field field : currentClazz.getDeclaredFields()) {
                this.add(field);
            }
            for (AccessibleObject accessibleObject : currentClazz.getDeclaredMethods()) {
                this.add(accessibleObject);
            }
        }
    }

    public I18n getI18n() {
        return this.i18n;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public CommandModel.ParamModel getModelFor(String paramName) {
        return this.params.get(paramName);
    }

    public Collection<String> getParametersNames() {
        return this.params.keySet();
    }

    private void add(AnnotatedElement e) {
        if (e.isAnnotationPresent(Param.class)) {
            ParamModelImpl model = new ParamModelImpl(e);
            this.params.put(model.getName(), model);
        }
    }

    class ParamModelImpl
    extends CommandModel.ParamModel {
        final String name;
        final Param param;
        final I18n i18n;
        final Class type;

        ParamModelImpl(AnnotatedElement e) {
            super((CommandModel)CommandModelImpl.this);
            Param p = e.getAnnotation(Param.class);
            this.name = CommandModelImpl.this.getParamName(p, e);
            this.param = p;
            this.i18n = e.getAnnotation(I18n.class);
            this.type = e instanceof Method ? ((Method)e).getReturnType() : (e instanceof Field ? ((Field)e).getType() : String.class);
        }

        public String getName() {
            return this.name;
        }

        public Param getParam() {
            return this.param;
        }

        public I18n getI18n() {
            return this.i18n;
        }

        public Class getType() {
            return this.type;
        }
    }
}

