/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.hk2.component.InjectionResolver;
import com.sun.logging.LogDomains;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandModelProvider;
import org.glassfish.config.support.CommandModelImpl;
import org.glassfish.config.support.ConfigResolver;
import org.glassfish.config.support.Create;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InjectionManager;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.DomDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scoped(value=PerLookup.class)
public class GenericCRUDCommand
implements AdminCommand,
PostConstruct,
CommandModelProvider {
    @Inject
    Habitat habitat;
    @Inject
    Inhabitant<GenericCRUDCommand> myself;
    boolean valid = false;
    String commandName;
    Class targetType = null;
    Class<? extends ConfigResolver> resolverType;
    CommandModel model;
    static final Logger logger = LogDomains.getLogger(GenericCRUDCommand.class, (String)"javax.enterprise.system.tools.admin");

    public void postConstruct() {
        System.out.println("Lead " + this.myself);
        List indexes = this.myself.metadata().get((Object)"index");
        if (indexes.size() != 1) {
            logger.log(Level.SEVERE, "Inhabitant has more than 1 index " + (String)indexes.get(0));
            return;
        }
        String index = (String)indexes.get(0);
        if (index.indexOf(":") == -1) {
            logger.log(Level.SEVERE, "This is not a named service " + index);
            return;
        }
        this.commandName = index.substring(index.indexOf(":") + 1);
        String targetTypeName = (String)this.myself.metadata().get((Object)"targetType").get(0);
        try {
            this.targetType = this.loadClass(targetTypeName);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "Cannot load target type", e);
        }
        Create create = this.targetType.getAnnotation(Create.class);
        this.resolverType = create.resolver();
        try {
            System.out.println("I create " + this.targetType.getName() + " instances which gets added to " + create.parentType().getName() + " under " + this.elementName(create.parentType(), this.targetType));
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "Cannot load child type", e);
        }
        try {
            this.model = new GenericCommandModel(this.targetType);
            for (String paramName : this.model.getParametersNames()) {
                CommandModel.ParamModel param = this.model.getModelFor(paramName);
                System.out.println("I take " + param.getName() + " parameters");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Class loadClass(String type) throws ClassNotFoundException {
        return this.myself.type().getClassLoader().loadClass(type);
    }

    protected String elementName(Class<ConfigBeanProxy> parent, Class<ConfigBeanProxy> child) throws ClassNotFoundException {
        DomDocument document = (DomDocument)this.habitat.getComponent(DomDocument.class);
        ConfigModel cm = document.buildModel(parent);
        for (String elementName : cm.getElementNames()) {
            ConfigModel.Property prop = cm.getElement(elementName);
            if (!(prop instanceof ConfigModel.Node)) continue;
            ConfigModel childCM = ((ConfigModel.Node)prop).getModel();
            String childTypeName = childCM.targetTypeName;
            if (childTypeName.equals(child.getName())) {
                return elementName;
            }
            List subChildrenModels = document.getAllModelsImplementing(((ClassLoader)childCM.classLoaderHolder.get()).loadClass(childTypeName));
            for (ConfigModel subChildModel : subChildrenModels) {
                if (!subChildModel.targetTypeName.equals(child.getName())) continue;
                return elementName;
            }
        }
        return null;
    }

    public void execute(AdminCommandContext context) {
        InjectionManager manager = new InjectionManager();
        ConfigResolver resolver = (ConfigResolver)this.habitat.getComponent(this.resolverType);
        manager.inject((Object)resolver, new InjectionResolver[]{new InjectionResolver<Param>(Param.class){

            public Object getValue(Object component, AnnotatedElement annotated, Class type) throws ComponentException {
                return null;
            }

            public boolean isOptional(Param annotation) {
                return annotation.optional();
            }
        }});
        Object target = resolver.resolve(context);
        if (target != null) {
            Domain d = (Domain)target;
        }
    }

    public CommandModel getModel() {
        return this.model;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class GenericCommandModel
    extends CommandModel {
        final HashMap<String, CommandModel.ParamModel> params = new HashMap();

        private GenericCommandModel(Class<ConfigBeanProxy> targetType) {
            DomDocument document = (DomDocument)GenericCRUDCommand.this.habitat.getComponent(DomDocument.class);
            ConfigModel cm = document.buildModel(targetType);
            for (Method m : targetType.getMethods()) {
                ConfigModel.Property prop = cm.toProperty(m);
                if (prop == null) continue;
                String attributeName = prop.xmlName;
                if (!m.isAnnotationPresent(Param.class)) continue;
                Param p = m.getAnnotation(Param.class);
                if (p.name() != null && !p.name().isEmpty()) {
                    this.params.put(p.name(), new ParamBasedModel(p.name(), p));
                    continue;
                }
                if (!m.isAnnotationPresent(Attribute.class)) continue;
                Attribute attr = m.getAnnotation(Attribute.class);
                if (attr.value() != null && !attr.value().isEmpty()) {
                    this.params.put(attr.value(), new AttributeBasedModel(attr.value(), attr));
                    continue;
                }
                this.params.put(attributeName, new AttributeBasedModel(attributeName, attr));
            }
            Create create = targetType.getAnnotation(Create.class);
            if (create == null) {
                return;
            }
            Class<? extends ConfigResolver> resolverType = create.resolver();
            CommandModelImpl classModel = new CommandModelImpl();
            classModel.init(resolverType);
            for (String paramName : classModel.getParametersNames()) {
                this.params.put(paramName, classModel.getModelFor(paramName));
            }
        }

        public I18n getI18n() {
            return null;
        }

        public String getCommandName() {
            return GenericCRUDCommand.this.commandName;
        }

        public CommandModel.ParamModel getModelFor(String paramName) {
            return this.params.get(paramName);
        }

        public Collection<String> getParametersNames() {
            return this.params.keySet();
        }

        private final class AttributeBasedModel
        extends CommandModel.ParamModel {
            final String name;
            final Attribute attr;

            private AttributeBasedModel(String name, Attribute attr) {
                super((CommandModel)GenericCommandModel.this);
                this.name = name;
                this.attr = attr;
            }

            public String getName() {
                return this.name;
            }

            public I18n getI18n() {
                return null;
            }

            public Class getType() {
                return String.class;
            }

            public Param getParam() {
                return new Param(){

                    public Class<? extends Annotation> annotationType() {
                        return Param.class;
                    }

                    public String name() {
                        return AttributeBasedModel.this.name;
                    }

                    public String acceptableValues() {
                        return null;
                    }

                    public boolean optional() {
                        return !AttributeBasedModel.this.attr.key();
                    }

                    public String shortName() {
                        return null;
                    }

                    public boolean primary() {
                        return AttributeBasedModel.this.attr.key();
                    }

                    public String defaultValue() {
                        return AttributeBasedModel.this.attr.defaultValue();
                    }

                    public boolean password() {
                        return false;
                    }
                };
            }
        }

        private final class ParamBasedModel
        extends CommandModel.ParamModel {
            final String name;
            final Param param;

            private ParamBasedModel(String name, Param param) {
                super((CommandModel)GenericCommandModel.this);
                this.name = name;
                this.param = param;
            }

            public String getName() {
                return this.name;
            }

            public Param getParam() {
                return this.param;
            }

            public I18n getI18n() {
                return null;
            }

            public Class getType() {
                return String.class;
            }
        }
    }
}

