/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintDescriptor;
import javax.validation.ConstraintValidator;
import javax.validation.OverridesParameter;
import javax.validation.OverridesParameters;
import javax.validation.ReportAsSingleViolation;
import javax.validation.ValidationException;
import javax.validation.groups.Default;
import org.hibernate.validation.engine.ConstraintHelper;
import org.hibernate.validation.util.LoggerFactory;
import org.hibernate.validation.util.annotationfactory.AnnotationDescriptor;
import org.hibernate.validation.util.annotationfactory.AnnotationFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintDescriptorImpl<T extends Annotation>
implements ConstraintDescriptor<T> {
    private static final Logger log = LoggerFactory.make();
    private static final Class<?>[] DEFAULT_GROUP = new Class[]{Default.class};
    private static final int OVERRIDES_PARAMETER_DEFAULT_INDEX = -1;
    private final T annotation;
    private final List<Class<? extends ConstraintValidator<T, ?>>> constraintClasses = new ArrayList();
    private final Set<Class<?>> groups;
    private final Map<String, Object> parameters;
    private final Set<ConstraintDescriptor<?>> composingConstraints = new HashSet();
    private final Map<ClassIndexWrapper, Map<String, Object>> overrideParameters = new HashMap<ClassIndexWrapper, Map<String, Object>>();
    private final boolean isReportAsSingleInvalidConstraint;
    private final ConstraintHelper constraintHelper;

    public ConstraintDescriptorImpl(T annotation, Class<?>[] groups, ConstraintHelper constraintHelper) {
        this(annotation, new HashSet(), constraintHelper);
        if (groups.length == 0) {
            groups = DEFAULT_GROUP;
        }
        this.groups.addAll(Arrays.asList(groups));
    }

    private ConstraintDescriptorImpl(T annotation, Set<Class<?>> groups, ConstraintHelper constraintHelper) {
        this.annotation = annotation;
        this.groups = groups;
        this.parameters = this.getAnnotationParameters((Annotation)annotation);
        this.constraintHelper = constraintHelper;
        this.isReportAsSingleInvalidConstraint = annotation.annotationType().isAnnotationPresent(ReportAsSingleViolation.class);
        this.findConstraintClasses();
        this.parseOverrideParameters();
        this.parseComposingConstraints();
    }

    private void findConstraintClasses() {
        if (this.constraintHelper.isBuiltinConstraint((Annotation)this.annotation)) {
            this.constraintClasses.addAll(this.constraintHelper.getBuiltInConstraints(this.annotation));
        } else {
            Class<? extends ConstraintValidator<?, ?>>[] validatedBy;
            Class<? extends Annotation> annotationType = this.annotation.annotationType();
            Class<? extends ConstraintValidator<?, ?>>[] arr$ = validatedBy = annotationType.getAnnotation(Constraint.class).validatedBy();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Class<ConstraintValidator<?, ?>> validator;
                Class<ConstraintValidator<?, ?>> safeValidator = validator = arr$[i$];
                this.constraintClasses.add(safeValidator);
            }
        }
    }

    @Override
    public T getAnnotation() {
        return this.annotation;
    }

    @Override
    public Set<Class<?>> getGroups() {
        return this.groups;
    }

    @Override
    public List<Class<? extends ConstraintValidator<T, ?>>> getConstraintValidatorClasses() {
        return Collections.unmodifiableList(this.constraintClasses);
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public Set<ConstraintDescriptor<?>> getComposingConstraints() {
        return this.composingConstraints;
    }

    @Override
    public boolean isReportAsSingleViolation() {
        return this.isReportAsSingleInvalidConstraint;
    }

    public String toString() {
        return "ConstraintDescriptorImpl{annotation=" + this.annotation + ", constraintClasses=" + this.constraintClasses.toString() + ", groups=" + this.groups + ", parameters=" + this.parameters + ", composingConstraints=" + this.composingConstraints + ", isReportAsSingleInvalidConstraint=" + this.isReportAsSingleInvalidConstraint + '}';
    }

    private Map<String, Object> getAnnotationParameters(Annotation annotation) {
        Method[] declaredMethods = annotation.annotationType().getDeclaredMethods();
        HashMap<String, Object> parameters = new HashMap<String, Object>(declaredMethods.length);
        for (Method m : declaredMethods) {
            try {
                parameters.put(m.getName(), m.invoke((Object)annotation, new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw new ValidationException("Unable to read annotation parameters: " + annotation.getClass(), e);
            }
            catch (InvocationTargetException e) {
                throw new ValidationException("Unable to read annotation parameters: " + annotation.getClass(), e);
            }
        }
        return Collections.unmodifiableMap(parameters);
    }

    private void addOverrideParameter(Map<ClassIndexWrapper, Map<String, Object>> overrideParameters, Object value, OverridesParameter ... parameters) {
        for (OverridesParameter parameter : parameters) {
            ClassIndexWrapper wrapper = new ClassIndexWrapper(parameter.constraint(), parameter.index());
            Map<String, Object> map = overrideParameters.get(wrapper);
            if (map == null) {
                map = new HashMap<String, Object>();
                overrideParameters.put(wrapper, map);
            }
            map.put(parameter.parameter(), value);
        }
    }

    private Object getMethodValue(Annotation annotation, Method m) {
        Object value;
        try {
            value = m.invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new ValidationException("Unable to retrieve annotation parameter value.");
        }
        catch (InvocationTargetException e) {
            throw new ValidationException("Unable to retrieve annotation parameter value.");
        }
        return value;
    }

    private void parseOverrideParameters() {
        for (Method m : this.annotation.annotationType().getMethods()) {
            if (m.getAnnotation(OverridesParameter.class) != null) {
                this.addOverrideParameter(this.overrideParameters, this.getMethodValue((Annotation)this.annotation, m), m.getAnnotation(OverridesParameter.class));
                continue;
            }
            if (m.getAnnotation(OverridesParameters.class) == null) continue;
            this.addOverrideParameter(this.overrideParameters, this.getMethodValue((Annotation)this.annotation, m), m.getAnnotation(OverridesParameters.class).value());
        }
    }

    private void parseComposingConstraints() {
        for (Annotation declaredAnnotation : this.annotation.annotationType().getDeclaredAnnotations()) {
            if (this.constraintHelper.isConstraintAnnotation(declaredAnnotation) || this.constraintHelper.isBuiltinConstraint(declaredAnnotation)) {
                ConstraintDescriptorImpl<Annotation> descriptor = this.createComposingConstraintDescriptor(declaredAnnotation, -1);
                this.composingConstraints.add(descriptor);
                log.debug("Adding composing constraint: " + descriptor);
                continue;
            }
            if (!this.constraintHelper.isMultiValueConstraint(declaredAnnotation)) continue;
            List<Annotation> multiValueConstraints = this.constraintHelper.getMultiValueConstraints(declaredAnnotation);
            int index = 1;
            for (Annotation constraintAnnotation : multiValueConstraints) {
                ConstraintDescriptorImpl<Annotation> descriptor = this.createComposingConstraintDescriptor(constraintAnnotation, index);
                this.composingConstraints.add(descriptor);
                log.debug("Adding composing constraint: " + descriptor);
                ++index;
            }
        }
    }

    private <U extends Annotation> ConstraintDescriptorImpl<U> createComposingConstraintDescriptor(U declaredAnnotation, int index) {
        Class<? extends Annotation> annotationType = declaredAnnotation.annotationType();
        return this.createComposingConstraintDescriptor(index, declaredAnnotation, annotationType);
    }

    private <U extends Annotation> ConstraintDescriptorImpl<U> createComposingConstraintDescriptor(int index, U constraintAnnotation, Class<U> annotationType) {
        AnnotationDescriptor<U> annotationDescriptor = new AnnotationDescriptor<U>(annotationType, this.getAnnotationParameters(constraintAnnotation));
        Map<String, Object> overrides = this.overrideParameters.get(new ClassIndexWrapper(annotationType, index));
        if (overrides != null) {
            for (Map.Entry<String, Object> entry : overrides.entrySet()) {
                annotationDescriptor.setValue(entry.getKey(), entry.getValue());
            }
        }
        U annotationProxy = AnnotationFactory.create(annotationDescriptor);
        return new ConstraintDescriptorImpl<U>(annotationProxy, this.groups, this.constraintHelper);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassIndexWrapper {
        final Class<?> clazz;
        final int index;

        ClassIndexWrapper(Class<?> clazz, int index) {
            this.clazz = clazz;
            this.index = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassIndexWrapper that = (ClassIndexWrapper)o;
            if (this.index != that.index) {
                return false;
            }
            return !(this.clazz != null ? !this.clazz.equals(that.clazz) : that.clazz != null);
        }

        public int hashCode() {
            int result = this.clazz != null ? this.clazz.hashCode() : 0;
            result = 31 * result + this.index;
            return result;
        }
    }
}

