/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.validation.ConstraintDescriptor;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import org.hibernate.validation.engine.ConstraintViolationImpl;
import org.hibernate.validation.engine.MetaConstraint;
import org.hibernate.validation.util.IdentitySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionContext<T>
implements ConstraintValidatorContext {
    private static final String PROPERTY_ROOT = "";
    private static final String PROPERTY_PATH_SEPERATOR = ".";
    private final T rootBean;
    private final Map<Class<?>, IdentitySet> processedObjects;
    private final List<ConstraintViolationImpl<T>> failingConstraintViolations;
    private List<String> propertyPath;
    private Class<?> currentGroup;
    private ValidatedProperty currentValidatedProperty;
    private Stack<Object> beanStack = new Stack();
    private final MessageInterpolator messageResolver;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final TraversableResolver traversableResolver;

    public ExecutionContext(T object, MessageInterpolator messageResolver, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver) {
        this(object, object, messageResolver, constraintValidatorFactory, traversableResolver);
    }

    public ExecutionContext(T rootBean, Object object, MessageInterpolator messageResolver, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver) {
        this.rootBean = rootBean;
        this.messageResolver = messageResolver;
        this.constraintValidatorFactory = constraintValidatorFactory;
        this.traversableResolver = traversableResolver;
        this.beanStack.push(object);
        this.processedObjects = new HashMap();
        this.propertyPath = new ArrayList<String>();
        this.failingConstraintViolations = new ArrayList<ConstraintViolationImpl<T>>();
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory;
    }

    @Override
    public void disableDefaultError() {
        assert (this.currentValidatedProperty != null);
        this.currentValidatedProperty.disableDefaultError();
    }

    @Override
    public String getDefaultErrorMessage() {
        assert (this.currentValidatedProperty != null);
        return this.currentValidatedProperty.getDefaultErrorMessage();
    }

    @Override
    public void addError(String message) {
        assert (this.currentValidatedProperty != null);
        this.currentValidatedProperty.addError(message);
    }

    @Override
    public void addError(String message, String property) {
        assert (this.currentValidatedProperty != null);
        this.currentValidatedProperty.addError(message, property);
    }

    public void setCurrentConstraintDescriptor(ConstraintDescriptor constraintDescriptor) {
        assert (this.currentValidatedProperty != null);
        this.currentValidatedProperty.setConstraintDescriptor(constraintDescriptor);
    }

    public Object peekCurrentBean() {
        return this.beanStack.peek();
    }

    public Class<?> peekCurrentBeanType() {
        return this.beanStack.peek().getClass();
    }

    public void pushCurrentBean(Object validatedBean) {
        this.beanStack.push(validatedBean);
    }

    public void popCurrentBean() {
        this.beanStack.pop();
    }

    public T getRootBean() {
        return this.rootBean;
    }

    public Class<?> getCurrentGroup() {
        return this.currentGroup;
    }

    public void setCurrentGroup(Class<?> currentGroup) {
        this.currentGroup = currentGroup;
    }

    public void markProcessedForCurrentGroup() {
        if (this.processedObjects.containsKey(this.currentGroup)) {
            this.processedObjects.get(this.currentGroup).add(this.beanStack.peek());
        } else {
            IdentitySet set = new IdentitySet();
            set.add(this.beanStack.peek());
            this.processedObjects.put(this.currentGroup, set);
        }
    }

    public boolean isValidatedAgainstCurrentGroup(Object value) {
        IdentitySet objectsProcessedInCurrentGroups = this.processedObjects.get(this.currentGroup);
        return objectsProcessedInCurrentGroups != null && objectsProcessedInCurrentGroups.contains(value);
    }

    private void addConstraintFailure(ConstraintViolationImpl<T> failingConstraintViolation) {
        int i = this.failingConstraintViolations.indexOf(failingConstraintViolation);
        if (i == -1) {
            this.failingConstraintViolations.add(failingConstraintViolation);
        }
    }

    public void addConstraintFailures(List<ConstraintViolationImpl<T>> failingConstraintViolations) {
        for (ConstraintViolationImpl<T> violation : failingConstraintViolations) {
            this.addConstraintFailure(violation);
        }
    }

    public List<ConstraintViolationImpl<T>> getFailingConstraints() {
        return this.failingConstraintViolations;
    }

    public void pushProperty(String property) {
        this.currentValidatedProperty = new ValidatedProperty(this.peekPropertyPath(), property);
        this.propertyPath.add(property);
    }

    public void popProperty() {
        if (this.propertyPath.size() > 0) {
            this.propertyPath.remove(this.propertyPath.size() - 1);
            this.currentValidatedProperty = null;
        }
    }

    public void markCurrentPropertyAsIndexed() {
        String property = this.peekProperty();
        property = property + "[]";
        this.popProperty();
        this.pushProperty(property);
    }

    public void replacePropertyIndex(String index) {
        String property = this.peekProperty();
        property = property.replaceAll("\\[[0-9]*\\]$", "[" + index + "]");
        this.popProperty();
        this.pushProperty(property);
    }

    public String peekPropertyPath() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i <= this.propertyPath.size() - 1; ++i) {
            builder.append(this.propertyPath.get(i));
            if (i >= this.propertyPath.size() - 1) continue;
            builder.append(PROPERTY_PATH_SEPERATOR);
        }
        return builder.toString();
    }

    public String peekProperty() {
        if (this.propertyPath.size() == 0) {
            return PROPERTY_ROOT;
        }
        return this.propertyPath.get(this.propertyPath.size() - 1);
    }

    public boolean isValidationRequired(MetaConstraint metaConstraint) {
        if (!metaConstraint.getGroupList().contains(this.currentGroup)) {
            return false;
        }
        Class<?> rootBeanClass = this.rootBean == null ? null : this.rootBean.getClass();
        return this.traversableResolver.isTraversable(this.peekCurrentBean(), this.peekProperty(), rootBeanClass, this.peekPropertyPath(), metaConstraint.getElementType());
    }

    public List<ConstraintViolationImpl<T>> createConstraintViolations(Object value) {
        ArrayList<ConstraintViolationImpl<T>> constraintViolations = new ArrayList<ConstraintViolationImpl<T>>();
        for (ErrorMessage error : this.currentValidatedProperty.getErrorMessages()) {
            constraintViolations.add(this.createConstraintViolation(value, error));
        }
        return constraintViolations;
    }

    public ConstraintViolationImpl<T> createConstraintViolation(Object value, ErrorMessage error) {
        ConstraintDescriptor descriptor = this.currentValidatedProperty.getConstraintDescriptor();
        String messageTemplate = error.getMessage();
        String interpolatedMessage = this.messageResolver.interpolate(messageTemplate, descriptor, this.peekCurrentBean());
        return new ConstraintViolationImpl<T>(messageTemplate, interpolatedMessage, this.getRootBean(), this.peekCurrentBean(), value, error.getProperty(), descriptor);
    }

    public class ErrorMessage {
        private final String message;
        private final String property;

        public ErrorMessage(String message, String property) {
            this.message = message;
            this.property = property;
        }

        public String getMessage() {
            return this.message;
        }

        public String getProperty() {
            return this.property;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValidatedProperty {
        private final List<ErrorMessage> errorMessages = new ArrayList<ErrorMessage>(3);
        private final String property;
        private final String propertyParent;
        private ConstraintDescriptor constraintDescriptor;
        private boolean defaultDisabled;

        private ValidatedProperty(String propertyParent, String property) {
            this.property = property;
            this.propertyParent = propertyParent;
        }

        public void setConstraintDescriptor(ConstraintDescriptor constraintDescriptor) {
            this.constraintDescriptor = constraintDescriptor;
        }

        public ConstraintDescriptor getConstraintDescriptor() {
            return this.constraintDescriptor;
        }

        void disableDefaultError() {
            this.defaultDisabled = true;
        }

        public boolean isDefaultErrorDisabled() {
            return this.defaultDisabled;
        }

        public String getDefaultErrorMessage() {
            return (String)this.constraintDescriptor.getParameters().get("message");
        }

        public void addError(String message) {
            this.errorMessages.add(new ErrorMessage(message, this.buildPropertyPath(this.propertyParent, this.property)));
        }

        public void addError(String message, String property) {
            this.errorMessages.add(new ErrorMessage(message, this.buildPropertyPath(this.propertyParent, property)));
        }

        public List<ErrorMessage> getErrorMessages() {
            ArrayList<ErrorMessage> returnedErrorMessages = new ArrayList<ErrorMessage>(this.errorMessages);
            if (!this.defaultDisabled) {
                returnedErrorMessages.add(new ErrorMessage(this.getDefaultErrorMessage(), this.buildPropertyPath(this.propertyParent, this.property)));
            }
            return returnedErrorMessages;
        }

        private String buildPropertyPath(String parent, String leaf) {
            if (ExecutionContext.PROPERTY_ROOT.equals(parent)) {
                return leaf;
            }
            return parent + ExecutionContext.PROPERTY_PATH_SEPERATOR + leaf;
        }
    }
}

