/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.ConnectionPool;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpFileCache;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpProtocol;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.KeepAlive;
import com.sun.enterprise.config.serverbeans.RequestProcessing;
import com.sun.enterprise.config.serverbeans.ThreadPools;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.grizzly.config.dom.FileCache;
import com.sun.grizzly.config.dom.Http;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.NetworkListeners;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Protocols;
import com.sun.grizzly.config.dom.Ssl;
import com.sun.grizzly.config.dom.ThreadPool;
import com.sun.grizzly.config.dom.Transport;
import com.sun.grizzly.config.dom.Transports;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.api.admin.config.Property;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service
public class GrizzlyConfigSchemaMigrator
implements ConfigurationUpgrade,
PostConstruct {
    @Inject
    private Domain domain;
    @Inject
    private Habitat habitat;

    public void postConstruct() {
        try {
            Config config = this.domain.getConfigs().getConfig().get(0);
            if (!config.getHttpService().getHttpListener().isEmpty()) {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Domain>(){

                    public Object run(Domain param) throws TransactionFailure {
                        GrizzlyConfigSchemaMigrator.this.migrateSettings(param);
                        return null;
                    }
                }, (ConfigBeanProxy)this.domain);
            }
            if (config.getNetworkConfig().getNetworkListeners().getThreadPool() != null) {
                ThreadPools threadPools = config.getThreadPools();
                if (threadPools == null) {
                    threadPools = this.createThreadPools();
                }
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ThreadPools>(){

                    public Object run(ThreadPools param) throws TransactionFailure {
                        GrizzlyConfigSchemaMigrator.this.migrateThreadPools(param);
                        return null;
                    }
                }, (ConfigBeanProxy)threadPools);
            }
        }
        catch (TransactionFailure tf) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Failure while upgrading application grizzly related items.  Please redeploy", tf);
            throw new RuntimeException(tf);
        }
        catch (PropertyVetoException e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Failure while upgrading application grizzly related items.  Please redeploy", e);
            throw new RuntimeException(e);
        }
    }

    private void migrateThreadPools(ThreadPools threadPools) throws TransactionFailure {
        Config config = (Config)threadPools.getParent(Config.class);
        NetworkListeners networkListeners = config.getNetworkConfig().getNetworkListeners();
        threadPools.getThreadPool().addAll(networkListeners.getThreadPool());
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkListeners>(){

            public Object run(NetworkListeners param) throws PropertyVetoException {
                param.getThreadPool().clear();
                return null;
            }
        }, (ConfigBeanProxy)networkListeners);
    }

    private ThreadPools createThreadPools() throws TransactionFailure, PropertyVetoException {
        return (ThreadPools)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Config>(){

            public Object run(Config param) throws PropertyVetoException, TransactionFailure {
                ThreadPools threadPools = (ThreadPools)param.createChild(ThreadPools.class);
                param.setThreadPools(threadPools);
                return threadPools;
            }
        }, (ConfigBeanProxy)this.domain.getConfigs().getConfig().get(0));
    }

    private void migrateSettings(Domain domain) throws TransactionFailure {
        Configs configs = domain.getConfigs();
        Config baseConfig = configs.getConfig().get(0);
        HttpService service = baseConfig.getHttpService();
        NetworkConfig config = this.getNetworkConfig(baseConfig);
        this.migrateHttpListeners(baseConfig, config);
        this.migrateHttpProtocol(config, service);
        this.migrateHttpFileCache(config, service);
        this.migrateRequestProcessing(config, service);
        this.migrateKeepAlive(config, service);
        this.migrateConnectionPool(config, service);
        this.migrateVirtualServers(service);
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

            public Object run(HttpService param) {
                ArrayList<Property> propertyList = new ArrayList<Property>(param.getProperty());
                Iterator it = propertyList.iterator();
                while (it.hasNext()) {
                    Property property = (Property)it.next();
                    if (!"accessLoggingEnabled".equals(property.getName())) continue;
                    it.remove();
                }
                param.getProperty().clear();
                param.getProperty().addAll(propertyList);
                return null;
            }
        }, (ConfigBeanProxy)service);
    }

    private void migrateVirtualServers(final HttpService service) throws TransactionFailure {
        for (VirtualServer virtualServer : service.getVirtualServer()) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<VirtualServer>(){

                public Object run(VirtualServer param) throws PropertyVetoException {
                    param.setNetworkListeners(param.getHttpListeners());
                    param.setHttpListeners(null);
                    for (Property property : service.getProperty()) {
                        if (!"accessLoggingEnabled".equals(property.getName())) continue;
                        param.setAccessLoggingEnabled(property.getValue());
                    }
                    ArrayList<Property> propertyList = new ArrayList<Property>(param.getProperty());
                    Iterator it = propertyList.iterator();
                    while (it.hasNext()) {
                        Property property = (Property)it.next();
                        if ("docroot".equals(property.getName())) {
                            param.setDocroot(property.getValue());
                            it.remove();
                            continue;
                        }
                        if ("accesslog".equals(property.getName())) {
                            param.setAccessLog(property.getValue());
                            it.remove();
                            continue;
                        }
                        if (!"sso-enabled".equals(property.getName())) continue;
                        param.setSsoEnabled(property.getValue());
                        it.remove();
                    }
                    param.getProperty().clear();
                    param.getProperty().addAll(propertyList);
                    return null;
                }
            }, (ConfigBeanProxy)virtualServer);
        }
    }

    private void migrateConnectionPool(NetworkConfig config, HttpService httpService) throws TransactionFailure {
        final ConnectionPool pool = httpService.getConnectionPool();
        Transport transport = (Transport)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Transports>(){

            public Object run(Transports param) throws TransactionFailure {
                Transport transport = (Transport)param.createChild(Transport.class);
                param.getTransport().add(transport);
                transport.setMaxConnectionsCount(pool.getMaxPendingCount());
                transport.setName("tcp");
                return transport;
            }
        }, (ConfigBeanProxy)this.getTransports(config));
        this.updateNetworkListener(config, transport);
        this.updateHttp(config, pool);
        this.updateThreadPool(config, pool);
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

            public Object run(HttpService param) throws PropertyVetoException {
                param.setConnectionPool(null);
                return null;
            }
        }, (ConfigBeanProxy)httpService);
    }

    private void updateThreadPool(NetworkConfig config, final ConnectionPool pool) throws TransactionFailure {
        for (ThreadPool threadPool : config.getNetworkListeners().getThreadPool()) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ThreadPool>(){

                public Object run(ThreadPool param) {
                    param.setMaxQueueSize(pool.getQueueSizeInBytes());
                    return null;
                }
            }, (ConfigBeanProxy)threadPool);
        }
    }

    private void updateHttp(NetworkConfig config, final ConnectionPool pool) throws TransactionFailure {
        for (Protocol protocol : config.getProtocols().getProtocol()) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Http>(){

                public Object run(Http http) {
                    http.setRequestBodyBufferSize(pool.getReceiveBufferSizeInBytes());
                    http.setSendBufferSize(pool.getSendBufferSizeInBytes());
                    return null;
                }
            }, (ConfigBeanProxy)protocol.getHttp());
        }
    }

    private void updateNetworkListener(NetworkConfig config, final Transport transport) throws TransactionFailure {
        for (NetworkListener listener : config.getNetworkListeners().getNetworkListener()) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkListener>(){

                public Object run(NetworkListener param) {
                    param.setTransport(transport.getName());
                    return null;
                }
            }, (ConfigBeanProxy)listener);
        }
    }

    private Transports getTransports(NetworkConfig config) throws TransactionFailure {
        Transports listeners = config.getTransports();
        if (listeners == null) {
            listeners = (Transports)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkConfig>(){

                public Object run(NetworkConfig param) throws TransactionFailure {
                    Transports child = (Transports)param.createChild(Transports.class);
                    param.setTransports(child);
                    return child;
                }
            }, (ConfigBeanProxy)config);
        }
        return listeners;
    }

    private void migrateKeepAlive(NetworkConfig config, HttpService httpService) throws TransactionFailure {
        final KeepAlive keepAlive = httpService.getKeepAlive();
        for (Protocol protocol : config.getProtocols().getProtocol()) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Http>(){

                public Object run(Http http) {
                    http.setMaxConnections(keepAlive.getMaxConnections());
                    http.setTimeout(keepAlive.getTimeoutInSeconds());
                    return null;
                }
            }, (ConfigBeanProxy)protocol.getHttp());
        }
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

            public Object run(HttpService param) throws PropertyVetoException {
                param.setKeepAlive(null);
                return null;
            }
        }, (ConfigBeanProxy)httpService);
    }

    private void migrateRequestProcessing(final NetworkConfig config, HttpService httpService) throws TransactionFailure {
        final RequestProcessing request = httpService.getRequestProcessing();
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkListeners>(){

            public Object run(NetworkListeners listeners) throws TransactionFailure {
                final ThreadPool pool = (ThreadPool)listeners.createChild(ThreadPool.class);
                listeners.getThreadPool().add(pool);
                pool.setThreadPoolId("http-thread-pool");
                pool.setMaxThreadPoolSize(request.getThreadCount());
                pool.setMinThreadPoolSize(request.getInitialThreadCount());
                for (Protocol protocol : config.getProtocols().getProtocol()) {
                    ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Http>(){

                        public Object run(Http http) {
                            http.setHeaderBufferLength(request.getHeaderBufferLengthInBytes());
                            return null;
                        }
                    }, (ConfigBeanProxy)protocol.getHttp());
                }
                for (NetworkListener listener : config.getNetworkListeners().getNetworkListener()) {
                    ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkListener>(){

                        public Object run(NetworkListener param) {
                            param.setThreadPool(pool.getThreadPoolId());
                            return null;
                        }
                    }, (ConfigBeanProxy)listener);
                }
                return null;
            }
        }, (ConfigBeanProxy)config.getNetworkListeners());
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

            public Object run(HttpService param) throws PropertyVetoException {
                param.setRequestProcessing(null);
                return null;
            }
        }, (ConfigBeanProxy)httpService);
    }

    private void migrateHttpFileCache(NetworkConfig config, HttpService httpService) throws TransactionFailure {
        final HttpFileCache httpFileCache = httpService.getHttpFileCache();
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkConfig>(){

            public Object run(NetworkConfig param) throws TransactionFailure {
                for (Protocol protocol : param.getProtocols().getProtocol()) {
                    ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Http>(){

                        public Object run(Http http) throws TransactionFailure {
                            FileCache cache = (FileCache)http.createChild(FileCache.class);
                            http.setFileCache(cache);
                            cache.setEnabled(httpFileCache.getFileCachingEnabled());
                            cache.setMaxAge(httpFileCache.getMaxAgeInSeconds());
                            cache.setMaxCacheSize(httpFileCache.getMediumFileSpaceInBytes());
                            cache.setMaxFilesCount(httpFileCache.getMaxFilesCount());
                            return null;
                        }
                    }, (ConfigBeanProxy)protocol.getHttp());
                }
                return null;
            }
        }, (ConfigBeanProxy)config);
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

            public Object run(HttpService param) throws PropertyVetoException {
                param.setHttpFileCache(null);
                return null;
            }
        }, (ConfigBeanProxy)httpService);
    }

    private void migrateHttpProtocol(NetworkConfig config, HttpService httpService) throws TransactionFailure {
        final HttpProtocol httpProtocol = httpService.getHttpProtocol();
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkConfig>(){

            public Object run(NetworkConfig param) throws TransactionFailure {
                for (Protocol protocol : param.getProtocols().getProtocol()) {
                    ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Http>(){

                        public Object run(Http http) {
                            http.setVersion(httpProtocol.getVersion());
                            http.setForcedResponseType(httpProtocol.getForcedResponseType());
                            http.setDefaultResponseType(httpProtocol.getDefaultResponseType());
                            return null;
                        }
                    }, (ConfigBeanProxy)protocol.getHttp());
                }
                return null;
            }
        }, (ConfigBeanProxy)config);
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

            public Object run(HttpService param) throws PropertyVetoException {
                param.setHttpProtocol(null);
                return null;
            }
        }, (ConfigBeanProxy)httpService);
    }

    private void migrateHttpListeners(Config baseConfig, NetworkConfig config) throws TransactionFailure {
        for (final HttpListener listener : baseConfig.getHttpService().getHttpListener()) {
            Protocol protocol = this.migrateToProtocols(config, listener);
            this.createNetworkListener(baseConfig, listener, protocol);
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

                public Object run(HttpService param) {
                    HttpListener listener1 = param.getHttpListenerById(listener.getId());
                    param.getHttpListener().remove(listener1);
                    return null;
                }
            }, (ConfigBeanProxy)baseConfig.getHttpService());
        }
    }

    private NetworkConfig getNetworkConfig(Config baseConfig) throws TransactionFailure {
        NetworkConfig config = baseConfig.getNetworkConfig();
        if (config == null) {
            config = (NetworkConfig)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Config>(){

                public Object run(Config param) throws PropertyVetoException, TransactionFailure {
                    NetworkConfig child = (NetworkConfig)param.createChild(NetworkConfig.class);
                    param.setNetworkConfig(child);
                    return child;
                }
            }, (ConfigBeanProxy)baseConfig);
        }
        return config;
    }

    private void createNetworkListener(Config baseConfig, final HttpListener listener, final Protocol protocol) throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkListeners>(){

            public Object run(NetworkListeners param) throws TransactionFailure {
                NetworkListener netListener = (NetworkListener)param.createChild(NetworkListener.class);
                netListener.setName(listener.getId());
                netListener.setEnabled(listener.getEnabled());
                netListener.setAddress(listener.getAddress());
                netListener.setPort(listener.getPort());
                netListener.setProtocol(protocol.getName());
                param.getNetworkListener().add(netListener);
                return null;
            }
        }, (ConfigBeanProxy)this.getNetworkListeners(baseConfig.getNetworkConfig()));
    }

    private NetworkListeners getNetworkListeners(NetworkConfig config) throws TransactionFailure {
        NetworkListeners listeners = config.getNetworkListeners();
        if (listeners == null) {
            listeners = (NetworkListeners)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkConfig>(){

                public Object run(NetworkConfig param) throws TransactionFailure {
                    NetworkListeners child = (NetworkListeners)param.createChild(NetworkListeners.class);
                    param.setNetworkListeners(child);
                    return child;
                }
            }, (ConfigBeanProxy)config);
        }
        return listeners;
    }

    private Protocol migrateToProtocols(NetworkConfig config, final HttpListener listener) throws TransactionFailure {
        Protocols protocols = GrizzlyConfigSchemaMigrator.getProtocols(config);
        return (Protocol)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocols>(){

            public Object run(Protocols param) throws TransactionFailure {
                Protocol protocol = (Protocol)param.createChild(Protocol.class);
                Ssl ssl = listener.getSsl();
                param.getProtocol().add(protocol);
                protocol.setName(listener.getId());
                protocol.setSsl(ssl);
                protocol.setSecurityEnabled(listener.getSecurityEnabled());
                GrizzlyConfigSchemaMigrator.this.createHttp(protocol, listener);
                return protocol;
            }
        }, (ConfigBeanProxy)protocols);
    }

    public static Protocols getProtocols(NetworkConfig config) throws TransactionFailure {
        Protocols protocols = config.getProtocols();
        if (protocols == null) {
            protocols = (Protocols)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkConfig>(){

                public Object run(NetworkConfig param) throws TransactionFailure {
                    Protocols child = (Protocols)param.createChild(Protocols.class);
                    param.setProtocols(child);
                    return child;
                }
            }, (ConfigBeanProxy)config);
        }
        return protocols;
    }

    private void createHttp(Protocol protocol, HttpListener listener) throws TransactionFailure {
        Http http = (Http)protocol.createChild(Http.class);
        protocol.setHttp(http);
        http.setDefaultVirtualServer(listener.getDefaultVirtualServer());
        http.setServerName(listener.getServerName());
        http.setRedirectPort(listener.getRedirectPort());
        http.setXpoweredBy(listener.getXpoweredBy());
    }
}

