/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.config.dom;

import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.ThreadPool;
import com.sun.grizzly.config.dom.Transport;
import org.jvnet.hk2.component.Injectable;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.DuckTyped;

@Configured
public interface NetworkListener
extends ConfigBeanProxy,
Injectable {
    @Attribute(defaultValue="0.0.0.0")
    public String getAddress();

    public void setAddress(String var1);

    @Attribute(defaultValue="true")
    public String getEnabled();

    public void setEnabled(String var1);

    @Attribute(required=true, key=true)
    public String getName();

    public void setName(String var1);

    @Attribute
    public String getPort();

    public void setPort(String var1);

    @DuckTyped
    public Protocol findProtocol();

    @Attribute(required=true)
    public String getProtocol();

    public void setProtocol(String var1);

    @DuckTyped
    public ThreadPool findThreadPool();

    @Attribute
    public String getThreadPool();

    public void setThreadPool(String var1);

    @DuckTyped
    public Transport findTransport();

    @Attribute(required=true)
    public String getTransport();

    public void setTransport(String var1);

    public static class Duck {
        public static Protocol findProtocol(NetworkListener listener) {
            String name = listener.getProtocol();
            NetworkConfig networkConfig = (NetworkConfig)listener.getParent().getParent(NetworkConfig.class);
            for (Protocol protocol : networkConfig.getProtocols().getProtocol()) {
                if (!protocol.getName().equals(name)) continue;
                return protocol;
            }
            return null;
        }

        public static ThreadPool findThreadPool(NetworkListener listener) {
            String name = listener.getThreadPool();
            for (ThreadPool threadPool : ConfigBean.unwrap((ConfigBeanProxy)listener).getHabitat().getAllByType(ThreadPool.class)) {
                if (!threadPool.getThreadPoolId().equals(name)) continue;
                return threadPool;
            }
            return null;
        }

        public static Transport findTransport(NetworkListener listener) {
            String name = listener.getTransport();
            NetworkConfig networkConfig = (NetworkConfig)listener.getParent().getParent(NetworkConfig.class);
            for (Transport transport : networkConfig.getTransports().getTransport()) {
                if (!transport.getName().equals(name)) continue;
                return transport;
            }
            return null;
        }
    }
}

