/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.admin.ncli;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.glassfish.enterprise.admin.ncli.comm.TargetServer;
import org.glassfish.enterprise.admin.ncli.metadata.CommandDesc;

final class CommandMetadataCache {
    private final Map<TargetServer, Set<CommandDesc>> s2d;

    CommandMetadataCache() {
        ConcurrentSkipListSet descs = new ConcurrentSkipListSet();
        this.s2d = new ConcurrentHashMap<TargetServer, Set<CommandDesc>>();
    }

    CommandDesc get(String cmdName, TargetServer ts) {
        Set<CommandDesc> scd = this.s2d.get(ts);
        if (scd == null) {
            return null;
        }
        for (CommandDesc aScd : scd) {
            CommandDesc cd = aScd;
            if (!cd.getName().equals(cmdName)) continue;
            this.buildAsync(ts);
            return cd;
        }
        this.buildAsync(ts);
        return null;
    }

    void put(String cmdName, TargetServer ts, CommandDesc desc) {
        Set<CommandDesc> scd = this.s2d.get(ts);
        scd.add(desc);
    }

    private void buildAsync(TargetServer ts) {
    }
}

