/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.admin.ncli;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.glassfish.enterprise.admin.ncli.Option;
import org.glassfish.enterprise.admin.ncli.ParseUtilities;
import org.glassfish.enterprise.admin.ncli.ProgramOptionBuilder;
import org.glassfish.enterprise.admin.ncli.comm.TargetServer;
import org.glassfish.enterprise.admin.ncli.metadata.OptionDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FirstPassResult {
    private final ProgramOptionBuilder POB = ProgramOptionBuilder.getInstance();
    private final String cmdName;
    private final TargetServer ts;
    private final Set<Option> programOptions;
    private final String[] cmdArgs;
    private final boolean usesDeprecatedSyntax;

    FirstPassResult(String cmdName, Map<String, String> poPair, String[] cmdArgs) {
        this(cmdName, poPair, cmdArgs, false);
    }

    public FirstPassResult(String cmdName, Map<String, String> poPair, String[] cmdArgs, boolean usesDeprecatedSyntax) {
        if (cmdName == null || poPair == null || cmdArgs == null) {
            throw new IllegalArgumentException("null_arg");
        }
        this.cmdName = cmdName;
        this.programOptions = this.initializeAllProgramOptions(poPair);
        this.ts = this.initializeTargetServer();
        this.cmdArgs = new String[cmdArgs.length];
        System.arraycopy(cmdArgs, 0, this.cmdArgs, 0, cmdArgs.length);
        this.usesDeprecatedSyntax = usesDeprecatedSyntax;
    }

    String getCommandName() {
        return this.cmdName;
    }

    TargetServer getTargetServer() {
        return this.ts;
    }

    String[] getCommandArguments() {
        int length = this.cmdArgs.length;
        String[] copy = new String[length];
        System.arraycopy(this.cmdArgs, 0, copy, 0, length);
        return copy;
    }

    Set<Option> getProgramOptions() {
        return this.programOptions;
    }

    boolean usesDeprecatedSyntax() {
        return this.usesDeprecatedSyntax;
    }

    private Set<Option> initializeAllProgramOptions(Map<String, String> explicitOpts) {
        Set<OptionDesc> validOnes = this.POB.getAllOptionMetadata();
        HashSet<Option> options = new HashSet<Option>();
        Set<String> names = explicitOpts.keySet();
        for (String name : names) {
            assert (ParseUtilities.getOptionDescForName(name, validOnes) != null) : "Programming Error: uncaught invalid program option: " + name;
            OptionDesc metadata = ParseUtilities.getMetadataFor(name, validOnes);
            assert (metadata != null) : "Programming Error: Program option metadata should never be null for: " + name;
            boolean added = options.add(new Option(metadata, explicitOpts.get(name)));
            assert (added) : "Programming Error: This option could not be added to the set: " + name;
        }
        Set<OptionDesc> defaultThem = ParseUtilities.getAllOptionMetadataExcluding(validOnes, names);
        for (OptionDesc od : defaultThem) {
            Option defOpt = new Option(od, null);
            options.add(defOpt);
        }
        return Collections.unmodifiableSet(options);
    }

    private TargetServer initializeTargetServer() {
        String host = null;
        int port = -1;
        String user = null;
        String password = null;
        boolean secure = false;
        for (Option po : this.programOptions) {
            String name = po.getName();
            if ("host".equals(name)) {
                host = po.getEffectiveValue();
            }
            if ("port".equals(name)) {
                port = Integer.parseInt(po.getEffectiveValue());
            }
            if ("user".equals(name)) {
                user = po.getEffectiveValue();
            }
            if ("password".equals(name)) {
                password = po.getEffectiveValue();
            }
            if (!"secure".equals(name)) continue;
            secure = Boolean.valueOf(po.getEffectiveValue());
        }
        return new TargetServer(host, port, user, password, secure);
    }
}

