/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.admin.ncli;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.glassfish.api.admin.cli.OptionType;
import org.glassfish.enterprise.admin.ncli.metadata.OptionDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Option {
    private final OptionDesc metadata;
    private final String givenValue;

    Option(OptionDesc metadata, String givenValue) {
        if (metadata == null) {
            throw new IllegalArgumentException("null option metadata");
        }
        this.metadata = metadata;
        if ("BOOLEAN".equals(metadata.getType()) && !"TRUE".equalsIgnoreCase(givenValue) && !"FALSE".equalsIgnoreCase("FALSE")) {
            throw new IllegalArgumentException("A boolean option has be specified as true or false only");
        }
        this.givenValue = givenValue;
    }

    String getName() {
        return this.metadata.getName();
    }

    String getEffectiveValue() {
        String value;
        String string = value = this.givenValue != null ? this.givenValue : this.metadata.getDefaultValue();
        if (value == null) {
            return value;
        }
        String type = this.getEffectiveType();
        if (OptionType.FILE.name().equals(type) || OptionType.DIRECTORY.name().equals(type) || OptionType.FILE_PATH.name().equals(type)) {
            return new File(value).getAbsolutePath();
        }
        if (OptionType.BOOLEAN.name().equals(type)) {
            return value.toLowerCase();
        }
        return value;
    }

    String getEffectiveType() {
        if (this.metadata.getOverridingType() == null) {
            return this.metadata.getType();
        }
        return this.metadata.getOverridingType().getType();
    }

    String getDefaultValue() {
        return this.metadata.getDefaultValue();
    }

    boolean repeats() {
        String mr = this.metadata.getRepeats();
        return Boolean.valueOf(mr);
    }

    boolean required() {
        String mr = this.metadata.getRequired();
        return Boolean.valueOf(mr);
    }

    boolean hasSymbol() {
        String ms = this.metadata.getSymbol();
        return ms != null;
    }

    char getSymbol() {
        String ms = this.metadata.getSymbol();
        if (ms == null) {
            return '\u0000';
        }
        assert (ms.length() == 1) : "Symbol has to be a single ASCII character";
        return ms.charAt(0);
    }

    List<String> getLegalValues() {
        String lv = this.metadata.getLegalValues();
        if (lv == null) {
            return Collections.emptyList();
        }
        StringTokenizer st = new StringTokenizer(lv, ",");
        ArrayList<String> values = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            values.add(st.nextToken());
        }
        return values;
    }

    public String toString() {
        return this.getName() + "=" + this.getEffectiveValue();
    }

    static String toString(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("null arg");
        }
        return name + "=" + value;
    }

    static String toCommandLineOption(String s) {
        return "--" + s;
    }

    static String toCommandLineOption(char c) {
        return "-" + c;
    }
}

