/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.config;

import java.nio.ByteBuffer;

public class HttpParserState {
    public static final int PARAMETER_NOT_SET = Integer.MIN_VALUE;
    public static final int DEFAULT_STATE_PARAMETERS_NUM = 5;
    private ByteBuffer buffer;
    private boolean isCompleted;
    private int state;
    private int position;
    private final int[] stateParameters;

    public HttpParserState() {
        this(5);
    }

    public HttpParserState(int stateParametersNum) {
        this.stateParameters = new int[stateParametersNum];
        for (int i = 0; i < this.stateParameters.length; ++i) {
            this.stateParameters[i] = Integer.MIN_VALUE;
        }
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getStateParameter(int i) {
        return this.stateParameters[i];
    }

    public int getStateParameter(int i, int defaultValue) {
        int value = this.stateParameters[i];
        return value != Integer.MIN_VALUE ? value : defaultValue;
    }

    public void setStateParameter(int i, int value) {
        this.stateParameters[i] = value;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void setCompleted(boolean isCompleted) {
        this.isCompleted = isCompleted;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HttpParser state(").append(this.hashCode()).append(')');
        sb.append(" Buffer: ").append(this.buffer);
        sb.append(" isCompleted: ").append(this.isCompleted);
        sb.append(" State: ").append(this.state);
        sb.append(" position: ").append(this.position);
        for (int i = 0; i < this.stateParameters.length; ++i) {
            sb.append("; parameter[").append(i).append("]: ").append(this.stateParameters[i]);
        }
        return sb.toString();
    }
}

