/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.embedded;

import com.sun.enterprise.module.bootstrap.PlatformMain;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import org.glassfish.api.embedded.EmbeddedContainer;
import org.glassfish.api.embedded.EmbeddedContainerInfo;
import org.glassfish.api.embedded.EmbeddedDeployer;
import org.glassfish.api.embedded.EmbeddedFileSystem;
import org.glassfish.api.embedded.Port;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Contract
public class Server {
    public final String serverName;
    public final boolean loggerEnabled;
    public final boolean verbose;
    public final File loggerFile;
    public final EmbeddedFileSystem fileSystem;
    private final Habitat habitat;
    private final List<EmbeddedContainer> containers = new ArrayList<EmbeddedContainer>();

    private Server(Builder builder) {
        this.serverName = builder.serverName;
        this.loggerEnabled = builder.loggerEnabled;
        this.verbose = builder.verbose;
        this.loggerFile = builder.loggerFile;
        this.fileSystem = builder.fileSystem;
        PlatformMain embedded = this.getMain();
        if (embedded == null) {
            throw new RuntimeException("Embedded startup not found");
        }
        embedded.setContext((Object)this);
        try {
            embedded.start(new String[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.habitat = (Habitat)embedded.getStartedService(Habitat.class);
    }

    public <T extends EmbeddedContainerInfo> T createConfig(Class<T> configType) {
        return (T)((EmbeddedContainerInfo)this.habitat.getComponent(configType));
    }

    public <T extends EmbeddedContainer> T addContainer(EmbeddedContainerInfo<T> info) {
        T container = info.create(this);
        if (container != null && this.containers.add((EmbeddedContainer)container)) {
            return container;
        }
        return null;
    }

    public Collection<EmbeddedContainer> getContainers() {
        ArrayList<EmbeddedContainer> copy = new ArrayList<EmbeddedContainer>();
        copy.addAll(this.containers);
        return copy;
    }

    public Port createPort(int portNumber) {
        Port port = (Port)this.habitat.getComponent(Port.class);
        port.bind(portNumber);
        return port;
    }

    public Habitat getHabitat() {
        return this.habitat;
    }

    public String getName() {
        return this.serverName;
    }

    public void start() {
        for (EmbeddedContainer container : this.containers) {
            container.start();
        }
    }

    public void stop() {
        for (EmbeddedContainer container : this.containers) {
            container.stop();
        }
    }

    public EmbeddedDeployer getDeployer() {
        return (EmbeddedDeployer)this.habitat.getByContract(EmbeddedDeployer.class);
    }

    private PlatformMain getMain() {
        ServiceLoader<PlatformMain> mains = ServiceLoader.load(PlatformMain.class, Server.class.getClassLoader());
        for (PlatformMain main : mains) {
            if (!main.getName().equals("Embedded")) continue;
            return main;
        }
        return null;
    }

    public static class Builder {
        final String serverName;
        boolean loggerEnabled;
        boolean verbose;
        File loggerFile;
        EmbeddedFileSystem fileSystem;

        public Builder(String id) {
            this.serverName = id;
        }

        public Builder setLogger(boolean enabled) {
            this.loggerEnabled = enabled;
            return this;
        }

        public Builder setLogFile(File f) {
            this.loggerFile = f;
            return this;
        }

        public Builder setVerbose(boolean b) {
            this.verbose = b;
            return this;
        }

        public Builder setEmbeddedFileSystem(EmbeddedFileSystem fileSystem) {
            this.fileSystem = fileSystem;
            return this;
        }

        public Server build() {
            return new Server(this);
        }
    }
}

