/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class GFLauncherLogger {
    private static final Logger logger;
    private static final LocalStringsImpl strings;
    private static FileHandler logfileHandler;

    public static void info(String msg, Object ... objs) {
        logger.info(strings.get(msg, objs));
    }

    public static void severe(String msg, Object ... objs) {
        logger.severe(strings.get(msg, objs));
    }

    public static void fine(String msg, Object ... objs) {
        logger.fine(strings.get(msg, objs));
    }

    static synchronized void setConsoleLevel(Level level) {
        for (Logger parent = logger; parent != null; parent = parent.getParent()) {
            Handler[] handlers;
            for (Handler h : handlers = parent.getHandlers()) {
                if (!ConsoleHandler.class.isAssignableFrom(h.getClass())) continue;
                h.setLevel(level);
            }
        }
    }

    static synchronized void addLogFileHandler(String logFile) {
        try {
            boolean wasCreated;
            File parent;
            if (logFile == null || logfileHandler != null) {
                return;
            }
            File f = new File(logFile);
            if (!(f.exists() || (parent = f.getParentFile()).isDirectory() || (wasCreated = parent.mkdirs()))) {
                return;
            }
            logfileHandler = new FileHandler(logFile, true);
            logfileHandler.setFormatter(new SimpleFormatter());
            logfileHandler.setLevel(Level.INFO);
            logger.addHandler(logfileHandler);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static synchronized void removeLogFileHandler() {
        if (logfileHandler != null) {
            logger.removeHandler(logfileHandler);
            logfileHandler.close();
            logfileHandler = null;
        }
    }

    private GFLauncherLogger() {
    }

    static {
        strings = new LocalStringsImpl(GFLauncherLogger.class);
        logger = Logger.getLogger(GFLauncherLogger.class.getName());
        logger.setLevel(Level.INFO);
    }
}

