/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.autodeploy;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.deployment.autodeploy.AutoDeployDirectoryScanner;
import org.glassfish.deployment.autodeploy.AutoDeploymentException;
import org.glassfish.deployment.autodeploy.AutoDeploymentOperation;
import org.glassfish.deployment.autodeploy.AutoUndeploymentOperation;
import org.glassfish.deployment.autodeploy.AutodeployRetryManager;
import org.glassfish.deployment.autodeploy.DirectoryScanner;
import org.glassfish.deployment.common.DeploymentUtils;
import org.jvnet.hk2.component.Habitat;

public class AutoDeployer {
    private Boolean verify = null;
    private Boolean forceDeploy = null;
    private Boolean enabled = null;
    private Boolean jspPreCompilation = null;
    private boolean renameOnSuccess = true;
    private File directory = null;
    private String virtualServer = null;
    private String target = null;
    static final Logger sLogger = LogDomains.getLogger(DeploymentUtils.class, (String)"javax.enterprise.system.tools.deployment");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AutoDeployer.class);
    private DirectoryScanner directoryScanner = null;
    private boolean cancelDeployment = false;
    private AtomicBoolean inProgress = new AtomicBoolean(false);
    private Habitat habitat;
    protected static final int DEPLOY_SUCCESS = 1;
    protected static final int DEPLOY_FAILURE = 2;
    protected static final int DEPLOY_PENDING = 3;
    private AutodeployRetryManager retryManager;
    private static final boolean DEFAULT_RENAME_ON_SUCCESS = true;
    private static final boolean DEFAULT_FORCE_DEPLOY = true;
    private static final boolean DEFAULT_INCLUDE_SUBDIR = false;
    private static final boolean DEFAULT_ENABLED = true;
    static final String STATUS_SUBDIR_PATH = ".autodeploystatus";

    public AutoDeployer(String target, String directoryPath, String virtualServer, Habitat habitat) throws AutoDeploymentException {
        this(target, directoryPath, virtualServer, false, false, habitat);
    }

    public AutoDeployer(String target, String directoryPath, String virtualServer, boolean jspPrecompilationEnabled, boolean verifierEnabled, boolean renameOnSuccess, boolean forceDeploy, boolean enabled, Habitat habitat) throws AutoDeploymentException {
        this.setTarget(target);
        this.setDirectory(directoryPath);
        this.setJspPrecompilationEnabled(jspPrecompilationEnabled);
        this.setVerifierEnabled(verifierEnabled);
        this.setRenameOnSuccess(renameOnSuccess);
        this.setForceDeploy(forceDeploy);
        this.setVirtualServer(virtualServer);
        this.setEnabled(enabled);
        this.setHabitat(habitat);
        this.setRetryManager(habitat);
    }

    public AutoDeployer(String target, String directoryPath, String virtualServer, boolean jspPrecompilationEnabled, boolean verifierEnabled, Habitat habitat) throws AutoDeploymentException {
        this(target, directoryPath, virtualServer, jspPrecompilationEnabled, verifierEnabled, true, true, true, habitat);
    }

    public void setHabitat(Habitat habitat) {
        this.habitat = habitat;
    }

    public void setJspPrecompilationEnabled(boolean setting) {
        this.jspPreCompilation = setting;
    }

    public void setDirectory(String directoryPath) throws AutoDeploymentException {
        this.validateAutodeployDirectory(directoryPath);
        this.directory = new File(directoryPath);
    }

    public void setVerifierEnabled(boolean verify) {
        this.verify = verify;
    }

    private void validateAutodeployDirectory(String autodeployDirPath) throws AutoDeploymentException {
        File autodeployDir = new File(autodeployDirPath);
        this.validateDirectory(autodeployDir);
        File statusDir = new File(autodeployDir, STATUS_SUBDIR_PATH);
        this.validateDirectory(statusDir);
    }

    private void validateDirectory(File dirFile) throws AutoDeploymentException {
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        } else if (!dirFile.isDirectory()) {
            throw new AutoDeploymentException(localStrings.getLocalString("enterprise.deployment.autodeploy.invalid_source_dir", "invalid source directory {0}", new Object[]{dirFile}));
        }
        if (!dirFile.canRead()) {
            throw new AutoDeploymentException(localStrings.getLocalString("enterprise.deployment.autodeploy.dir_not_readable", "directory {0} not readable", new Object[]{dirFile}));
        }
        if (!dirFile.canWrite()) {
            throw new AutoDeploymentException(localStrings.getLocalString("enterprise.deployment.autodeploy.dir_not_writeable", "directory {0} not writable", new Object[]{dirFile}));
        }
    }

    private void setRenameOnSuccess(boolean rename) {
        this.renameOnSuccess = rename;
    }

    private void setForceDeploy(boolean force) {
        this.forceDeploy = force;
    }

    private void setVirtualServer(String vs) {
        this.virtualServer = vs;
    }

    private void setEnabled(boolean setting) {
        this.enabled = setting;
    }

    public void setDirectoryScanner(DirectoryScanner ds) {
        this.directoryScanner = ds;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void disableRenameOnSuccess() {
        this.renameOnSuccess = false;
    }

    public void enableRenameOnSuccess() {
        this.renameOnSuccess = true;
    }

    public void setVerify(boolean verify) {
        this.verify = verify;
    }

    public void setJspPreCompilation(boolean jspPreCompilation) {
        this.jspPreCompilation = jspPreCompilation;
    }

    public void run() {
        if (this.directory.exists()) {
            this.run(false);
            this.cancelDeployment = false;
        } else {
            sLogger.fine("autodeploy directory does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(boolean includeSubdir) {
        this.markInProgress();
        try {
            this.deployAll(this.directory, includeSubdir);
            this.undeployAll(this.directory, includeSubdir);
        }
        catch (AutoDeploymentException e) {
            sLogger.log(Level.SEVERE, e.getMessage(), (Throwable)((Object)e));
        }
        finally {
            this.clearInProgress();
        }
    }

    private void setRetryManager(Habitat habitat) {
        this.retryManager = (AutodeployRetryManager)habitat.getComponent(AutodeployRetryManager.class);
    }

    private void markInProgress() {
        this.inProgress.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearInProgress() {
        AtomicBoolean atomicBoolean = this.inProgress;
        synchronized (atomicBoolean) {
            this.inProgress.set(false);
            this.inProgress.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilIdle() throws InterruptedException {
        AtomicBoolean atomicBoolean = this.inProgress;
        synchronized (atomicBoolean) {
            if (this.inProgress.get()) {
                this.inProgress.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployAll(File autoDeployDir, boolean includeSubDir) throws AutoDeploymentException {
        if (this.directoryScanner == null) {
            this.directoryScanner = new AutoDeployDirectoryScanner();
        }
        Object[] files = null;
        files = this.directoryScanner.getAllDeployableModules(autoDeployDir, includeSubDir);
        if (files != null && files.length > 0) {
            sLogger.fine("Deployable files: " + Arrays.toString(files));
            for (int i = 0; i < files.length && !this.cancelDeployment; ++i) {
                boolean okToRecordResult = true;
                try {
                    okToRecordResult = this.deploy((File)files[i], autoDeployDir) != AutodeploymentStatus.PENDING;
                    continue;
                }
                catch (AutoDeploymentException ae) {
                    continue;
                }
                finally {
                    if (this.renameOnSuccess && okToRecordResult) {
                        sLogger.fine("Reporting deployed entity " + ((File)files[i]).getAbsolutePath());
                        this.directoryScanner.deployedEntity(autoDeployDir, (File)files[i]);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeployAll(File autoDeployDir, boolean includeSubdir) throws AutoDeploymentException {
        if (this.directoryScanner == null) {
            this.directoryScanner = new AutoDeployDirectoryScanner();
        }
        File[] apps = null;
        apps = this.directoryScanner.getAllFilesForUndeployment(autoDeployDir, includeSubdir);
        if (apps != null) {
            for (int i = 0; i < apps.length && !this.cancelDeployment; ++i) {
                try {
                    this.undeploy(apps[i], autoDeployDir, AutoDeployer.getNameFromFilePath(autoDeployDir, apps[i]));
                    continue;
                }
                catch (AutoDeploymentException ae) {
                    continue;
                }
                finally {
                    this.directoryScanner.undeployedEntity(autoDeployDir, apps[i]);
                }
            }
        }
    }

    private AutodeploymentStatus undeploy(File applicationFile, File autodeployDir, String name) throws AutoDeploymentException {
        AutoUndeploymentOperation au = AutoUndeploymentOperation.newInstance(this.habitat, applicationFile, name, this.target);
        sLogger.log(Level.INFO, "Autoundeploying application :" + name);
        return au.run();
    }

    public void cancel(boolean value) {
        this.cancelDeployment = value;
    }

    public boolean isCancelled() {
        return this.cancelDeployment;
    }

    protected AutodeploymentStatus deploy(File deployablefile, File autodeployDir) throws AutoDeploymentException {
        AutodeploymentStatus status = AutodeploymentStatus.FAILURE;
        String file = deployablefile.getAbsolutePath();
        if (!this.retryManager.shouldAttemptDeployment(deployablefile)) {
            return AutodeploymentStatus.PENDING;
        }
        String msg = localStrings.getLocalString("enterprise.deployment.autodeploy.selecting_file", "selecting {0} for autodeployment", new Object[]{file});
        sLogger.log(Level.INFO, msg);
        AutoDeploymentOperation ad = AutoDeploymentOperation.newInstance(this.habitat, this.renameOnSuccess, deployablefile, this.enabled, this.virtualServer, this.forceDeploy, this.verify, this.jspPreCompilation, this.target);
        AutodeploymentStatus adStatus = ad.run();
        return adStatus;
    }

    static String getNameFromFilePath(File autodeployDir, File filePath) {
        File parent = filePath.getParentFile();
        String moduleName = null;
        while (!parent.getAbsolutePath().equals(autodeployDir.getAbsolutePath())) {
            moduleName = moduleName == null ? parent.getName() : parent.getName() + "_" + moduleName;
            parent = parent.getParentFile();
        }
        int toIndex = (moduleName = moduleName == null ? filePath.getName() : moduleName + "_" + filePath.getName()).lastIndexOf(46);
        if (toIndex > 0) {
            moduleName = moduleName.substring(0, toIndex);
        }
        return moduleName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AutodeploymentStatus {
        SUCCESS(true, ActionReport.ExitCode.SUCCESS, "enterprise.deployment.autodeploy.successfully_autodeployed", "deployment of {0} succeeded", "enterprise.deployment.autodeploy.successfully_autoundeployed", "undeployment of {0} succeeded"),
        FAILURE(false, ActionReport.ExitCode.FAILURE, "enterprise.deployment.autodeploy.autodeploy_failed", "deployment of {0} failed", "enterprise.deployment.autodeploy.autoundeploy_failed", "undeployment of {0} failed"),
        WARNING(true, ActionReport.ExitCode.WARNING, "enterprise.deployment.autodeploy.warning_autodeployed", "deployment of {0} succeeded with warning(s)", "enterprise.deployment.autodeploy.warning_autoundeployed", "undeployment of {0} succeeded with warning(s)"),
        PENDING(true, ActionReport.ExitCode.SUCCESS, "", "", "", "");

        protected final boolean status;
        protected final ActionReport.ExitCode exitCode;
        protected final String deploymentMessageKey;
        protected final String undeploymentMessageKey;
        protected final String deploymentDefaultMessage;
        protected final String undeploymentDefaultMessage;

        private AutodeploymentStatus(boolean status, ActionReport.ExitCode exitCode, String deploymentMessageKey, String deploymentDefaultMessage, String undeploymentMessageKey, String undeploymentDefaultMessage) {
            this.status = status;
            this.exitCode = exitCode;
            this.deploymentMessageKey = deploymentMessageKey;
            this.deploymentDefaultMessage = deploymentDefaultMessage;
            this.undeploymentMessageKey = undeploymentMessageKey;
            this.undeploymentDefaultMessage = undeploymentDefaultMessage;
        }

        public static AutodeploymentStatus forExitCode(ActionReport.ExitCode exitCode) {
            for (AutodeploymentStatus ds : AutodeploymentStatus.values()) {
                if (ds.exitCode != exitCode) continue;
                return ds;
            }
            throw new IllegalArgumentException(exitCode.toString());
        }
    }
}

