/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLIConstants;
import com.sun.enterprise.admin.cli.ListCommandsCommand;
import com.sun.enterprise.admin.cli.remote.CLIRemoteCommand;
import com.sun.enterprise.admin.cli.remote.NCLIRemoteCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CLIMain;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.InvalidCommandException;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.ConnectException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsadminMain {
    private static final int ERROR = 1;
    private static final int CONNECTION_ERROR = 2;
    private static final int INVALID_COMMAND_ERROR = 3;
    private static final int SUCCESS = 0;
    private static final LocalStringsImpl strings = new LocalStringsImpl(AsadminMain.class);
    private static String[] copyOfArgs;
    private static String classPath;
    private static String className;
    private static String command;
    private static Map<String, String> systemProps;

    public static void main(String[] args) {
        int exitCode;
        if (CLIConstants.debugMode) {
            System.setProperty("WALL_CLOCK_START", "" + System.currentTimeMillis());
            CLILogger.getInstance().printDebugMessage("CLASSPATH= " + System.getProperty("java.class.path") + "\nCommands: " + Arrays.toString(args));
        }
        AsadminMain main = new AsadminMain();
        if (args.length <= 0) {
            String msg = strings.get("AsadminUsageMessage");
            System.out.println(msg);
            System.exit(0);
        }
        copyOfArgs = new String[args.length];
        classPath = SmartFile.sanitizePaths((String)System.getProperty("java.class.path"));
        className = main.getClass().getName();
        System.arraycopy(args, 0, copyOfArgs, 0, args.length);
        command = args[0];
        try {
            exitCode = main.local(args);
        }
        catch (InvalidCommandException e) {
            if (args[0].equals("help")) {
                exitCode = main.remote(new String[]{args[1], "--help"});
                command = args[1];
            }
            CLILogger.getInstance().printDebugMessage(e.getMessage());
            exitCode = main.remote(args);
        }
        if (exitCode == 0) {
            CLILogger.getInstance().printDetailMessage(strings.get("CommandSuccessful", new Object[]{command}));
        }
        if (exitCode == 1) {
            CLILogger.getInstance().printDetailMessage(strings.get("CommandUnSuccessful", new Object[]{command}));
        }
        if (exitCode == 3) {
            try {
                CLIMain.displayClosestMatch(command, main.getRemoteCommands(), strings.get("ClosestMatchedLocalAndRemoteCommands"));
            }
            catch (InvalidCommandException e) {
                // empty catch block
            }
            CLILogger.getInstance().printDetailMessage(strings.get("CommandUnSuccessful", new Object[]{command}));
        }
        if (exitCode == 2) {
            try {
                CLIMain.displayClosestMatch(command, null, strings.get("ClosestMatchedLocalCommands"));
            }
            catch (InvalidCommandException e) {
                CLILogger.getInstance().printMessage(strings.get("InvalidRemoteCommand", new Object[]{command}));
            }
            CLILogger.getInstance().printDetailMessage(strings.get("CommandUnSuccessful", new Object[]{command}));
        }
        AsadminMain.writeCommandToDebugLog(args, exitCode);
        System.exit(exitCode);
    }

    public int local(String[] args) throws InvalidCommandException {
        try {
            CLIMain cli = new CLIMain();
            cli.invokeCommand(args);
            return 0;
        }
        catch (CommandException ce) {
            CLILogger.getInstance().printError(ce.getMessage());
            return 1;
        }
        catch (CommandValidationException cve) {
            CLILogger.getInstance().printError(cve.getMessage());
            return 1;
        }
        catch (NoClassDefFoundError ncdfe) {
            CLILogger.getInstance().printError(ncdfe.toString());
            return 1;
        }
        catch (InvalidCommandException ice) {
            throw ice;
        }
        catch (Throwable ex) {
            CLILogger.getInstance().printExceptionStackTrace(ex);
            CLILogger.getInstance().printError(ex.toString());
            return 1;
        }
    }

    public int remote(String[] args) {
        try {
            if (System.getenv("ASADMIN_NEW") != null) {
                NCLIRemoteCommand rc = new NCLIRemoteCommand(args);
                command = rc.getCommandName();
                rc.runCommand();
            } else {
                CLIRemoteCommand rc = new CLIRemoteCommand(args);
                rc.runCommand();
            }
            return 0;
        }
        catch (Throwable ex) {
            CLILogger.getInstance().printExceptionStackTrace(ex);
            CLILogger.getInstance().printMessage(ex.getMessage());
            if (ex.getCause() instanceof ConnectException) {
                return 2;
            }
            if (ex.getCause() instanceof InvalidCommandException) {
                return 3;
            }
            return 1;
        }
    }

    public static Map<String, String> getSystemProps() {
        return Collections.unmodifiableMap(systemProps);
    }

    static String[] getArgs() {
        return copyOfArgs;
    }

    static String getClassPath() {
        return classPath;
    }

    static String getClassName() {
        return className;
    }

    private Map<String, String> getRemoteCommands() {
        try {
            ListCommandsCommand lcc = new ListCommandsCommand();
            String[] remoteCommands = lcc.getRemoteCommands();
            Hashtable<String, String> remoteCommandsMap = new Hashtable<String, String>();
            for (String rc : remoteCommands) {
                remoteCommandsMap.put(rc, "remote command");
            }
            return remoteCommandsMap;
        }
        catch (CommandException ce) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCommandToDebugLog(String[] args, int exit) {
        File log = AsadminMain.getDebugLogfile();
        if (log == null) {
            return;
        }
        Writer out = null;
        try {
            out = new BufferedWriter(new FileWriter(log, true));
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            Date date = new Date();
            out.write(dateFormat.format(date));
            out.write(" EXIT: " + exit);
            out.write(" asadmin ");
            if (args != null) {
                for (int i = 0; args != null && i < args.length; ++i) {
                    out.write(args[i] + " ");
                }
            }
        }
        catch (IOException e) {
        }
        finally {
            if (out != null) {
                try {
                    out.write("\n");
                    ((BufferedWriter)out).close();
                }
                catch (Exception e) {}
            }
        }
    }

    private static File getDebugLogfile() {
        String fname = AsadminMain.getEnvOrSysProp("AS_LOGFILE");
        if (fname == null) {
            return null;
        }
        File f = new File(fname);
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (f.isFile() && f.canWrite()) {
            return f;
        }
        return null;
    }

    private static String getEnvOrSysProp(String index) {
        String s1 = System.getProperty(index);
        String s2 = System.getenv(index);
        if (s1 != null) {
            return s1;
        }
        return s2;
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    static {
        systemProps = new ASenvPropertyReader().getProps();
        String ir = "com.sun.aas.installRoot";
        String cr = "com.sun.aas.configRoot";
        String irVal = systemProps.get("com.sun.aas.installRoot");
        String crVal = systemProps.get("com.sun.aas.configRoot");
        if (AsadminMain.ok(irVal)) {
            System.setProperty("com.sun.aas.installRoot", irVal);
        }
        if (AsadminMain.ok(crVal)) {
            System.setProperty("com.sun.aas.configRoot", crVal);
        }
    }
}

