/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.ncli;

import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.glassfish.admin.ncli.ParserException;
import org.glassfish.admin.ncli.metadata.OptionDesc;
import org.glassfish.api.admin.cli.OptionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Parser {
    private final Set<OptionDesc> options;
    private final boolean ignoreUnknown;
    private Map<String, String> optionMap;
    private String[] operands;
    private static final LocalStringsImpl lsm = new LocalStringsImpl(Parser.class);

    Parser(Set<OptionDesc> options, boolean ignoreUnknown) {
        this.ignoreUnknown = ignoreUnknown;
        this.options = options;
    }

    public Map<String, String> getOptions() {
        return this.optionMap;
    }

    public String[] getOperands() {
        return this.operands;
    }

    void parse(String[] argv, int start) throws ParserException {
        this.optionMap = new HashMap<String, String>();
        this.operands = null;
        ArrayList<String> remainingArgs = new ArrayList<String>();
        block0: for (int si = start; si < argv.length; ++si) {
            String arg = argv[si];
            if (arg.equals("--")) {
                while (si < argv.length) {
                    remainingArgs.add(argv[si++]);
                }
                break;
            }
            if (!arg.startsWith("-") || arg.length() <= 1) {
                remainingArgs.add(arg);
                ++si;
                if (this.ignoreUnknown) continue;
                while (si < argv.length) {
                    remainingArgs.add(argv[si++]);
                }
                break;
            }
            OptionDesc opt = null;
            String name = null;
            String value = null;
            if (arg.charAt(1) == '-') {
                int ne;
                int ns = 2;
                if (arg.startsWith("--no-")) {
                    value = "false";
                    ns = 5;
                }
                if ((ne = arg.indexOf(61)) < 0) {
                    name = arg.substring(ns);
                } else {
                    if (value != null) {
                        throw new ParserException(lsm.get("no.with.value", new Object[]{arg}));
                    }
                    name = arg.substring(ns, ne);
                    value = arg.substring(ne + 1);
                }
                opt = this.lookupLongOption(name);
            } else if (arg.length() <= 2) {
                opt = this.lookupShortOption(arg.charAt(1));
                name = arg.substring(1);
            } else if (arg.charAt(2) == '=') {
                opt = this.lookupShortOption(arg.charAt(1));
                value = arg.substring(3);
            } else {
                for (int i = 1; i < arg.length(); ++i) {
                    opt = this.lookupShortOption(arg.charAt(i));
                    if (opt == null) {
                        if (!this.ignoreUnknown) {
                            throw new ParserException(lsm.get("invalid.option", new Object[]{Character.toString(arg.charAt(i))}));
                        }
                        remainingArgs.add(arg);
                        continue block0;
                    }
                    this.setOption(opt, "true");
                }
                continue;
            }
            if (opt == null) {
                if (!this.ignoreUnknown) {
                    throw new ParserException(lsm.get("invalid.option", new Object[]{arg}));
                }
                remainingArgs.add(arg);
                continue;
            }
            if (value == null && Parser.optionRequiresOperand(opt)) {
                if (++si >= argv.length) {
                    throw new ParserException(lsm.get("missing.value.for.known.option", new Object[]{name}));
                }
                value = argv[si];
            }
            this.setOption(opt, value);
        }
        this.operands = remainingArgs.toArray(new String[remainingArgs.size()]);
    }

    private OptionDesc lookupLongOption(String s) {
        for (OptionDesc od : this.options) {
            if (!od.getName().equals(s)) continue;
            return od;
        }
        return null;
    }

    private OptionDesc lookupShortOption(char c) {
        String sc = Character.toString(c);
        for (OptionDesc od : this.options) {
            if (!od.getSymbol().equals(sc)) continue;
            return od;
        }
        return null;
    }

    private static boolean optionRequiresOperand(OptionDesc opt) {
        return !opt.getType().equals("BOOLEAN");
    }

    private static boolean nonNullValueValidFor(OptionDesc po, String value) {
        if (value == null) {
            return true;
        }
        if (po == null) {
            throw new IllegalArgumentException("null arg");
        }
        value = value.trim();
        if (OptionType.FILE.name().equals(po.getType())) {
            File f = new File(value);
            return f.isFile() || f.canRead();
        }
        if (OptionType.BOOLEAN.name().equals(po.getType())) {
            return value.toLowerCase(Locale.US).equals("true") || value.toLowerCase().toLowerCase(Locale.US).equals("false");
        }
        return true;
    }

    private void setOption(OptionDesc opt, String value) throws ParserException {
        String name = opt.getName();
        if (!Parser.nonNullValueValidFor(opt, value)) {
            throw new ParserException(lsm.get("invalid.value.for.known.option", new Object[]{name, value}));
        }
        if (!Boolean.valueOf(opt.getRepeats().toLowerCase()).booleanValue() && this.optionMap.containsKey(name)) {
            throw new ParserException(lsm.get("repeats.not.allowed", new Object[]{name}));
        }
        if (OptionType.PASSWORD.name().equals(opt.getType())) {
            throw new ParserException(lsm.get("password.not.allowed.on.command.line", new Object[]{opt.getName()}));
        }
        if (OptionType.BOOLEAN.name().equals(opt.getType()) && value == null) {
            value = "true";
        }
        this.optionMap.put(name, value);
    }
}

