/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.listener;

import com.sun.enterprise.config.serverbeans.JavaConfig;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GenericJavaConfigListener
implements PostConstruct,
ConfigListener {
    @Inject
    JavaConfig jc;
    List<String> oldProps;
    @Inject
    Logger logger;
    private static final String SYS_PROP_REGEX = "=";

    public void postConstruct() {
        if (this.jc != null && this.jc.getJvmOptions() != null) {
            this.oldProps = new ArrayList<String>(this.jc.getJvmOptions());
        }
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        UnprocessedChangeEvents unp = ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new Changed(){

            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> tc, T t) {
                JavaConfig njc = (JavaConfig)t;
                GenericJavaConfigListener.this.logFine(type, njc);
                NotProcessed result = null;
                if (GenericJavaConfigListener.this.oldProps.size() == njc.getJvmOptions().size()) {
                    result = new NotProcessed("A java-config attribute was changed, restart required");
                } else {
                    result = GenericJavaConfigListener.this.handle(GenericJavaConfigListener.this.oldProps, njc.getJvmOptions());
                    GenericJavaConfigListener.this.oldProps = new ArrayList<String>(((JavaConfig)t).getJvmOptions());
                }
                return result;
            }
        }, null);
        return unp;
    }

    private void logFine(Changed.TYPE ct, JavaConfig njc) {
        Level level = Level.FINE;
        if (this.logger.isLoggable(level)) {
            this.logger.log(level, "<java-config> changed");
            int os = this.oldProps.size();
            int ns = njc.getJvmOptions().size();
            if (os > ns) {
                this.logger.log(level, "a system property or a JVM option was removed (old size = " + os + "), new size: (" + ns + "), restart is required, based on the property");
            } else if (os < ns) {
                this.logger.log(level, "a system property or a JVM option was added, (old size = " + os + "), new size: (" + ns + "), restart is required, based on the property");
            } else {
                this.logger.log(level, "an attribute was changed, restart required");
            }
        }
    }

    private NotProcessed handle(List<String> olds, List<String> news) {
        if (olds.size() > news.size()) {
            List<String> removals = olds.subList(news.size(), olds.size());
            NotProcessed np = this.getNotProcessedRemovals(removals);
            return np;
        }
        if (olds.size() < news.size()) {
            List<String> adds = news.subList(olds.size(), news.size());
            NotProcessed np = this.getNotProcessedAdds(adds);
            return np;
        }
        return null;
    }

    private NotProcessed getNotProcessedRemovals(List<String> removals) {
        String npReason = "";
        for (String s : removals) {
            if (this.possiblyDynamicallyReconfigurable(s)) {
                String[] nv = s.split(SYS_PROP_REGEX);
                System.clearProperty(nv[0].substring(2));
                continue;
            }
            npReason = npReason + "Removal of: " + s + " can not take effect without server restart, ";
        }
        if (npReason.length() != 0) {
            return new NotProcessed(npReason);
        }
        return null;
    }

    private NotProcessed getNotProcessedAdds(List<String> adds) {
        String npReason = "";
        for (String s : adds) {
            if (this.possiblyDynamicallyReconfigurable(s)) {
                String[] nv = s.split(SYS_PROP_REGEX);
                System.setProperty(nv[0].substring(2), nv[1]);
                continue;
            }
            npReason = npReason + "Setting of: " + s + " can not take effect without server restart, ";
        }
        if (npReason.length() != 0) {
            return new NotProcessed(npReason);
        }
        return null;
    }

    private boolean possiblyDynamicallyReconfigurable(String s) {
        return s.startsWith("-D") && !s.startsWith("-Djava.") && !s.startsWith("-Djavax.");
    }
}

