/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.remote;

import com.sun.appserv.management.client.prefs.LoginInfo;
import com.sun.appserv.management.client.prefs.LoginInfoStore;
import com.sun.appserv.management.client.prefs.LoginInfoStoreFactory;
import com.sun.appserv.management.client.prefs.StoreException;
import com.sun.enterprise.admin.cli.remote.CLIRemoteCommand;
import com.sun.enterprise.admin.cli.remote.CommandInvoker;
import com.sun.enterprise.admin.cli.remote.ExceptionAnalyzer;
import com.sun.enterprise.admin.cli.remote.Log;
import com.sun.enterprise.admin.cli.remote.Parser;
import com.sun.enterprise.admin.cli.remote.RemoteException;
import com.sun.enterprise.admin.cli.remote.RemoteResponseManager;
import com.sun.enterprise.admin.cli.remote.RemoteSuccessException;
import com.sun.enterprise.admin.cli.util.AuthenticationInfo;
import com.sun.enterprise.admin.cli.util.CLIUtil;
import com.sun.enterprise.admin.cli.util.HttpConnectorAddress;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CliUtil;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.InputsAndOutputs;
import com.sun.enterprise.cli.framework.InvalidCommandException;
import com.sun.enterprise.cli.framework.LocalStringsManager;
import com.sun.enterprise.cli.framework.LocalStringsManagerFactory;
import com.sun.enterprise.cli.framework.ValidOption;
import com.sun.enterprise.universal.GFBase64Encoder;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.FileUtils;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.net.NetUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.glassfish.admin.payload.PayloadFilesManager;
import org.glassfish.admin.payload.PayloadImpl;
import org.glassfish.api.admin.Payload;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NCLIRemoteCommand {
    public static final String RELIABLE_COMMAND = "version";
    private static final LocalStringsImpl strings = new LocalStringsImpl(CLIRemoteCommand.class);
    private static final CLILogger logger = CLILogger.getInstance();
    private static final Set<ValidOption> known;
    private static final Set<String> unsupported;
    private static final String QUERY_STRING_INTRODUCER = "?";
    private static final String QUERY_STRING_SEPARATOR = "&";
    private static final String ADMIN_URI_PATH = "/__asadmin/";
    private static final String COMMAND_NAME_REGEXP = "^[a-zA-Z][-a-zA-Z0-9_]*$";
    private static final String UNSUPPORTED_CMD_FILE_NAME = "unsupported-legacy-command-names";
    private Map<String, String> mainAtts;
    private Map<String, String> params;
    private List<String> operands;
    private String commandName;
    private Set<ValidOption> commandOpts;
    private String operandType;
    private int operandMin;
    private int operandMax;
    private String responseFormatType = "hk2-agent";
    private OutputStream userOut;
    private boolean doUpload = false;
    private Map<String, String> encodedPasswords;
    private Payload.Outbound outboundPayload;
    private String hostName;
    private int hostPort;
    private boolean secure;
    private String user;
    private String password;
    private boolean verbose = false;
    private boolean terse = false;
    private boolean echo = false;
    private boolean interactive = false;
    private boolean help = false;
    private static final String FILE_PAYLOAD_MIME_TYPE = "application/octet-stream";

    private static void addMetaOption(Set<ValidOption> opts, String name, char sname, String type, boolean req, String def) {
        ValidOption opt = new ValidOption(name, type, req ? 1 : 2, def);
        String abbr = Character.toString(sname);
        opt.setShortName(abbr);
        opts.add(opt);
    }

    public NCLIRemoteCommand() {
    }

    public NCLIRemoteCommand(String ... args) throws CommandException {
        this.initialize(args);
        logger.printDebugMessage("Using new CLIRemoteCommand");
    }

    public NCLIRemoteCommand(String[] args, String responseFormatType, OutputStream userOut) throws CommandException {
        this.initialize(args);
        this.responseFormatType = responseFormatType;
        this.userOut = userOut;
    }

    public void parse(String ... args) throws CommandException {
        this.initialize(args);
    }

    public void runCommand() throws CommandException {
        if (this.commandName == null) {
            throw new CommandException("No Command");
        }
        try {
            this.initializeDoUpload();
            if (this.doUpload) {
                this.outboundPayload = PayloadImpl.Outbound.newInstance();
            }
            StringBuilder uriString = new StringBuilder(ADMIN_URI_PATH).append(this.commandName).append(QUERY_STRING_INTRODUCER);
            for (Map.Entry<String, String> param : this.params.entrySet()) {
                String paramName = param.getKey();
                String paramValue = param.getValue();
                ValidOption opt = this.getOption(paramName);
                if (opt == null) {
                    String msg = strings.get("unknownOption", new Object[]{this.commandName, paramName});
                    throw new CommandException(msg);
                }
                if (opt.getType().equals("FILE")) {
                    this.addFileOption(uriString, paramName, paramValue);
                }
                NCLIRemoteCommand.addOption(uriString, paramName, paramValue);
            }
            if (this.encodedPasswords != null) {
                for (Map.Entry<String, String> entry : this.encodedPasswords.entrySet()) {
                    NCLIRemoteCommand.addOption(uriString, entry.getKey(), entry.getValue());
                }
            }
            if (this.commandName.equalsIgnoreCase("change-admin-password")) {
                NCLIRemoteCommand.addOption(uriString, "username", this.user);
            }
            for (String operand : this.operands) {
                if (this.operandType.equals("FILE")) {
                    this.addFileOption(uriString, "DEFAULT", operand);
                    continue;
                }
                NCLIRemoteCommand.addOption(uriString, "DEFAULT", operand);
            }
            uriString.setLength(uriString.length() - 1);
            this.doHttpCommand(uriString.toString(), this.chooseRequestMethod(), new HttpCommand(){

                public void doCommand(HttpURLConnection urlConnection) throws CommandException, IOException {
                    if (NCLIRemoteCommand.this.doUpload) {
                        urlConnection.setChunkedStreamingMode(0);
                        urlConnection.setRequestProperty("Content-Type", NCLIRemoteCommand.this.outboundPayload.getContentType());
                    }
                    urlConnection.connect();
                    if (NCLIRemoteCommand.this.doUpload) {
                        NCLIRemoteCommand.this.outboundPayload.writeTo(urlConnection.getOutputStream());
                        NCLIRemoteCommand.this.outboundPayload = null;
                    }
                    InputStream in = urlConnection.getInputStream();
                    String responseContentType = urlConnection.getContentType();
                    PayloadImpl.Inbound inboundPayload = PayloadImpl.Inbound.newInstance((String)responseContentType, (InputStream)in);
                    boolean isReportProcessed = false;
                    PayloadFilesManager.Perm downloadedFilesMgr = new PayloadFilesManager.Perm();
                    Iterator partIt = inboundPayload.parts();
                    while (partIt.hasNext()) {
                        if (!isReportProcessed) {
                            NCLIRemoteCommand.this.handleResponse(NCLIRemoteCommand.this.params, ((Payload.Part)partIt.next()).getInputStream(), urlConnection.getResponseCode(), NCLIRemoteCommand.this.userOut);
                            isReportProcessed = true;
                            continue;
                        }
                        NCLIRemoteCommand.this.processDataPart((PayloadFilesManager)downloadedFilesMgr, (Payload.Part)partIt.next());
                    }
                }
            });
        }
        catch (IOException ioex) {
            throw new CommandException("I/O Error", ioex);
        }
    }

    private void doHttpCommand(String uriString, String httpMethod, HttpCommand cmd) throws CommandException {
        HttpURLConnection urlConnection = null;
        try {
            HttpConnectorAddress url = new HttpConnectorAddress(this.hostName, this.hostPort, this.secure);
            logger.printDebugMessage("URI: " + uriString.toString());
            logger.printDebugMessage("URL: " + url.toString());
            logger.printDebugMessage("URL: " + url.toURL(uriString.toString()).toString());
            url.setAuthenticationInfo(new AuthenticationInfo(this.user, this.password));
            urlConnection = (HttpURLConnection)url.openConnection(uriString.toString());
            urlConnection.setRequestProperty("User-Agent", this.responseFormatType);
            urlConnection.setRequestProperty("Authorization", url.getBasicAuthString());
            urlConnection.setRequestMethod(httpMethod);
            cmd.doCommand(urlConnection);
        }
        catch (ConnectException ce) {
            String msg = strings.get("ConnectException", new Object[]{this.hostName, this.hostPort + ""});
            throw new CommandException(msg, ce);
        }
        catch (SocketException se) {
            try {
                boolean serverAppearsSecure = NetUtils.isSecurePort((String)this.hostName, (int)this.hostPort);
                if (serverAppearsSecure != this.secure) {
                    String msg = strings.get("ServerMaybeSecure", new Object[]{this.hostName, this.hostPort + ""});
                    logger.printError(msg);
                    throw new CommandException(se);
                }
            }
            catch (IOException io) {
                logger.printExceptionStackTrace(io);
                throw new CommandException(io);
            }
        }
        catch (IOException e) {
            String msg = "Unknown I/O Error";
            if (urlConnection != null) {
                try {
                    int rc = urlConnection.getResponseCode();
                    msg = 401 == rc ? strings.get("InvalidCredentials", new Object[]{this.user}) : "Status: " + rc;
                }
                catch (IOException ioex) {
                    // empty catch block
                }
            }
            throw new CommandException(msg, e);
        }
        catch (Exception e) {
            logger.printExceptionStackTrace(e);
            throw new CommandException(e);
        }
    }

    public String getCommandName() {
        return this.commandName;
    }

    private void processDataPart(PayloadFilesManager downloadedFilesMgr, Payload.Part part) throws IOException {
        Properties partProps = part.getProperties();
        String dataRequestType = partProps.getProperty("data-request-type");
        if (dataRequestType.equals("file-xfer")) {
            downloadedFilesMgr.extractFile(part);
        }
    }

    private static StringBuilder addOption(StringBuilder uriString, String name, String option) {
        try {
            String encodedOption = URLEncoder.encode(option, "UTF-8");
            uriString.append(name).append('=').append(encodedOption).append(QUERY_STRING_SEPARATOR);
        }
        catch (UnsupportedEncodingException e) {
            logger.printError("Error encoding value for: " + name + ", Value:" + option + ", parameter value will be ignored");
        }
        return uriString;
    }

    private StringBuilder addFileOption(StringBuilder uriString, String optionName, String filename) throws IOException {
        File f = SmartFile.sanitize((File)new File(filename));
        logger.printDebugMessage("FILE PARAM: " + optionName + " = " + f);
        if (this.doUpload) {
            this.outboundPayload.attachFile(FILE_PAYLOAD_MIME_TYPE, f.toURI(), optionName, null, f);
        }
        if (f != null) {
            String pathToPass = this.doUpload ? f.getName() : f.getPath();
            NCLIRemoteCommand.addOption(uriString, optionName, pathToPass);
        }
        return uriString;
    }

    private String chooseRequestMethod() {
        if (this.doUpload) {
            return "POST";
        }
        return "GET";
    }

    private void handleResponse(Map<String, String> params, InputStream in, int code, OutputStream userOut) throws IOException, CommandException {
        if (userOut == null) {
            this.handleResponse(params, in, code);
        } else {
            FileUtils.copyStream((InputStream)in, (OutputStream)userOut);
        }
    }

    private void handleResponse(Map<String, String> params, InputStream in, int code) throws IOException, CommandException {
        RemoteResponseManager rrm = null;
        try {
            rrm = new RemoteResponseManager(in, code);
            rrm.process();
        }
        catch (RemoteSuccessException rse) {
            if (rrm != null) {
                this.mainAtts = rrm.getMainAtts();
            }
            Log.info(rse.getMessage(), new Object[0]);
            return;
        }
        catch (RemoteException rfe) {
            if (rfe.getRemoteCause().indexOf("CommandNotFoundException") > 0) {
                throw new CommandException(rfe.getMessage(), new InvalidCommandException());
            }
            throw new CommandException("remote failure: " + rfe.getMessage(), rfe);
        }
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0 && !s.equals("null");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("--echo=").append(Boolean.toString(this.echo)).append(' ');
        sb.append("--terse=").append(Boolean.toString(this.terse)).append(' ');
        sb.append(this.commandName).append(' ');
        Set<String> paramKeys = this.params.keySet();
        for (String key : paramKeys) {
            String value = this.params.get(key);
            sb.append("--").append(key);
            if (NCLIRemoteCommand.ok(value)) {
                sb.append('=').append(value);
            }
            sb.append(' ');
        }
        for (String o : this.operands) {
            sb.append((Object)o).append(' ');
        }
        return sb.toString();
    }

    public Map<String, String> getMainAtts() {
        return this.mainAtts;
    }

    public static boolean pingDAS(CommandInvoker invoker) {
        try {
            invoker.invoke();
            return true;
        }
        catch (Exception ex) {
            ExceptionAnalyzer ea = new ExceptionAnalyzer(ex);
            if (ea.getFirstInstanceOf(ConnectException.class) != null) {
                CLILogger.getInstance().printDebugMessage("Got java.net.ConnectException");
                return false;
            }
            if (ea.getFirstInstanceOf(IOException.class) != null) {
                CLILogger.getInstance().printDebugMessage("It appears that server has started, but for some reason the exception is thrown: " + ex.getMessage());
                return true;
            }
            return false;
        }
    }

    public static boolean pingDASWithAuth(CommandInvoker invoker) {
        try {
            invoker.invoke();
            return true;
        }
        catch (Exception ex) {
            ExceptionAnalyzer ea = new ExceptionAnalyzer(ex);
            if (ea.getFirstInstanceOf(ConnectException.class) != null) {
                CLILogger.getInstance().printDebugMessage("Got java.net.ConnectException");
                return false;
            }
            if (ea.getFirstInstanceOf(IOException.class) != null) {
                CLILogger.getInstance().printDebugMessage("Auth info is incorrect" + ex.getMessage());
                return false;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean pingDASQuietly(CommandInvoker invoker) {
        try {
            CLILogger.getInstance().pushAndLockLevel(Level.WARNING);
            boolean bl = NCLIRemoteCommand.pingDAS(invoker);
            return bl;
        }
        finally {
            CLILogger.getInstance().popAndUnlockLevel();
        }
    }

    private void fetchCommandMetadata(String cmdName) throws CommandException {
        StringBuilder uriString = new StringBuilder(ADMIN_URI_PATH).append(cmdName).append(QUERY_STRING_INTRODUCER);
        NCLIRemoteCommand.addOption(uriString, "Xhelp", "true");
        uriString.setLength(uriString.length() - 1);
        this.doHttpCommand(uriString.toString(), "GET", new HttpCommand(){

            public void doCommand(HttpURLConnection urlConnection) throws CommandException, IOException {
                urlConnection.setRequestProperty("User-Agent", "metadata");
                urlConnection.connect();
                InputStream in = urlConnection.getInputStream();
                String responseContentType = urlConnection.getContentType();
                PayloadImpl.Inbound inboundPayload = PayloadImpl.Inbound.newInstance((String)responseContentType, (InputStream)in);
                boolean isReportProcessed = false;
                Iterator partIt = inboundPayload.parts();
                while (partIt.hasNext()) {
                    if (!isReportProcessed) {
                        NCLIRemoteCommand.this.commandOpts = NCLIRemoteCommand.this.parseMetadata(((Payload.Part)partIt.next()).getInputStream());
                        isReportProcessed = true;
                        continue;
                    }
                    partIt.next();
                }
            }
        });
    }

    private Set<ValidOption> parseMetadata(InputStream in) {
        HashSet<ValidOption> valid = new HashSet<ValidOption>();
        boolean sawFile = false;
        try {
            NamedNodeMap attrs;
            Node n;
            int i;
            DocumentBuilder d = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = d.parse(in);
            NodeList opts = doc.getElementsByTagName("option");
            for (i = 0; i < opts.getLength(); ++i) {
                n = opts.item(i);
                attrs = n.getAttributes();
                ValidOption opt = new ValidOption(NCLIRemoteCommand.getAttr(attrs, "name"), NCLIRemoteCommand.getAttr(attrs, "type"), Boolean.parseBoolean(NCLIRemoteCommand.getAttr(attrs, "optional")) ? 2 : 1, NCLIRemoteCommand.getAttr(attrs, "default"));
                opt.setShortName(NCLIRemoteCommand.getAttr(attrs, "short"));
                valid.add(opt);
                if (!opt.getType().equals("FILE")) continue;
                sawFile = true;
            }
            opts = doc.getElementsByTagName("operand");
            for (i = 0; i < opts.getLength(); ++i) {
                n = opts.item(i);
                attrs = n.getAttributes();
                this.operandType = NCLIRemoteCommand.getAttr(attrs, "type");
                this.operandMin = Integer.parseInt(NCLIRemoteCommand.getAttr(attrs, "min"));
                String max = NCLIRemoteCommand.getAttr(attrs, "max");
                this.operandMax = max.equals("unlimited") ? Integer.MAX_VALUE : Integer.parseInt(max);
                if (!this.operandType.equals("FILE")) continue;
                sawFile = true;
            }
            if (sawFile) {
                valid.add(new ValidOption("upload", "BOOLEAN", 2, "false"));
            }
        }
        catch (ParserConfigurationException pex) {
            return null;
        }
        catch (SAXException sex) {
            return null;
        }
        catch (IOException ex) {
            return null;
        }
        return valid;
    }

    private static String getAttr(NamedNodeMap attrs, String name) {
        Node n = attrs.getNamedItem(name);
        if (n != null) {
            return n.getNodeValue();
        }
        return null;
    }

    private void initialize(String[] argv) throws CommandException {
        try {
            int cmdArgsStart;
            Parser rcp;
            if (argv.length == 0) {
                throw new CommandException("No Command");
            }
            if (argv[0].startsWith("-")) {
                rcp = new Parser(argv, 0, known, false);
                this.params = rcp.getOptions();
                this.operands = rcp.getOperands();
                if (this.operands.size() == 0) {
                    throw new CommandException("No Command");
                }
                this.commandName = this.operands.get(0);
                cmdArgsStart = 1;
            } else {
                this.commandName = argv[0];
                rcp = new Parser(argv, 1, known, true);
                this.params = rcp.getOptions();
                this.operands = rcp.getOperands();
                cmdArgsStart = 0;
                if (this.params.size() > 0) {
                    Set<String> names = this.params.keySet();
                    Object[] na = names.toArray(new String[names.size()]);
                    System.out.println("Deprecated syntax: " + this.commandName + ", Options: " + Arrays.toString(na));
                }
            }
            if (!this.commandName.matches(COMMAND_NAME_REGEXP)) {
                throw new CommandException("Illegal command name: " + this.commandName);
            }
            NCLIRemoteCommand.checkUnsupportedLegacyCommand(this.commandName);
            this.initializeStandardParams();
            this.initializeLogger();
            logger.printDebugMessage("CLIRemoteCommandParser: " + rcp);
            this.initializeAuth();
            if (this.help) {
                this.commandOpts = new HashSet<ValidOption>();
                NCLIRemoteCommand.addMetaOption(this.commandOpts, "help", '?', "BOOLEAN", false, "false");
                this.params = new HashMap<String, String>();
                this.params.put("help", "true");
                this.operands = Collections.emptyList();
                return;
            }
            this.fetchCommandMetadata(this.commandName);
            if (this.commandOpts == null) {
                throw new CommandException("Unknown command: " + this.commandName);
            }
            String[] cmdArgs = this.operands.toArray(new String[this.operands.size()]);
            rcp = new Parser(cmdArgs, cmdArgsStart, this.commandOpts, false);
            this.params = rcp.getOptions();
            this.operands = rcp.getOperands();
            logger.printDebugMessage("params: " + this.params);
            logger.printDebugMessage("operands: " + this.operands);
            if (this.operands.size() < this.operandMin) {
                throw new CommandException(strings.get("notEnoughOperands", new Object[]{this.commandName}));
            }
            if (this.operands.size() > this.operandMax) {
                throw new CommandException(strings.get("tooManyOperands", new Object[]{this.commandName}));
            }
            boolean missingOption = false;
            for (ValidOption opt : this.commandOpts) {
                if (opt.isValueRequired() != 1 || opt.getType().equals("PASSWORD") || this.params.get(opt.getName()) != null) continue;
                missingOption = true;
                System.out.println(strings.get("missingOption", new Object[]{"--" + opt.getName()}));
            }
            if (missingOption) {
                throw new CommandException(strings.get("missingOptions", new Object[]{this.commandName}));
            }
            this.initializeCommandPassword();
        }
        catch (CommandException cex) {
            throw cex;
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage());
        }
    }

    private void initializeStandardParams() throws CommandException {
        String s;
        String value;
        if (this.params.containsKey("verbose")) {
            value = this.params.get("verbose");
            this.verbose = NCLIRemoteCommand.ok(value) ? Boolean.parseBoolean(this.params.get("verbose")) : true;
        }
        if (this.params.containsKey("echo")) {
            value = this.params.get("echo");
            this.echo = NCLIRemoteCommand.ok(value) ? Boolean.parseBoolean(this.params.get("echo")) : true;
        }
        if (this.params.containsKey("terse")) {
            value = this.params.get("terse");
            this.terse = NCLIRemoteCommand.ok(value) ? Boolean.parseBoolean(this.params.get("terse")) : true;
        }
        this.interactive = this.params.containsKey("interactive") ? (NCLIRemoteCommand.ok(value = this.params.get("interactive")) ? Boolean.parseBoolean(this.params.get("interactive")) : true) : true;
        if (this.params.containsKey("help")) {
            this.help = true;
        }
        this.hostName = this.params.get("host");
        if (this.hostName == null || this.hostName.length() == 0) {
            this.hostName = "localhost";
        }
        logger.printDebugMessage("host = " + this.hostName);
        String port = this.params.get("port");
        if (NCLIRemoteCommand.ok(port)) {
            String badPortMsg = strings.get("badport", new Object[]{port});
            try {
                this.hostPort = Integer.parseInt(port);
                if (this.hostPort < 1 || this.hostPort > 65535) {
                    throw new CommandException(badPortMsg);
                }
            }
            catch (NumberFormatException e) {
                throw new CommandException(badPortMsg);
            }
        }
        if (!NCLIRemoteCommand.ok(port)) {
            this.hostPort = 4848;
        }
        this.secure = NCLIRemoteCommand.ok(s = this.params.get("secure")) ? Boolean.parseBoolean(s) : false;
    }

    private void initializeLogger() {
        if (this.terse) {
            logger.setOutputLevel(Level.INFO);
        } else {
            logger.setOutputLevel(Level.FINE);
        }
        if (this.echo) {
            logger.printMessage(this.toString());
        } else if (logger.isDebug()) {
            logger.printDebugMessage(this.toString());
        }
    }

    private void initializeDoUpload() {
        boolean sawFile = false;
        boolean sawDirectory = false;
        for (Map.Entry<String, String> param : this.params.entrySet()) {
            String paramName = param.getKey();
            ValidOption opt = this.getOption(paramName);
            if (opt == null || !opt.getType().equals("FILE")) continue;
            sawFile = true;
            String filename = param.getValue();
            File file = new File(filename);
            if (!file.isDirectory()) continue;
            sawDirectory = true;
        }
        if (sawFile && !sawDirectory) {
            String upString = this.params.get("upload");
            this.doUpload = NCLIRemoteCommand.ok(upString) ? Boolean.parseBoolean(upString) : true;
            if (upString != null) {
                this.params.remove("upload");
            }
        }
    }

    private ValidOption getOption(String name) {
        for (ValidOption opt : this.commandOpts) {
            if (!opt.getName().equals(name)) continue;
            return opt;
        }
        return null;
    }

    private void initializeAuth() throws CommandException {
        LoginInfo li = null;
        try {
            LoginInfoStore store = LoginInfoStoreFactory.getDefaultStore();
            li = store.read(this.hostName, this.hostPort);
        }
        catch (StoreException se) {
            logger.printDebugMessage("Login info could not be read from ~/.asadminpass file");
        }
        this.initializeUser(li);
        this.initializePassword(li);
    }

    private void initializeUser(LoginInfo li) {
        this.user = this.params.get("user");
        if (this.user == null && li != null) {
            this.user = li.getUser();
        }
    }

    private void initializePassword(LoginInfo li) throws CommandException {
        String pwfile;
        this.encodedPasswords = new HashMap<String, String>();
        if (this.params.get("password") != null) {
            this.password = this.params.get("password");
            this.params.remove("password");
            this.encodedPasswords.put("AS_ADMIN_PASSWORD", this.password);
            NCLIRemoteCommand.base64encode(this.encodedPasswords);
        }
        if (NCLIRemoteCommand.ok(pwfile = this.params.get("passwordfile"))) {
            this.encodedPasswords = CLIUtil.readPasswordFileOptions(pwfile, true);
            this.password = this.encodedPasswords.get("AS_ADMIN_PASSWORD");
            NCLIRemoteCommand.base64encode(this.encodedPasswords);
        }
        if (!NCLIRemoteCommand.ok(this.password) && li != null) {
            this.password = li.getPassword();
        }
    }

    private void initializeCommandPassword() throws CommandException {
        if (this.commandName.equalsIgnoreCase("change-admin-password")) {
            try {
                this.password = this.getInteractiveOptionWithConfirmation(this.encodedPasswords);
                NCLIRemoteCommand.base64encode(this.encodedPasswords);
                return;
            }
            catch (CommandValidationException cve) {
                throw new CommandException(cve);
            }
        }
        if (this.commandName.equalsIgnoreCase("create-password-alias") || this.commandName.equalsIgnoreCase("update-password-alias")) {
            try {
                this.password = this.confirmInteractivelyAliasPassword(this.encodedPasswords);
                NCLIRemoteCommand.base64encode(this.encodedPasswords);
            }
            catch (CommandValidationException cve) {
                throw new CommandException(cve);
            }
        }
        for (ValidOption opt : this.commandOpts) {
            String pwdname;
            if (!opt.getType().equals("PASSWORD")) continue;
            if (this.encodedPasswords == null) {
                this.encodedPasswords = new HashMap<String, String>();
            }
            if (NCLIRemoteCommand.ok(this.encodedPasswords.get(pwdname = opt.getName())) || opt.isValueRequired() != 1) continue;
            try {
                String pwd = this.getPassword(opt.getName());
                if (pwd == null) {
                    throw new CommandException(strings.get("missingPassword", new Object[]{this.commandName, pwdname}));
                }
                pwd = new GFBase64Encoder().encode(pwd.getBytes());
                this.encodedPasswords.put(pwdname, pwd);
            }
            catch (CommandValidationException cve) {
                throw new CommandException(cve);
            }
        }
    }

    private String confirmInteractivelyAliasPassword(Map<String, String> encodedPasswords) throws CommandValidationException {
        String prompt = this.getLocalizedString("AliasPasswordPrompt");
        String confirmationPrompt = this.getLocalizedString("AliasPasswordConfirmationPrompt");
        String aliasPassword = this.getInteractiveOption(prompt);
        encodedPasswords.put("AS_ADMIN_ALIASPASSWORD", aliasPassword);
        String aliasPasswordAgain = this.getInteractiveOption(confirmationPrompt);
        if (!aliasPassword.equals(aliasPasswordAgain)) {
            throw new CommandValidationException(this.getLocalizedString("OptionsDoNotMatch", new Object[]{"Admin Password"}));
        }
        return aliasPassword;
    }

    private String getPassword(String passwordName) throws CommandValidationException {
        if (!this.interactive) {
            return null;
        }
        String newprompt = this.getLocalizedString("AdminNewPasswordPrompt");
        String confirmationPrompt = this.getLocalizedString("AdminNewPasswordConfirmationPrompt");
        String newpassword = this.getInteractiveOption(newprompt);
        if (!this.isPasswordValid(newpassword)) {
            throw new CommandValidationException(this.getLocalizedString("PasswordLimit", new Object[]{"Admin"}));
        }
        String newpasswordAgain = this.getInteractiveOption(confirmationPrompt);
        if (!newpassword.equals(newpasswordAgain)) {
            throw new CommandValidationException(this.getLocalizedString("OptionsDoNotMatch", new Object[]{"Admin Password"}));
        }
        return newpassword;
    }

    private String getInteractiveOptionWithConfirmation(Map<String, String> encodedPasswords) throws CommandValidationException {
        String prompt = this.getLocalizedString("AdminPasswordPrompt");
        String newprompt = this.getLocalizedString("AdminNewPasswordPrompt");
        String confirmationPrompt = this.getLocalizedString("AdminNewPasswordConfirmationPrompt");
        String oldpassword = this.getInteractiveOption(prompt);
        if (!this.isPasswordValid(oldpassword)) {
            throw new CommandValidationException(this.getLocalizedString("PasswordLimit", new Object[]{"Admin"}));
        }
        encodedPasswords.put("AS_ADMIN_PASSWORD", oldpassword);
        String newpassword = this.getInteractiveOption(newprompt);
        if (!this.isPasswordValid(newpassword)) {
            throw new CommandValidationException(this.getLocalizedString("PasswordLimit", new Object[]{"Admin"}));
        }
        encodedPasswords.put("AS_ADMIN_NEWPASSWORD", newpassword);
        String newpasswordAgain = this.getInteractiveOption(confirmationPrompt);
        if (!newpassword.equals(newpasswordAgain)) {
            throw new CommandValidationException(this.getLocalizedString("OptionsDoNotMatch", new Object[]{"Admin Password"}));
        }
        return oldpassword;
    }

    protected String getInteractiveOption(String prompt) throws CommandValidationException {
        String optionValue;
        try {
            InputsAndOutputs.getInstance().getUserOutput().print(prompt);
            InputsAndOutputs.getInstance().getUserOutput().flush();
            optionValue = new CliUtil().getPassword();
        }
        catch (NoClassDefFoundError e) {
            optionValue = this.readInput();
        }
        catch (UnsatisfiedLinkError e) {
            optionValue = this.readInput();
        }
        catch (Exception e) {
            throw new CommandValidationException(e);
        }
        return optionValue;
    }

    private String readInput() {
        try {
            return InputsAndOutputs.getInstance().getUserInput().getLine();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    protected boolean isPasswordValid(String passwd) {
        return passwd.length() >= 8;
    }

    private String getLocalizedString(String key) {
        LocalStringsManager lsm = null;
        try {
            lsm = LocalStringsManagerFactory.getCommandLocalStringsManager();
        }
        catch (CommandValidationException cve) {
            return "Key not found";
        }
        return lsm.getString(key);
    }

    private String getLocalizedString(String key, Object[] toInsert) {
        LocalStringsManager lsm = null;
        try {
            lsm = LocalStringsManagerFactory.getCommandLocalStringsManager();
            return lsm.getString(key, toInsert);
        }
        catch (CommandValidationException cve) {
            return "Key not found";
        }
    }

    private static void base64encode(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        GFBase64Encoder encoder = new GFBase64Encoder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String val = entry.getValue();
            if (val == null) continue;
            entry.setValue(encoder.encode(val.getBytes()));
        }
    }

    private static void checkUnsupportedLegacyCommand(String cmd) throws CommandException {
        for (String c : unsupported) {
            if (!c.equals(cmd)) continue;
            throw new CommandException("Previously supported command: " + cmd + " is not supported for this release.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void file2Set(String file, Set<String> set) {
        BufferedReader reader = null;
        try {
            String line;
            InputStream is = CLIRemoteCommand.class.getClassLoader().getResourceAsStream(file);
            if (is == null) {
                return;
            }
            reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                StringTokenizer tok = new StringTokenizer(line, " ");
                String cmd = tok.nextToken();
                set.add(cmd);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static {
        HashSet<ValidOption> opts = new HashSet<ValidOption>();
        NCLIRemoteCommand.addMetaOption(opts, "host", 'H', "STRING", false, "localhost");
        NCLIRemoteCommand.addMetaOption(opts, "port", 'p', "STRING", false, "4848");
        NCLIRemoteCommand.addMetaOption(opts, "user", 'u', "STRING", false, "anonymous");
        NCLIRemoteCommand.addMetaOption(opts, "password", 'w', "STRING", false, null);
        NCLIRemoteCommand.addMetaOption(opts, "passwordfile", 'W', "FILE", false, null);
        NCLIRemoteCommand.addMetaOption(opts, "secure", 's', "BOOLEAN", false, "false");
        NCLIRemoteCommand.addMetaOption(opts, "terse", 't', "BOOLEAN", false, "false");
        NCLIRemoteCommand.addMetaOption(opts, "echo", 'e', "BOOLEAN", false, "false");
        NCLIRemoteCommand.addMetaOption(opts, "interactive", 'I', "BOOLEAN", false, "false");
        NCLIRemoteCommand.addMetaOption(opts, "help", '?', "BOOLEAN", false, "false");
        known = Collections.unmodifiableSet(opts);
        HashSet<String> unsup = new HashSet<String>();
        NCLIRemoteCommand.file2Set(UNSUPPORTED_CMD_FILE_NAME, unsup);
        unsupported = Collections.unmodifiableSet(unsup);
    }

    static interface HttpCommand {
        public void doCommand(HttpURLConnection var1) throws CommandException, IOException;
    }
}

