/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Environment {
    public static final String AS_ADMIN_ENV_PREFIX = "AS_ADMIN_";
    private Map<String, String> env = new HashMap<String, String>();

    public Environment() {
        for (Map.Entry<String, String> e : System.getenv().entrySet()) {
            if (!e.getKey().startsWith(AS_ADMIN_ENV_PREFIX)) continue;
            this.env.put(e.getKey(), e.getValue());
        }
    }

    public boolean getBooleanOption(String name) {
        return Boolean.parseBoolean(this.env.get(this.optionToEnv(name)));
    }

    public String getStringOption(String name) {
        return this.env.get(this.optionToEnv(name));
    }

    public boolean hasOption(String name) {
        return this.env.containsKey(this.optionToEnv(name));
    }

    public String get(String name) {
        return this.env.get(name);
    }

    public String put(String name, String value) {
        return this.env.put(name, value);
    }

    public String putOption(String name, String value) {
        return this.env.put(this.optionToEnv(name), value);
    }

    private String optionToEnv(String name) {
        return AS_ADMIN_ENV_PREFIX + name.replace('-', '_').toUpperCase(Locale.ENGLISH);
    }
}

