/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.amx;

import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.glassfish.api.amx.AMXValues;
import org.glassfish.api.amx.BootAMXMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanListener<T extends Callback>
implements NotificationListener {
    private final String mType;
    private final String mName;
    private final ObjectName mObjectName;
    private final MBeanServerConnection mMBeanServer;
    private final T mCallback;

    private static void debug(Object o) {
        System.out.println("" + o);
    }

    public String toString() {
        return "MBeanListener: ObjectName=" + this.mObjectName + ", type=" + this.mType + ", name=" + this.mName;
    }

    public String getType() {
        return this.mType;
    }

    public String getName() {
        return this.mName;
    }

    public MBeanServerConnection getMBeanServer() {
        return this.mMBeanServer;
    }

    public T getCallback() {
        return this.mCallback;
    }

    public MBeanListener(MBeanServerConnection server, ObjectName objectName, T callback) {
        this.mMBeanServer = server;
        this.mObjectName = objectName;
        this.mType = null;
        this.mName = null;
        this.mCallback = callback;
    }

    public MBeanListener(MBeanServerConnection server, String type, T callback) {
        this(server, type, null, callback);
    }

    public MBeanListener(MBeanServerConnection server, String type, String name, T callback) {
        this.mMBeanServer = server;
        this.mType = type;
        this.mName = name;
        this.mObjectName = null;
        this.mCallback = callback;
    }

    public static <T extends Callback> MBeanListener<T> listenForDomainRoot(MBeanServerConnection server, T callback) {
        MBeanListener<T> listener = new MBeanListener<T>(server, AMXValues.domainRoot(), callback);
        listener.startListening();
        return listener;
    }

    public static void waitAMXReady(MBeanServerConnection server) {
        MBeanListener.listenForDomainRoot(server, new WaitForDomainRootListener(server));
    }

    public static <T extends Callback> MBeanListener<T> listenForBootAMX(MBeanServerConnection server, T callback) {
        MBeanListener<T> listener = new MBeanListener<T>(server, BootAMXMBean.OBJECT_NAME, callback);
        listener.startListening();
        return listener;
    }

    private boolean isRegistered(MBeanServerConnection conn, ObjectName objectName) {
        try {
            return conn.isRegistered(objectName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void startListening() {
        try {
            this.mMBeanServer.addNotificationListener(AMXValues.getMBeanServerDelegateObjectName(), this, null, (Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't add NotificationListener", e);
        }
        if (this.mObjectName != null) {
            if (this.isRegistered(this.mMBeanServer, this.mObjectName)) {
                this.mCallback.mbeanRegistered(this.mObjectName, this);
            }
        } else {
            String props = "type=" + this.mType;
            if (this.mName != null) {
                props = props + "," + "name" + this.mName;
            }
            ObjectName pattern = AMXValues.newObjectName(AMXValues.amxJMXDomain(), props);
            try {
                Set<ObjectName> matched = this.mMBeanServer.queryNames(pattern, null);
                for (ObjectName objectName : matched) {
                    this.mCallback.mbeanRegistered(objectName, this);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void stopListening() {
        try {
            this.mMBeanServer.removeNotificationListener(AMXValues.getMBeanServerDelegateObjectName(), this);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't remove NotificationListener " + this, e);
        }
    }

    @Override
    public void handleNotification(Notification notifIn, Object handback) {
        if (notifIn instanceof MBeanServerNotification) {
            MBeanServerNotification notif = (MBeanServerNotification)notifIn;
            ObjectName objectName = notif.getMBeanName();
            boolean match = false;
            if (this.mObjectName != null && this.mObjectName.equals(objectName)) {
                match = true;
            } else if (objectName.getDomain().equals(AMXValues.amxJMXDomain()) && this.mType != null && this.mType.equals(objectName.getKeyProperty("type"))) {
                String mbeanName = objectName.getKeyProperty("name");
                if (this.mName != null && this.mName.equals(mbeanName)) {
                    match = true;
                }
            }
            if (match) {
                String notifType = notif.getType();
                if ("JMX.mbean.registered".equals(notifType)) {
                    this.mCallback.mbeanRegistered(objectName, this);
                } else if ("JMX.mbean.unregistered".equals(notifType)) {
                    this.mCallback.mbeanUnregistered(objectName, this);
                }
            }
        }
    }

    private static final class WaitForDomainRootListener
    extends CallbackImpl {
        private final MBeanServerConnection mConn;

        public WaitForDomainRootListener(MBeanServerConnection conn) {
            this.mConn = conn;
        }

        public void mbeanRegistered(ObjectName objectName, MBeanListener listener) {
            super.mbeanRegistered(objectName, listener);
            try {
                this.mConn.invoke(AMXValues.domainRoot(), "waitAMXReady", null, null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class CallbackImpl
    implements Callback {
        private volatile ObjectName mRegistered = null;
        private volatile ObjectName mUnregistered = null;
        private final boolean mStopAtFirst;

        public CallbackImpl() {
            this(true);
        }

        public CallbackImpl(boolean stopAtFirst) {
            this.mStopAtFirst = stopAtFirst;
        }

        public ObjectName getRegistered() {
            return this.mRegistered;
        }

        public ObjectName getUnregistered() {
            return this.mUnregistered;
        }

        public void mbeanRegistered(ObjectName objectName, MBeanListener listener) {
            this.mRegistered = objectName;
            if (this.mStopAtFirst) {
                listener.stopListening();
            }
        }

        public void mbeanUnregistered(ObjectName objectName, MBeanListener listener) {
            this.mUnregistered = objectName;
            if (this.mStopAtFirst) {
                listener.stopListening();
            }
        }
    }

    public static interface Callback {
        public void mbeanRegistered(ObjectName var1, MBeanListener var2);

        public void mbeanUnregistered(ObjectName var1, MBeanListener var2);
    }
}

