/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.LbConfigs;
import com.sun.enterprise.config.serverbeans.LoadBalancers;
import com.sun.enterprise.config.serverbeans.NodeAgents;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.SystemApplications;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.SystemPropertyBag;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.api.admin.config.Property;
import org.glassfish.api.admin.config.PropertyBag;
import org.glassfish.api.admin.config.PropertyDesc;
import org.glassfish.quality.ToDo;
import org.jvnet.hk2.component.Injectable;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configured
public interface Domain
extends ConfigBeanProxy,
Injectable,
PropertyBag,
SystemPropertyBag {
    @Attribute
    public String getApplicationRoot();

    public void setApplicationRoot(String var1) throws PropertyVetoException;

    @Attribute
    public String getLogRoot();

    public void setLogRoot(String var1) throws PropertyVetoException;

    @Attribute
    public String getLocale();

    public void setLocale(String var1) throws PropertyVetoException;

    @Attribute
    public String getVersion();

    @Element
    public Applications getApplications();

    public void setApplications(Applications var1) throws PropertyVetoException;

    @Element
    public SystemApplications getSystemApplications();

    public void setSystemApplications(SystemApplications var1) throws PropertyVetoException;

    @Element
    public Resources getResources();

    public void setResources(Resources var1) throws PropertyVetoException;

    @Element(required=true)
    public Configs getConfigs();

    public void setConfigs(Configs var1) throws PropertyVetoException;

    @Element(required=true)
    public Servers getServers();

    public void setServers(Servers var1) throws PropertyVetoException;

    @Element
    public Clusters getClusters();

    public void setClusters(Clusters var1) throws PropertyVetoException;

    @Element
    public NodeAgents getNodeAgents();

    public void setNodeAgents(NodeAgents var1) throws PropertyVetoException;

    @Element
    public LbConfigs getLbConfigs();

    public void setLbConfigs(LbConfigs var1) throws PropertyVetoException;

    @Element
    public LoadBalancers getLoadBalancers();

    public void setLoadBalancers(LoadBalancers var1) throws PropertyVetoException;

    @Override
    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Any more legal system properties?")
    @PropertiesDesc(systemProperties=true, props={@PropertyDesc(name="com.sun.aas.installRoot", description="Operating system dependent. Path to the directory where the server is installed"), @PropertyDesc(name="com.sun.aas.instanceRoot", description="Operating system dependent. Path to the top level directory for a server instance"), @PropertyDesc(name="com.sun.aas.hostName", description="Operating system dependent. Path to the name of the host (machine)"), @PropertyDesc(name="com.sun.aas.javaRoot", description="Operating system dependent. Path to the library directory for the Sun GlassFish Message Queue software"), @PropertyDesc(name="com.sun.aas.imqLib", description="Operating system dependent. Path to the installation directory for the Java runtime"), @PropertyDesc(name="com.sun.aas.imqLib", description="Operating system dependent. Path to the installation directory for the Java runtime"), @PropertyDesc(name="com.sun.aas.configName", defaultValue="server-config", description="Name of the <config> used by a server instance"), @PropertyDesc(name="com.sun.aas.instanceName", defaultValue="server1", description="Name of the server instance. Not used in the default configuration, but can be used to customize configuration"), @PropertyDesc(name="com.sun.aas.domainName", defaultValue="domain1", description="Name of the domain. Not used in the default configuration, but can be used to customize configuration")})
    @Element
    public List<SystemProperty> getSystemProperty();

    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal props")
    @PropertiesDesc(props={})
    @Element
    public List<Property> getProperty();

    @DuckTyped
    public List<Application> getAllDefinedSystemApplications();

    @DuckTyped
    public ApplicationRef getApplicationRefInServer(String var1, String var2);

    @DuckTyped
    public List<Application> getSystemApplicationsReferencedFrom(String var1);

    @DuckTyped
    public Application getSystemApplicationReferencedFrom(String var1, String var2);

    @DuckTyped
    public boolean isNamedSystemApplicationReferencedFrom(String var1, String var2);

    @DuckTyped
    public Server getServerNamed(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Duck {
        public static List<Application> getAllDefinedSystemApplications(Domain me) {
            ArrayList<Application> allSysApps = new ArrayList<Application>();
            SystemApplications sa = me.getSystemApplications();
            if (sa != null) {
                for (Named m : sa.getModules()) {
                    if (!(m instanceof Application)) continue;
                    allSysApps.add((Application)m);
                }
            }
            return allSysApps;
        }

        public static ApplicationRef getApplicationRefInServer(Domain me, String sn, String name) {
            Servers ss = me.getServers();
            List<Server> list = ss.getServer();
            Server theServer = null;
            for (Server s : list) {
                if (!s.getName().equals(sn)) continue;
                theServer = s;
                break;
            }
            ApplicationRef aref = null;
            if (theServer != null) {
                List<ApplicationRef> arefs = theServer.getApplicationRef();
                for (ApplicationRef ar : arefs) {
                    if (!ar.getRef().equals(name)) continue;
                    aref = ar;
                    break;
                }
            }
            return aref;
        }

        public static List<Application> getSystemApplicationsReferencedFrom(Domain d, String sn) {
            if (d == null || sn == null) {
                throw new IllegalArgumentException("Null argument");
            }
            List<Application> allApps = d.getAllDefinedSystemApplications();
            if (allApps.isEmpty()) {
                return allApps;
            }
            Server s = Duck.getServerNamed(d, sn);
            ArrayList<Application> referencedApps = new ArrayList<Application>();
            List<ApplicationRef> appsReferenced = s.getApplicationRef();
            for (ApplicationRef ref : appsReferenced) {
                for (Application app : allApps) {
                    if (!ref.getRef().equals(app.getName())) continue;
                    referencedApps.add(app);
                }
            }
            return referencedApps;
        }

        public static Application getSystemApplicationReferencedFrom(Domain d, String sn, String appName) {
            List<Application> allApps = Duck.getSystemApplicationsReferencedFrom(d, sn);
            for (Application app : allApps) {
                if (!app.getName().equals(appName)) continue;
                return app;
            }
            return null;
        }

        public static boolean isNamedSystemApplicationReferencedFrom(Domain d, String appName, String serverName) {
            List<Application> referencedApps = Duck.getSystemApplicationsReferencedFrom(d, serverName);
            for (Application app : referencedApps) {
                if (!app.getName().equals(appName)) continue;
                return true;
            }
            return false;
        }

        public static Server getServerNamed(Domain d, String name) {
            if (d.getServers() == null || name == null) {
                throw new IllegalArgumentException("no <servers> element");
            }
            List<Server> servers = d.getServers().getServer();
            for (Server s : servers) {
                if (!name.equals(s.getName().trim())) continue;
                return s;
            }
            return null;
        }
    }
}

