/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.config;

import com.sun.grizzly.Controller;
import com.sun.grizzly.config.GrizzlyEmbeddedHttp;
import com.sun.grizzly.config.GrizzlyEmbeddedHttps;
import com.sun.grizzly.config.dom.NetworkListener;
import java.io.IOException;
import java.net.InetAddress;
import java.util.logging.Logger;
import org.jvnet.hk2.component.Habitat;

public class GrizzlyServiceListener {
    protected static final Logger logger = Logger.getLogger(GrizzlyServiceListener.class.getName());
    private Controller controller;
    private boolean isEmbeddedHttpSecured;
    private GrizzlyEmbeddedHttp embeddedHttp;
    private String name;

    public GrizzlyServiceListener(Controller cont) {
        this.controller = cont;
    }

    public void configure(NetworkListener networkListener, boolean isWebProfile, Habitat habitat) {
        if (System.getProperty("product.name") == null) {
            System.setProperty("product.name", "GlassFish/v3");
        }
        this.initializeListener(isWebProfile, networkListener, habitat);
        this.setName(networkListener.getName());
        GrizzlyEmbeddedHttp.setLogger((Logger)logger);
    }

    private void initializeListener(boolean webProfile, NetworkListener networkListener, Habitat habitat) {
        this.isEmbeddedHttpSecured = Boolean.parseBoolean(networkListener.findProtocol().getSecurityEnabled());
        this.embeddedHttp = this.createEmbeddedHttp(this.isEmbeddedHttpSecured);
        this.embeddedHttp.setController(this.controller);
        this.embeddedHttp.configure(webProfile, networkListener, habitat);
    }

    protected GrizzlyEmbeddedHttp createEmbeddedHttp(boolean isSecured) {
        if (isSecured) {
            return new GrizzlyEmbeddedHttps(this);
        }
        return new GrizzlyEmbeddedHttp(this);
    }

    public void start() throws IOException, InstantiationException {
        this.embeddedHttp.initEndpoint();
        this.embeddedHttp.startEndpoint();
    }

    public void stop() {
        this.embeddedHttp.stopEndpoint();
    }

    public void setAddress(InetAddress address) {
        if (this.embeddedHttp != null) {
            this.embeddedHttp.setAddress(address);
        }
    }

    public Controller getController() {
        return this.controller;
    }

    public String getDefaultVirtualServer() {
        return this.embeddedHttp.getDefaultVirtualServer();
    }

    public GrizzlyEmbeddedHttp getEmbeddedHttp() {
        return this.embeddedHttp;
    }

    public boolean isEmbeddedHttpSecured() {
        return this.isEmbeddedHttpSecured;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPort() {
        return this.embeddedHttp.getPort();
    }
}

