/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.agent;

import com.sun.btrace.agent.Client;
import com.sun.btrace.agent.Main;
import com.sun.btrace.comm.Command;
import com.sun.btrace.comm.DataCommand;
import com.sun.btrace.comm.ErrorCommand;
import com.sun.btrace.comm.ExitCommand;
import com.sun.btrace.comm.InstrumentCommand;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.instrument.Instrumentation;

class FileClient
extends Client {
    private volatile PrintWriter out;

    FileClient(Instrumentation inst, byte[] code, PrintWriter traceWriter) throws IOException {
        super(inst);
        this.out = traceWriter;
        InstrumentCommand cmd = new InstrumentCommand(code, new String[0]);
        Class btraceClazz = this.loadClass(cmd);
        if (btraceClazz == null) {
            throw new RuntimeException("can not load BTrace class");
        }
    }

    FileClient(Instrumentation inst, File scriptFile, PrintWriter traceWriter) throws IOException {
        this(inst, FileClient.readAll(scriptFile), traceWriter);
    }

    public void onCommand(Command cmd) throws IOException {
        if (this.out == null) {
            throw new IOException("no output stream");
        }
        if (this.debug) {
            Main.debugPrint("client " + this.getClassName() + ": got " + cmd);
        }
        switch (cmd.getType()) {
            case 2: {
                this.onExit(((ExitCommand)cmd).getExitCode());
                break;
            }
            case 0: {
                ErrorCommand ecmd = (ErrorCommand)cmd;
                Throwable cause = ecmd.getCause();
                if (cause == null) break;
                cause.printStackTrace(this.out);
                this.out.flush();
                break;
            }
            default: {
                if (!(cmd instanceof DataCommand)) break;
                ((DataCommand)cmd).print(this.out);
                this.out.flush();
            }
        }
    }

    @Override
    protected synchronized void closeAll() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readAll(File file) throws IOException {
        int size = (int)file.length();
        FileInputStream fis = new FileInputStream(file);
        try {
            byte[] buf = new byte[size];
            fis.read(buf);
            byte[] byArray = buf;
            return byArray;
        }
        finally {
            fis.close();
        }
    }
}

