/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.commands;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.More;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;

public class HelpCommand
extends CLICommand {
    private static final int DEFAULT_PAGE_LENGTH = 50;
    private static final int NO_PAGE_LENGTH = -1;
    private static final String DEFAULT_HELP_PAGE = "help";
    private static final LocalStringsImpl strings = new LocalStringsImpl(HelpCommand.class);

    public HelpCommand(String name, ProgramOptions programOpts, Environment env) throws CommandException, CommandValidationException {
        super(name, programOpts, env);
    }

    protected void prepare() throws CommandException, CommandValidationException {
        this.commandOpts = Collections.emptySet();
        this.operandName = "command-name";
        this.operandType = "STRING";
        this.operandMin = 0;
        this.operandMax = 1;
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        try {
            new More(this.getPageLength(), this.getSource(), this.getDestination(), this.getUserInput(), this.getUserOutput(), this.getQuitChar(), this.getPrompt());
        }
        catch (IOException ioe) {
            throw new CommandException(ioe);
        }
        return 0;
    }

    private String getCommandName() {
        return this.operands.size() > 0 ? (String)this.operands.get(0) : DEFAULT_HELP_PAGE;
    }

    private Writer getDestination() {
        return new OutputStreamWriter(System.out);
    }

    private int getPageLength() {
        if (this.programOpts.isInteractive()) {
            return 50;
        }
        return -1;
    }

    private String getPrompt() {
        return strings.get("ManpagePrompt");
    }

    private String getQuitChar() {
        return strings.get("ManpageQuit");
    }

    private Reader getSource() throws CommandException, CommandValidationException {
        CLICommand cmd = CLICommand.getCommand(this.getCommandName(), this.programOpts, this.env);
        Reader r = cmd.getManPage();
        if (r == null) {
            throw new CommandException(strings.get("ManpageMissing", new Object[]{this.getCommandName()}));
        }
        return r;
    }

    private Reader getUserInput() {
        return new InputStreamReader(System.in);
    }

    private Writer getUserOutput() {
        return new OutputStreamWriter(System.err);
    }
}

