/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.commands;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.commands.MonitorTask;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.ValidOption;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Timer;
import java.util.TimerTask;

public class MonitorCommand
extends CLICommand {
    private int interval = 30000;
    private String type;
    private String filter;
    private File fileName;
    private static final String INTERVAL = "interval";
    private static final String TYPE = "type";
    private static final String FILTER = "filter";
    private static final String FILENAME = "filename";
    private static final LocalStringsImpl strings = new LocalStringsImpl(MonitorCommand.class);

    public MonitorCommand(String name, ProgramOptions programOpts, Environment env) throws CommandException, CommandValidationException {
        super(name, programOpts, env);
    }

    protected void prepare() throws CommandException, CommandValidationException {
        this.processProgramOptions();
        LinkedHashSet<ValidOption> opts = new LinkedHashSet<ValidOption>();
        MonitorCommand.addOption(opts, TYPE, '\u0000', "STRING", true, null);
        MonitorCommand.addOption(opts, FILENAME, '\u0000', "STRING", false, null);
        MonitorCommand.addOption(opts, INTERVAL, '\u0000', "STRING", false, "30");
        MonitorCommand.addOption(opts, FILTER, '\u0000', "STRING", false, null);
        MonitorCommand.addOption(opts, "help", '?', "BOOLEAN", false, "false");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandName = "target";
        this.operandType = "STRING";
        this.operandMin = 1;
        this.operandMax = 1;
    }

    protected void validate() throws CommandException, CommandValidationException {
        super.validate();
        String sinterval = this.getOption(INTERVAL);
        if (MonitorCommand.ok(sinterval)) {
            this.interval = Integer.parseInt(sinterval) * 1000;
        }
        this.type = this.getOption(TYPE);
        this.filter = this.getOption(FILTER);
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        Timer timer = new Timer();
        try {
            MonitorTask monitorTask = new MonitorTask(timer, this.getRemoteArgs(), this.programOpts, this.env, this.type, this.filter, this.fileName);
            timer.scheduleAtFixedRate((TimerTask)monitorTask, 0L, (long)this.interval);
            boolean done = false;
            while (!done) {
                String str = new BufferedReader(new InputStreamReader(System.in)).readLine();
                if (str.equals("q") || str.equals("Q")) {
                    timer.cancel();
                    done = true;
                    String exceptionMessage = monitorTask.getExceptionMessage();
                    if (exceptionMessage == null) continue;
                    throw new CommandException(exceptionMessage);
                }
                if (!str.equals("h") && !str.equals("H")) continue;
                monitorTask.displayDetails();
            }
        }
        catch (Exception e) {
            timer.cancel();
            throw new CommandException(strings.get("monitorCommand.errorRemote", new Object[]{e.getMessage()}));
        }
        return 0;
    }

    private String[] getRemoteArgs() {
        ArrayList<String> list = new ArrayList<String>(5);
        list.add("monitor");
        if (MonitorCommand.ok(this.type)) {
            list.add("--type");
            list.add(this.type);
        }
        if (MonitorCommand.ok(this.filter)) {
            list.add("--filter");
            list.add(this.filter);
        }
        return list.toArray(new String[list.size()]);
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }
}

