/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.remote;

import com.sun.enterprise.admin.cli.AuthenticationException;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.ExceptionAnalyzer;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import java.io.IOException;
import java.net.ConnectException;

public class DASUtils {
    private DASUtils() {
    }

    public static boolean pingDASQuietly(ProgramOptions programOpts, Environment env) {
        try {
            RemoteCommand cmd = new RemoteCommand("version", programOpts, env);
            cmd.executeAndReturnOutput("version");
            return true;
        }
        catch (AuthenticationException aex) {
            return true;
        }
        catch (Exception ex) {
            ExceptionAnalyzer ea = new ExceptionAnalyzer(ex);
            if (ea.getFirstInstanceOf(ConnectException.class) != null) {
                CLILogger.getInstance().printDebugMessage("Got java.net.ConnectException");
                return false;
            }
            if (ea.getFirstInstanceOf(IOException.class) != null) {
                CLILogger.getInstance().printDebugMessage("It appears that server has started, but for some reason the exception is thrown: " + ex.getMessage());
                return true;
            }
            return false;
        }
    }

    public static boolean pingDASWithAuth(ProgramOptions programOpts, Environment env) {
        try {
            RemoteCommand cmd = new RemoteCommand("version", programOpts, env);
            cmd.executeAndReturnOutput("version");
            return true;
        }
        catch (AuthenticationException aex) {
            return false;
        }
        catch (Exception ex) {
            ExceptionAnalyzer ea = new ExceptionAnalyzer(ex);
            if (ea.getFirstInstanceOf(ConnectException.class) != null) {
                CLILogger.getInstance().printDebugMessage("Got java.net.ConnectException");
                return false;
            }
            if (ea.getFirstInstanceOf(IOException.class) != null) {
                CLILogger.getInstance().printDebugMessage("It appears that server has started, but for some reason the exception is thrown: " + ex.getMessage());
                return true;
            }
            return false;
        }
    }
}

