/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMain;
import com.sun.enterprise.glassfish.bootstrap.ASMainHelper;
import com.sun.enterprise.glassfish.bootstrap.ASMainNonOSGi;
import com.sun.enterprise.glassfish.bootstrap.Rejar;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.ArgumentManager;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.module.bootstrap.Main;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.impl.ModulesRegistryImpl;
import com.sun.enterprise.module.single.SingleModulesRegistry;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import com.sun.hk2.component.InhabitantsParser;
import com.sun.hk2.component.InhabitantsParserDecorator;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.Inhabitants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASMainStatic
extends ASMainNonOSGi {
    private File out;
    private Habitat habitat;

    @Override
    protected String getPreferedCacheDir() {
        return "static-cache/gf/";
    }

    public String getName() {
        return ASMain.Platform.Static.toString();
    }

    public <T> T getStartedService(Class<T> serviceType) {
        if (this.habitat != null) {
            return (T)this.habitat.getComponent(serviceType);
        }
        return null;
    }

    @Override
    protected void setUpCache(File sourceDir, File cacheDir) throws IOException {
    }

    @Override
    public void run(final Logger logger, String ... args) throws Exception {
        super.run(logger, args);
        StartupContext sc = (StartupContext)this.getContext(StartupContext.class);
        if (sc == null) {
            Properties p = ArgumentManager.argsToMap((String[])args);
            for (String arg : args) {
                if (!arg.equals("-upgrade")) continue;
                p.put("hk2.startup.context.moduleStartup", "upgrade");
            }
            sc = new StartupContext(this.findBootstrapFile().getParentFile().getParentFile(), p);
        }
        super.setContext((Object)sc);
        File modulesDir = new File(sc.getRootDirectory(), "modules");
        StartupContext startupContext = sc;
        this.setSystemProperties();
        ClassLoader singleClassLoader = null;
        final File cacheDir = System.getProperty("glassfish.static.cache.dir") != null ? new File(System.getProperty("glassfish.static.cache.dir"), this.getPreferedCacheDir()) : new File(this.domainDir, this.getPreferedCacheDir());
        this.out = new File(cacheDir, "glassfish.jar");
        final long lastModified = ASMainHelper.getLastModified(modulesDir, 0L);
        Thread cacheThread = null;
        if (this.isCacheOutdated(lastModified, cacheDir)) {
            logger.info("Cache not present, will revert to less efficient algorithm");
            cacheThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        ASMainStatic.this.flushAndCreate(cacheDir, lastModified);
                    }
                    catch (IOException e) {
                        ASMainStatic.this.getLogger().log(Level.SEVERE, "Failed setting up the cache, aborting", e);
                    }
                }
            });
            try {
                singleClassLoader = this.createTmpClassLoader(modulesDir);
            }
            catch (Exception e) {
                throw new BootException((Throwable)e);
            }
        }
        try {
            singleClassLoader = this.createClassLoader(cacheDir);
        }
        catch (Exception e) {
            throw new BootException((Throwable)e);
        }
        if (singleClassLoader == null) {
            throw new BootException("Could not create single class loader from the cache");
        }
        Module[] proxyMod = new Module[1];
        SingleModulesRegistry modulesRegistry = new SingleModulesRegistry(singleClassLoader);
        modulesRegistry.setParentClassLoader(singleClassLoader);
        final ClassLoader cl = singleClassLoader;
        Thread launcherThread = new Thread(new Runnable((ModulesRegistryImpl)modulesRegistry, startupContext){
            final /* synthetic */ ModulesRegistryImpl val$modulesRegistry;
            final /* synthetic */ StartupContext val$startupContext;
            {
                this.val$modulesRegistry = modulesRegistryImpl;
                this.val$startupContext = startupContext;
            }

            public void run() {
                Main main = new Main(){

                    protected Habitat createHabitat(ModulesRegistry registry, StartupContext context) throws BootException {
                        Habitat habitat = registry.newHabitat();
                        for (Object c : ASMainStatic.this.getContexts()) {
                            habitat.add(Inhabitants.create(c));
                        }
                        habitat.add((Inhabitant)new ExistingSingletonInhabitant(ModulesRegistry.class, (Object)registry));
                        habitat.add((Inhabitant)new ExistingSingletonInhabitant(Logger.class, (Object)logger));
                        registry.createHabitat("default", this.createInhabitantsParser(habitat));
                        ASMainStatic.this.habitat = habitat;
                        return habitat;
                    }

                    protected InhabitantsParser createInhabitantsParser(Habitat habitat) {
                        InhabitantsParser parser = super.createInhabitantsParser(habitat);
                        ServiceLoader<InhabitantsParserDecorator> decorators = ServiceLoader.load(InhabitantsParserDecorator.class, cl);
                        for (InhabitantsParserDecorator decorator : decorators) {
                            decorator.decorate(parser);
                        }
                        return parser;
                    }
                };
                try {
                    main.launch((ModulesRegistry)this.val$modulesRegistry, this.val$startupContext);
                }
                catch (BootException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }, "Static Framework Launcher");
        launcherThread.setContextClassLoader(singleClassLoader);
        launcherThread.setDaemon(true);
        launcherThread.start();
        try {
            launcherThread.join();
        }
        catch (InterruptedException e) {
            logger.warning("main thread interrupted");
        }
        logger.fine("Framework successfully started");
        if (cacheThread != null) {
            logger.info("Started cache creation");
            cacheThread.start();
            try {
                cacheThread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            logger.info("Finished cache creation");
        }
    }

    @Override
    Logger getLogger() {
        return this.logger;
    }

    @Override
    boolean createCache(File cacheDir) throws IOException {
        cacheDir.mkdirs();
        Rejar rejar = new Rejar();
        rejar.rejar(this.out, this.bootstrapFile.getParentFile());
        return true;
    }

    public ClassLoader createClassLoader(File cacheDir) throws Exception {
        if (this.out != null) {
            ArrayList<URL> urls = new ArrayList<URL>();
            urls.add(this.out.toURI().toURL());
            this.findDerbyClient(urls);
            return new URLClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
        }
        return null;
    }

    public ClassLoader createTmpClassLoader(File moduleDir) throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        this.insertURLs(moduleDir, urls);
        this.findDerbyClient(urls);
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
    }

    private void insertURLs(File directory, List<URL> result) throws Exception {
        for (File file : directory.listFiles()) {
            if (file.isFile()) {
                result.add(file.toURI().toURL());
                continue;
            }
            this.insertURLs(file, result);
        }
    }

    private void findDerbyClient(List<URL> urls) throws IOException {
        String derbyHome = System.getProperty("AS_DERBY_INSTALL");
        File derbyLib = null;
        if (derbyHome != null) {
            derbyLib = new File(derbyHome, "lib");
        }
        if (!(derbyLib != null && derbyLib.exists() || System.getProperty("java.version").compareTo("1.6") <= 0)) {
            File jdkHome = new File(System.getProperty("java.home"));
            derbyLib = new File(jdkHome, "../db/lib");
        }
        if (!derbyLib.exists()) {
            this.logger.info("Cannot find javadb client jar file, jdbc driver not available");
            return;
        }
        urls.add(new File(derbyLib, "derby.jar").toURI().toURL());
        urls.add(new File(derbyLib, "derbyclient.jar").toURI().toURL());
    }
}

