/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.core;

import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.flashlight.impl.core.FlashlightProbeProvider;

public class ProbeProviderRegistry {
    private static ProbeProviderRegistry _me = new ProbeProviderRegistry();
    private ConcurrentHashMap<String, FlashlightProbeProvider> providerMap = new ConcurrentHashMap();

    private ProbeProviderRegistry() {
    }

    public static ProbeProviderRegistry getInstance() {
        return _me;
    }

    public FlashlightProbeProvider getProbeProvider(String moduleProviderName, String moduleName, String probeProviderName) {
        String qname = moduleProviderName + ":" + moduleName + ":" + (probeProviderName == null ? "" : probeProviderName);
        return this.providerMap.get(qname);
    }

    public FlashlightProbeProvider registerProbeProvider(FlashlightProbeProvider provider, Class clz) {
        String qname = provider.getModuleProviderName() + ":" + provider.getModuleName() + ":" + (provider.getProbeProviderName() == null ? clz.getName() : provider.getProbeProviderName());
        FlashlightProbeProvider oldProvider = this.providerMap.get(qname);
        if (oldProvider != null) {
            throw new IllegalStateException("Provider already mapped " + qname);
        }
        this.providerMap.put(qname, provider);
        return provider;
    }
}

