/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CLIConstants;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ListCommandsCommand;
import com.sun.enterprise.admin.cli.Parser;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.CLIRemoteCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CLIMain;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.InvalidCommandException;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.JDK;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.ConnectException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsadminMain {
    private static final int ERROR = 1;
    private static final int CONNECTION_ERROR = 2;
    private static final int INVALID_COMMAND_ERROR = 3;
    private static final int SUCCESS = 0;
    private static final LocalStringsImpl strings = new LocalStringsImpl(AsadminMain.class);
    private static String[] copyOfArgs;
    private static String classPath;
    private static String className;
    private static String command;
    private static Map<String, String> systemProps;
    private static ProgramOptions po;

    public static void main(String[] args) {
        int exitCode;
        int minor = JDK.getMinor();
        if (minor < 6) {
            CLILogger.getInstance().printError(strings.get("OldJdk", new Object[]{"" + minor}));
            System.exit(1);
        }
        if (CLIConstants.debugMode) {
            System.setProperty("WALL_CLOCK_START", "" + System.currentTimeMillis());
            CLILogger.getInstance().printDebugMessage("CLASSPATH= " + System.getProperty("java.class.path") + "\nCommands: " + Arrays.toString(args));
        }
        AsadminMain main = new AsadminMain();
        if (args.length <= 0) {
            args = new String[]{"multimode"};
        }
        copyOfArgs = new String[args.length];
        System.arraycopy(args, 0, copyOfArgs, 0, args.length);
        classPath = SmartFile.sanitizePaths((String)System.getProperty("java.class.path"));
        className = main.getClass().getName();
        command = args[0];
        if (System.getenv("ASADMIN_NEW") == null || Boolean.parseBoolean(System.getenv("ASADMIN_NEW"))) {
            exitCode = AsadminMain.executeCommand(args);
        } else {
            CLILogger.getInstance().printMessage("Using OLD asadmin");
            try {
                try {
                    po = new ProgramOptions(new Environment());
                    exitCode = main.local(args);
                }
                catch (CommandException ce) {
                    CLILogger.getInstance().printError(ce.getMessage());
                    exitCode = 1;
                }
            }
            catch (InvalidCommandException e) {
                if (args[0].equals("help")) {
                    exitCode = main.remote(new String[]{args[1], "--help"});
                    command = args[1];
                }
                CLILogger.getInstance().printDebugMessage(e.getMessage());
                exitCode = main.remote(args);
            }
        }
        switch (exitCode) {
            case 0: {
                if (po.isTerse()) break;
                CLILogger.getInstance().printDetailMessage(strings.get("CommandSuccessful", new Object[]{command}));
                break;
            }
            case 1: {
                CLILogger.getInstance().printDetailMessage(strings.get("CommandUnSuccessful", new Object[]{command}));
                break;
            }
            case 3: {
                try {
                    CLIMain.displayClosestMatch(command, main.getRemoteCommands(), strings.get("ClosestMatchedLocalAndRemoteCommands"));
                }
                catch (InvalidCommandException e) {
                    // empty catch block
                }
                CLILogger.getInstance().printDetailMessage(strings.get("CommandUnSuccessful", new Object[]{command}));
                break;
            }
            case 2: {
                try {
                    CLIMain.displayClosestMatch(command, null, strings.get("ClosestMatchedLocalCommands"));
                }
                catch (InvalidCommandException e) {
                    CLILogger.getInstance().printMessage(strings.get("InvalidRemoteCommand", new Object[]{command}));
                }
                CLILogger.getInstance().printDetailMessage(strings.get("CommandUnSuccessful", new Object[]{command}));
            }
        }
        AsadminMain.writeCommandToDebugLog(args, exitCode);
        System.exit(exitCode);
    }

    public static int executeCommand(String[] argv) {
        CLICommand cmd = null;
        try {
            Environment env = new Environment();
            if (argv.length > 0 && argv[0].startsWith("-")) {
                Parser rcp = new Parser(argv, 0, ProgramOptions.getValidOptions(), false);
                Map<String, String> params = rcp.getOptions();
                po = new ProgramOptions(params, env);
                List<String> operands = rcp.getOperands();
                argv = operands.toArray(new String[operands.size()]);
            } else {
                po = new ProgramOptions(env);
            }
            po.toEnvironment(env);
            po.setProgramArguments(copyOfArgs);
            po.setClassPath(classPath);
            po.setClassName(className);
            if (argv.length == 0) {
                argv = new String[]{"multimode"};
            }
            command = argv[0];
            cmd = CLICommand.getCommand(command, po, env);
            return cmd.execute(argv);
        }
        catch (CommandException ce) {
            if (ce.getCause() instanceof InvalidCommandException) {
                CLILogger.getInstance().printError(ce.getMessage());
            } else if (ce.getCause() instanceof ConnectException) {
                CLILogger.getInstance().printError(ce.getMessage());
            } else {
                CLILogger.getInstance().printError(ce.getMessage());
            }
            return 1;
        }
        catch (CommandValidationException cve) {
            CLILogger.getInstance().printError(cve.getMessage());
            if (cmd == null) {
                AsadminMain.printUsage();
            } else {
                CLILogger.getInstance().printError(cmd.getUsage());
            }
            return 1;
        }
    }

    private static void printUsage() {
        CLILogger.getInstance().printError("Usage: asadmin [--host localhost] [--port 4848] [--user anonymous]\n\t[--passwordfile file] [--secure=true/false] [--echo=true/false]\n\t[--interactive=true/false] [--help] [command [options] [operands]]");
    }

    public int local(String[] args) throws InvalidCommandException {
        try {
            CLIMain cli = new CLIMain();
            cli.invokeCommand(args);
            return 0;
        }
        catch (CommandException ce) {
            CLILogger.getInstance().printError(ce.getMessage());
            return 1;
        }
        catch (CommandValidationException cve) {
            CLILogger.getInstance().printError(cve.getMessage());
            return 1;
        }
        catch (NoClassDefFoundError ncdfe) {
            CLILogger.getInstance().printError(ncdfe.toString());
            return 1;
        }
        catch (InvalidCommandException ice) {
            throw ice;
        }
        catch (Throwable ex) {
            CLILogger.getInstance().printExceptionStackTrace(ex);
            CLILogger.getInstance().printError(ex.toString());
            return 1;
        }
    }

    public int remote(String[] args) {
        try {
            CLIRemoteCommand orc = new CLIRemoteCommand(args);
            orc.runCommand();
            return 0;
        }
        catch (Throwable ex) {
            CLILogger.getInstance().printExceptionStackTrace(ex);
            CLILogger.getInstance().printMessage(ex.getMessage());
            if (ex.getCause() instanceof ConnectException) {
                return 2;
            }
            if (ex.getCause() instanceof InvalidCommandException) {
                return 3;
            }
            return 1;
        }
    }

    public static Map<String, String> getSystemProps() {
        return Collections.unmodifiableMap(systemProps);
    }

    static String[] getArgs() {
        return copyOfArgs;
    }

    static String getClassPath() {
        return classPath;
    }

    static String getClassName() {
        return className;
    }

    private Map<String, String> getRemoteCommands() {
        try {
            ListCommandsCommand lcc = new ListCommandsCommand();
            String[] remoteCommands = lcc.getRemoteCommands();
            HashMap<String, String> remoteCommandsMap = new HashMap<String, String>();
            for (String rc : remoteCommands) {
                remoteCommandsMap.put(rc, "remote command");
            }
            return remoteCommandsMap;
        }
        catch (CommandException ce) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCommandToDebugLog(String[] args, int exit) {
        File log = AsadminMain.getDebugLogfile();
        if (log == null) {
            return;
        }
        Writer out = null;
        try {
            out = new BufferedWriter(new FileWriter(log, true));
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            Date date = new Date();
            out.write(dateFormat.format(date));
            out.write(" EXIT: " + exit);
            out.write(" asadmin ");
            if (args != null) {
                for (int i = 0; args != null && i < args.length; ++i) {
                    out.write(args[i] + " ");
                }
            }
        }
        catch (IOException e) {
        }
        finally {
            if (out != null) {
                try {
                    out.write("\n");
                    ((BufferedWriter)out).close();
                }
                catch (Exception e) {}
            }
        }
    }

    private static File getDebugLogfile() {
        String fname = AsadminMain.getEnvOrSysProp("AS_LOGFILE");
        if (fname == null) {
            return null;
        }
        File f = new File(fname);
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (f.isFile() && f.canWrite()) {
            return f;
        }
        return null;
    }

    private static String getEnvOrSysProp(String index) {
        String s1 = System.getProperty(index);
        String s2 = System.getenv(index);
        if (s1 != null) {
            return s1;
        }
        return s2;
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    static {
        systemProps = new ASenvPropertyReader().getProps();
        String ir = "com.sun.aas.installRoot";
        String cr = "com.sun.aas.configRoot";
        String irVal = systemProps.get("com.sun.aas.installRoot");
        String crVal = systemProps.get("com.sun.aas.configRoot");
        if (AsadminMain.ok(irVal)) {
            System.setProperty("com.sun.aas.installRoot", irVal);
        }
        if (AsadminMain.ok(crVal)) {
            System.setProperty("com.sun.aas.configRoot", crVal);
        }
    }
}

