/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.ValidOption;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgramOptions {
    private static final Set<ValidOption> programOptions;
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String USER = "user";
    public static final String PASSWORDFILE = "passwordfile";
    public static final String TERSE = "terse";
    public static final String ECHO = "echo";
    public static final String INTERACTIVE = "interactive";
    public static final String SECURE = "secure";
    public static final String HELP = "help";
    private static final LocalStringsImpl strings;
    private Map<String, String> options;
    private Environment env;
    private boolean optionsSet;
    private String password;
    private String[] programArguments;
    private String classPath;
    private String className;

    private static void addMetaOption(Set<ValidOption> opts, String name, char sname, String type, boolean req, String def) {
        ValidOption opt = new ValidOption(name, type, req ? 1 : 2, def);
        String abbr = Character.toString(sname);
        opt.setShortName(abbr);
        opts.add(opt);
    }

    public ProgramOptions(Environment env) throws CommandException {
        this(new HashMap<String, String>(), env);
        this.optionsSet = false;
    }

    public ProgramOptions(Map<String, String> options, Environment env) throws CommandException {
        this.env = env;
        this.updateOptions(options);
    }

    public ProgramOptions(ProgramOptions other) {
        this.options = new HashMap<String, String>(other.options);
        this.env = other.env;
        this.password = other.password;
        this.programArguments = other.programArguments;
        this.classPath = other.classPath;
        this.className = other.className;
    }

    public void updateOptions(Map<String, String> newOptions) throws CommandException {
        if (this.options == null) {
            this.options = newOptions;
        } else {
            this.options.putAll(newOptions);
        }
        this.optionsSet = true;
        String sport = this.options.get(PORT);
        if (ProgramOptions.ok(sport)) {
            String badPortMsg = strings.get("badport", new Object[]{sport});
            try {
                int port = Integer.parseInt(sport);
                if (port < 1 || port > 65535) {
                    throw new CommandException(badPortMsg);
                }
            }
            catch (NumberFormatException e) {
                throw new CommandException(badPortMsg);
            }
        }
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    public static Set<ValidOption> getValidOptions() {
        return programOptions;
    }

    public void toEnvironment(Environment env) {
        this.putEnv(env, ECHO);
        this.putEnv(env, TERSE);
        this.putEnv(env, INTERACTIVE);
        this.putEnv(env, HOST);
        this.putEnv(env, PORT);
        this.putEnv(env, SECURE);
        this.putEnv(env, USER);
        this.putEnv(env, PASSWORDFILE);
    }

    private void putEnv(Environment env, String name) {
        String value = this.options.get(name);
        if (value != null) {
            env.putOption(name, value);
        }
    }

    public String getHost() {
        String host = this.options.get(HOST);
        if (!ProgramOptions.ok(host)) {
            host = this.env.getStringOption(HOST);
        }
        if (!ProgramOptions.ok(host)) {
            host = "localhost";
        }
        return host;
    }

    public void setHost(String host) {
        this.options.put(HOST, host);
    }

    public int getPort() {
        int port;
        String sport = this.options.get(PORT);
        if (!ProgramOptions.ok(sport)) {
            sport = this.env.getStringOption(PORT);
        }
        if (ProgramOptions.ok(sport)) {
            try {
                port = Integer.parseInt(sport);
                if (port < 1 || port > 65535) {
                    port = -1;
                }
            }
            catch (NumberFormatException e) {
                port = -1;
            }
        } else {
            port = 4848;
        }
        return port;
    }

    public void setPort(int port) {
        this.options.put(PORT, Integer.toString(port));
    }

    public String getUser() {
        String user = this.options.get(USER);
        if (!ProgramOptions.ok(user)) {
            user = this.env.getStringOption(USER);
        }
        if (!ProgramOptions.ok(user)) {
            user = null;
        }
        return user;
    }

    public void setUser(String user) {
        this.options.put(USER, user);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPasswordFile() {
        String passwordFile = this.options.get(PASSWORDFILE);
        if (!ProgramOptions.ok(passwordFile)) {
            passwordFile = this.env.getStringOption(PASSWORDFILE);
        }
        if (!ProgramOptions.ok(passwordFile)) {
            passwordFile = null;
        }
        return passwordFile;
    }

    public void setPasswordFile(String passwordFile) {
        this.options.put(PASSWORDFILE, passwordFile);
    }

    public boolean isSecure() {
        String value;
        boolean secure = this.options.containsKey(SECURE) ? (ProgramOptions.ok(value = this.options.get(SECURE)) ? Boolean.parseBoolean(value) : true) : this.env.getBooleanOption(SECURE);
        return secure;
    }

    public void setSecure(boolean secure) {
        this.options.put(SECURE, Boolean.toString(secure));
    }

    public boolean isTerse() {
        String value;
        boolean terse = this.options.containsKey(TERSE) ? (ProgramOptions.ok(value = this.options.get(TERSE)) ? Boolean.parseBoolean(value) : true) : this.env.getBooleanOption(TERSE);
        return terse;
    }

    public void setTerse(boolean terse) {
        this.options.put(TERSE, Boolean.toString(terse));
    }

    public boolean isEcho() {
        String value;
        boolean echo = this.options.containsKey(ECHO) ? (ProgramOptions.ok(value = this.options.get(ECHO)) ? Boolean.parseBoolean(value) : true) : this.env.getBooleanOption(ECHO);
        return echo;
    }

    public void setEcho(boolean echo) {
        this.options.put(ECHO, Boolean.toString(echo));
    }

    public boolean isInteractive() {
        String value;
        boolean interactive = this.options.containsKey(INTERACTIVE) ? (ProgramOptions.ok(value = this.options.get(INTERACTIVE)) ? Boolean.parseBoolean(value) : true) : (this.env.hasOption(INTERACTIVE) ? this.env.getBooleanOption(INTERACTIVE) : System.console() != null);
        return interactive;
    }

    public void setInteractive(boolean interactive) {
        this.options.put(INTERACTIVE, Boolean.toString(interactive));
    }

    public boolean isHelp() {
        String value;
        boolean help = false;
        help = this.options.containsKey(HELP) ? (ProgramOptions.ok(value = this.options.get(HELP)) ? Boolean.parseBoolean(value) : true) : this.env.getBooleanOption(HELP);
        return help;
    }

    public void setHelp(boolean help) {
        this.options.put(HELP, Boolean.toString(help));
    }

    public boolean isOptionsSet() {
        return this.optionsSet;
    }

    public void setOptionsSet(boolean optionsSet) {
        this.optionsSet = optionsSet;
    }

    public String[] getProgramArguments() {
        return this.programArguments;
    }

    public void setProgramArguments(String[] programArguments) {
        this.programArguments = programArguments;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    static {
        strings = new LocalStringsImpl(ProgramOptions.class);
        HashSet<ValidOption> opts = new HashSet<ValidOption>();
        ProgramOptions.addMetaOption(opts, HOST, 'H', "STRING", false, "localhost");
        ProgramOptions.addMetaOption(opts, PORT, 'p', "STRING", false, "4848");
        ProgramOptions.addMetaOption(opts, USER, 'u', "STRING", false, "anonymous");
        ProgramOptions.addMetaOption(opts, "password", 'w', "STRING", false, null);
        ProgramOptions.addMetaOption(opts, PASSWORDFILE, 'W', "FILE", false, null);
        ProgramOptions.addMetaOption(opts, SECURE, 's', "BOOLEAN", false, "false");
        ProgramOptions.addMetaOption(opts, TERSE, 't', "BOOLEAN", false, "false");
        ProgramOptions.addMetaOption(opts, ECHO, 'e', "BOOLEAN", false, "false");
        ProgramOptions.addMetaOption(opts, INTERACTIVE, 'I', "BOOLEAN", false, "false");
        ProgramOptions.addMetaOption(opts, HELP, '?', "BOOLEAN", false, "false");
        programOptions = Collections.unmodifiableSet(opts);
    }
}

