/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.config;

import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.SSLConfig;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.config.GrizzlyEmbeddedHttp;
import com.sun.grizzly.config.GrizzlyServiceListener;
import com.sun.grizzly.config.WebProtocolHandler;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Ssl;
import com.sun.grizzly.filter.SSLReadFilter;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.portunif.PUPreProcessor;
import com.sun.grizzly.portunif.TLSPUPreProcessor;
import com.sun.grizzly.ssl.SSLAsyncProcessorTask;
import com.sun.grizzly.ssl.SSLAsyncProtocolFilter;
import com.sun.grizzly.ssl.SSLDefaultProtocolFilter;
import com.sun.grizzly.ssl.SSLProcessorTask;
import com.sun.grizzly.ssl.SSLSelectorThreadHandler;
import com.sun.grizzly.util.ClassLoaderUtil;
import com.sun.grizzly.util.net.SSLImplementation;
import com.sun.grizzly.util.net.ServerSocketFactory;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyEmbeddedHttps
extends GrizzlyEmbeddedHttp {
    private SSLImplementation sslImplementation;
    protected SSLContext sslContext;
    private String[] enabledCipherSuites = null;
    private String[] enabledProtocols = null;
    private boolean clientMode = false;
    private boolean needClientAuth = false;
    private boolean wantClientAuth = false;
    private String certNickname = null;

    public GrizzlyEmbeddedHttps(GrizzlyServiceListener grizzlyServiceListener) {
        super(grizzlyServiceListener);
    }

    @Override
    public void configure(boolean isWebProfile, NetworkListener networkListener, Habitat habitat) {
        super.configure(isWebProfile, networkListener, habitat);
        this.configureSSL(networkListener.findProtocol());
    }

    private boolean configureSSL(Protocol http) {
        Ssl sslConfig = http.getSsl();
        LinkedList<String> tmpSSLArtifactsList = new LinkedList<String>();
        if (sslConfig != null) {
            String auth;
            if (Boolean.parseBoolean(sslConfig.getClientAuthEnabled())) {
                this.setNeedClientAuth(true);
            }
            if (Boolean.parseBoolean(sslConfig.getSsl2Enabled())) {
                tmpSSLArtifactsList.add("SSLv2");
            }
            if (Boolean.parseBoolean(sslConfig.getSsl3Enabled())) {
                tmpSSLArtifactsList.add("SSLv3");
            }
            if (Boolean.parseBoolean(sslConfig.getTlsEnabled())) {
                tmpSSLArtifactsList.add("TLSv1");
            }
            if (Boolean.parseBoolean(sslConfig.getSsl3Enabled()) || Boolean.parseBoolean(sslConfig.getTlsEnabled())) {
                tmpSSLArtifactsList.add("SSLv2Hello");
            }
            if ((auth = sslConfig.getClientAuth()) != null) {
                if ("want".equalsIgnoreCase(auth.trim())) {
                    this.setWantClientAuth(true);
                } else if ("need".equalsIgnoreCase(auth.trim())) {
                    this.setNeedClientAuth(true);
                }
            }
            if (sslConfig.getClassname() != null) {
                SSLImplementation impl = (SSLImplementation)ClassLoaderUtil.load((String)sslConfig.getClassname());
                if (impl != null) {
                    this.setSSLImplementation(impl);
                } else {
                    logger.log(Level.WARNING, "Unable to load SSLImplementation");
                }
            }
        }
        if (tmpSSLArtifactsList.isEmpty()) {
            logger.log(Level.WARNING, "pewebcontainer.all_ssl_protocols_disabled", http.getName());
        } else {
            String[] protocols = new String[tmpSSLArtifactsList.size()];
            tmpSSLArtifactsList.toArray(protocols);
            this.setEnabledProtocols(protocols);
        }
        tmpSSLArtifactsList.clear();
        if (sslConfig != null) {
            String ssl2Ciphers;
            String ssl3Ciphers;
            String certName = sslConfig.getCertNickname();
            if (certName != null && certName.length() > 0) {
                this.setCertNickname(certName);
            }
            if ((ssl3Ciphers = sslConfig.getSsl3TlsCiphers()) != null && ssl3Ciphers.length() > 0) {
                String[] ssl3CiphersArray;
                for (String cipher : ssl3CiphersArray = ssl3Ciphers.split(",")) {
                    tmpSSLArtifactsList.add(cipher.trim());
                }
            }
            if ((ssl2Ciphers = sslConfig.getSsl2Ciphers()) != null && ssl2Ciphers.length() > 0) {
                String[] ssl2CiphersArray;
                for (String cipher : ssl2CiphersArray = ssl2Ciphers.split(",")) {
                    tmpSSLArtifactsList.add(cipher.trim());
                }
            }
        }
        if (tmpSSLArtifactsList.isEmpty()) {
            logger.log(Level.WARNING, "pewebcontainer.all_ssl_ciphers_disabled", http.getName());
        } else {
            String[] enabledCiphers = new String[tmpSSLArtifactsList.size()];
            tmpSSLArtifactsList.toArray(enabledCiphers);
            this.setEnabledCipherSuites(enabledCiphers);
        }
        try {
            this.initializeSSL();
            return true;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "SSL support could not be configured!", e);
            return false;
        }
    }

    @Override
    WebProtocolHandler.Mode getWebProtocolHandlerMode() {
        return WebProtocolHandler.Mode.HTTPS;
    }

    @Override
    List<PUPreProcessor> getPuPreProcessors() {
        List<PUPreProcessor> preProcessors = super.getPuPreProcessors();
        preProcessors.add((PUPreProcessor)new TLSPUPreProcessor(this.sslContext));
        return preProcessors;
    }

    protected TCPSelectorHandler createSelectorHandler() {
        return new SSLSelectorThreadHandler((SelectorThread)this);
    }

    protected ProtocolFilter createHttpParserFilter() {
        if (this.asyncExecution) {
            return new SSLAsyncProtocolFilter(this.algorithmClass, this.port, this.sslImplementation);
        }
        return new SSLDefaultProtocolFilter(this.algorithmClass, this.port, this.sslImplementation);
    }

    protected void configureFilters(ProtocolChain protocolChain) {
        if (this.portUnificationFilter != null) {
            this.portUnificationFilter.setContinuousExecution(false);
            protocolChain.addFilter((ProtocolFilter)this.portUnificationFilter);
        }
        protocolChain.addFilter(this.createReadFilter());
        protocolChain.addFilter(this.createHttpParserFilter());
    }

    @Override
    protected ProtocolFilter createReadFilter() {
        SSLReadFilter readFilter = new SSLReadFilter();
        readFilter.setSSLContext(this.sslContext);
        readFilter.setClientMode(this.clientMode);
        readFilter.setEnabledCipherSuites(this.enabledCipherSuites);
        readFilter.setEnabledProtocols(this.enabledProtocols);
        readFilter.setNeedClientAuth(this.needClientAuth);
        readFilter.setWantClientAuth(this.wantClientAuth);
        return readFilter;
    }

    protected ProcessorTask newProcessorTask(boolean initialize) {
        SSLAsyncProcessorTask t = this.asyncExecution ? new SSLAsyncProcessorTask(initialize, this.getBufferResponse()) : new SSLProcessorTask(initialize, this.getBufferResponse());
        this.configureProcessorTask((ProcessorTask)t);
        return t;
    }

    public void setSSLConfig(SSLConfig sslConfig) {
        this.sslContext = sslConfig.createSSLContext();
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public void setSSLImplementation(SSLImplementation sslImplementation) {
        this.sslImplementation = sslImplementation;
    }

    public SSLImplementation getSSLImplementation() {
        return this.sslImplementation;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    public void setClientMode(boolean clientMode) {
        this.clientMode = clientMode;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public void initializeSSL() throws Exception {
        SSLImplementation sslHelper = SSLImplementation.getInstance();
        ServerSocketFactory serverSF = sslHelper.getServerSocketFactory();
        serverSF.setAttribute("keystoreType", (Object)"JKS");
        serverSF.setAttribute("keystore", (Object)System.getProperty("javax.net.ssl.keyStore"));
        serverSF.setAttribute("truststoreType", (Object)"JKS");
        serverSF.setAttribute("truststore", (Object)System.getProperty("javax.net.ssl.trustStore"));
        if (this.certNickname != null) {
            serverSF.setAttribute("keyAlias", (Object)this.certNickname);
        }
        serverSF.init();
        this.sslImplementation = sslHelper;
        this.sslContext = serverSF.getSSLContext();
        this.setHttpSecured(true);
    }

    public String getCertNickname() {
        return this.certNickname;
    }

    public void setCertNickname(String certNickname) {
        this.certNickname = certNickname;
    }
}

