/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.client;

import com.sun.logging.LogDomains;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.flashlight.client.ProbeClientInvoker;
import org.glassfish.flashlight.client.ProbeClientInvokerFactory;
import org.glassfish.flashlight.client.ProbeClientMediator;
import org.glassfish.flashlight.client.ProbeClientMethodHandle;
import org.glassfish.flashlight.impl.client.BtraceClientGenerator;
import org.glassfish.flashlight.impl.client.FlashLightBTracePrintWriter;
import org.glassfish.flashlight.impl.client.NullStream;
import org.glassfish.flashlight.impl.client.ProbeClientMethodHandleImpl;
import org.glassfish.flashlight.provider.FlashlightProbe;
import org.glassfish.flashlight.provider.ProbeRegistry;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class FlashlightProbeClientMediator
implements ProbeClientMediator,
PostConstruct {
    private static final Logger logger = LogDomains.getLogger(FlashlightProbeClientMediator.class, (String)"javax.enterprise.system.tools.monitor");
    private static final PrintWriter fpw = new FlashLightBTracePrintWriter((OutputStream)new NullStream(), logger);
    private static ProbeClientMediator _me = new FlashlightProbeClientMediator();
    private static AtomicBoolean agentInitialized = new AtomicBoolean(false);
    private AtomicInteger clientIdGenerator = new AtomicInteger(0);
    private static ConcurrentHashMap<Integer, Object> clients = new ConcurrentHashMap();
    Instrumentation inst = null;
    private static boolean btraceAgentAttached = false;

    public void postConstruct() {
        _me = this;
    }

    public static ProbeClientMediator getInstance() {
        return _me;
    }

    public static Object getClient(int id) {
        return clients.get(id);
    }

    @Override
    public synchronized Collection<ProbeClientMethodHandle> registerListener(Object listener) {
        byte[] bArr;
        int clientID = this.clientIdGenerator.incrementAndGet();
        clients.put(clientID, listener);
        Class<?> clientClz = listener.getClass();
        ArrayList<ProbeClientMethodHandle> pcms = new ArrayList<ProbeClientMethodHandle>();
        ArrayList<FlashlightProbe> probesRequiringClassTransformation = new ArrayList<FlashlightProbe>();
        for (Method clientMethod : clientClz.getDeclaredMethods()) {
            ProbeListener probeAnn = clientMethod.getAnnotation(ProbeListener.class);
            if (probeAnn == null) continue;
            String probeStr = probeAnn.value();
            FlashlightProbe probe = ProbeRegistry.createInstance().getProbe(probeStr);
            if (probe == null) {
                throw new RuntimeException("Invalid probe desc: " + probeStr);
            }
            ProbeClientInvoker invoker = ProbeClientInvokerFactory.createInvoker(listener, clientMethod, probe);
            ProbeClientMethodHandleImpl hi = new ProbeClientMethodHandleImpl(invoker.getId(), invoker, probe);
            pcms.add(hi);
            boolean targetClassNeedsTransformation = probe.addInvoker(invoker);
            if (!targetClassNeedsTransformation) continue;
            probesRequiringClassTransformation.add(probe);
        }
        if (probesRequiringClassTransformation != null && probesRequiringClassTransformation.size() > 0 && (bArr = BtraceClientGenerator.generateBtraceClientClassData(clientID, probesRequiringClassTransformation, clientClz)) != null && FlashlightProbeClientMediator.isAgentAttached()) {
            this.submit2BTrace(bArr);
        }
        return pcms;
    }

    private void submit2BTrace(byte[] bArr) {
        try {
            this.getClass().getClassLoader();
            ClassLoader scl = ClassLoader.getSystemClassLoader();
            Class<?> agentMainClass = scl.loadClass("com.sun.btrace.agent.Main");
            Class[] params = new Class[]{new byte[0].getClass(), PrintWriter.class};
            Method mthd = agentMainClass.getMethod("handleFlashLightClient", params);
            mthd.invoke(null, bArr, fpw);
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (NoSuchMethodException nme) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAgentAttached() {
        if (agentInitialized.get()) {
            return btraceAgentAttached;
        }
        AtomicBoolean atomicBoolean = agentInitialized;
        synchronized (atomicBoolean) {
            if (agentInitialized.get()) {
                return btraceAgentAttached;
            }
            String btp = System.getProperty("btrace.port");
            if (btp == null || btp.length() <= 0) {
                btraceAgentAttached = false;
            } else {
                try {
                    Integer.parseInt(btp);
                    btraceAgentAttached = true;
                }
                catch (NumberFormatException nfe) {
                    btraceAgentAttached = false;
                }
            }
            agentInitialized.set(true);
        }
        return btraceAgentAttached;
    }
}

