/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.external.statistics.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.external.statistics.BoundedRangeStatistic;
import org.glassfish.external.statistics.impl.StatisticImpl;

public final class BoundedRangeStatisticImpl
extends StatisticImpl
implements BoundedRangeStatistic,
InvocationHandler {
    private AtomicLong lowerBound = new AtomicLong(0L);
    private AtomicLong upperBound = new AtomicLong(0L);
    private AtomicLong currentVal = new AtomicLong(Long.MIN_VALUE);
    private AtomicLong highWaterMark = new AtomicLong(Long.MIN_VALUE);
    private AtomicLong lowWaterMark = new AtomicLong(Long.MIN_VALUE);
    private BoundedRangeStatistic bs = (BoundedRangeStatistic)Proxy.newProxyInstance(BoundedRangeStatistic.class.getClassLoader(), new Class[]{BoundedRangeStatistic.class}, (InvocationHandler)this);

    public String toString() {
        return super.toString() + NEWLINE + "Current: " + this.getCurrent() + NEWLINE + "LowWaterMark: " + this.getLowWaterMark() + NEWLINE + "HighWaterMark: " + this.getHighWaterMark() + NEWLINE + "LowerBound: " + this.getLowerBound() + NEWLINE + "UpperBound: " + this.getUpperBound();
    }

    public BoundedRangeStatisticImpl(long curVal, long highMark, long lowMark, long upper, long lower, String name, String unit, String desc, long startTime, long sampleTime) {
        super(name, unit, desc, startTime, sampleTime);
        this.currentVal.set(curVal);
        this.highWaterMark.set(highMark);
        this.lowWaterMark.set(lowMark);
        this.upperBound.set(upper);
        this.lowerBound.set(lower);
    }

    public synchronized BoundedRangeStatistic getStatistic() {
        return this.bs;
    }

    public synchronized Map getStaticAsMap() {
        Map m = super.getStaticAsMap();
        m.put("current", this.getCurrent());
        m.put("lowerbound", this.getLowerBound());
        m.put("upperbound", this.getUpperBound());
        m.put("lowwatermark", this.getLowWaterMark());
        m.put("highwatermark", this.getHighWaterMark());
        return m;
    }

    public long getCurrent() {
        return this.currentVal.get();
    }

    public void setCurrent(long curVal) {
        this.currentVal.set(curVal);
    }

    public long getHighWaterMark() {
        return this.highWaterMark.get();
    }

    public void setHighWaterMark(long highMark) {
        this.highWaterMark.set(highMark);
    }

    public long getLowWaterMark() {
        return this.lowWaterMark.get();
    }

    public void setLowWaterMark(long lowMark) {
        this.lowWaterMark.set(lowMark);
    }

    public long getLowerBound() {
        return this.lowerBound.get();
    }

    public void setLowerBound(long lower) {
        this.lowerBound.set(lower);
    }

    public long getUpperBound() {
        return this.upperBound.get();
    }

    public void setUpperBound(long upper) {
        this.upperBound.set(upper);
    }

    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Object result;
        try {
            result = m.invoke((Object)this, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (Exception e) {
            throw new RuntimeException("unexpected invocation exception: " + e.getMessage());
        }
        return result;
    }
}

