/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CLIConstants;
import com.sun.enterprise.admin.cli.CLILogger;
import com.sun.enterprise.admin.cli.CommandException;
import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.InvalidCommandException;
import com.sun.enterprise.admin.cli.ListCommandsCommand;
import com.sun.enterprise.admin.cli.Parser;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.StringEditDistance;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.JDK;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.ConnectException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class AsadminMain {
    private static String[] copyOfArgs;
    private static String classPath;
    private static String className;
    private static String command;
    private static Map<String, String> systemProps;
    private static ProgramOptions po;
    private static final int ERROR = 1;
    private static final int CONNECTION_ERROR = 2;
    private static final int INVALID_COMMAND_ERROR = 3;
    private static final int SUCCESS = 0;
    private static final int MAX_COMMANDS_TO_DISPLAY = 75;
    private static final LocalStringsImpl strings;

    public static void main(String[] args) {
        int minor = JDK.getMinor();
        if (minor < 6) {
            CLILogger.getInstance().printError(strings.get("OldJdk", new Object[]{"" + minor}));
            System.exit(1);
        }
        if (CLIConstants.debugMode) {
            System.setProperty("WALL_CLOCK_START", "" + System.currentTimeMillis());
            CLILogger.getInstance().printDebugMessage("CLASSPATH= " + System.getProperty("java.class.path") + "\nCommands: " + Arrays.toString(args));
        }
        if (args.length <= 0) {
            args = new String[]{"multimode"};
        }
        if (args[0].equals("-V")) {
            args = new String[]{"version"};
        }
        copyOfArgs = new String[args.length];
        System.arraycopy(args, 0, copyOfArgs, 0, args.length);
        classPath = SmartFile.sanitizePaths((String)System.getProperty("java.class.path"));
        className = AsadminMain.class.getName();
        command = args[0];
        int exitCode = AsadminMain.executeCommand(args);
        switch (exitCode) {
            case 0: {
                if (po.isTerse()) break;
                CLILogger.getInstance().printDetailMessage(strings.get("CommandSuccessful", new Object[]{command}));
                break;
            }
            case 1: {
                CLILogger.getInstance().printDetailMessage(strings.get("CommandUnSuccessful", new Object[]{command}));
                break;
            }
            case 3: {
                CLILogger.getInstance().printDetailMessage(strings.get("CommandUnSuccessful", new Object[]{command}));
                break;
            }
            case 2: {
                CLILogger.getInstance().printDetailMessage(strings.get("CommandUnSuccessful", new Object[]{command}));
            }
        }
        AsadminMain.writeCommandToDebugLog(args, exitCode);
        System.exit(exitCode);
    }

    public static int executeCommand(String[] argv) {
        CLICommand cmd = null;
        Environment env = new Environment();
        try {
            if (argv.length > 0 && argv[0].startsWith("-")) {
                Parser rcp = new Parser(argv, 0, ProgramOptions.getValidOptions(), false);
                Map<String, String> params = rcp.getOptions();
                po = new ProgramOptions(params, env);
                List<String> operands = rcp.getOperands();
                argv = operands.toArray(new String[operands.size()]);
            } else {
                po = new ProgramOptions(env);
            }
            po.toEnvironment(env);
            po.setProgramArguments(copyOfArgs);
            po.setClassPath(classPath);
            po.setClassName(className);
            if (argv.length == 0) {
                argv = new String[]{"multimode"};
            }
            command = argv[0];
            cmd = CLICommand.getCommand(command, po, env);
            return cmd.execute(argv);
        }
        catch (CommandException ce) {
            if (ce.getCause() instanceof InvalidCommandException) {
                CLILogger.getInstance().printError(ce.getMessage());
                try {
                    AsadminMain.displayClosestMatch(command, AsadminMain.getAllCommands(po, env), strings.get("ClosestMatchedLocalAndRemoteCommands"));
                }
                catch (InvalidCommandException e) {}
            } else if (ce.getCause() instanceof ConnectException) {
                CLILogger.getInstance().printError(ce.getMessage());
                try {
                    AsadminMain.displayClosestMatch(command, AsadminMain.getLocalCommands(po, env), strings.get("ClosestMatchedLocalCommands"));
                }
                catch (InvalidCommandException e) {
                    CLILogger.getInstance().printMessage(strings.get("InvalidRemoteCommand", new Object[]{command}));
                }
            } else {
                CLILogger.getInstance().printError(ce.getMessage());
            }
            return 1;
        }
        catch (CommandValidationException cve) {
            CLILogger.getInstance().printError(cve.getMessage());
            if (cmd == null) {
                AsadminMain.printUsage();
            } else {
                CLILogger.getInstance().printError(cmd.getUsage());
            }
            return 1;
        }
    }

    private static void printUsage() {
        CLILogger.getInstance().printError("Usage: asadmin [-H|--host localhost] [-p|--port 4848] [-u|--user anonymous]\n\t[-W|--passwordfile file] [-s|--secure=false] [-e|--echo=false]\n\t[-I|--interactive=true] [-?|--help] [command [options] [operands]]");
    }

    public static String[] getAllCommands(ProgramOptions po, Environment env) {
        try {
            ListCommandsCommand lcc = new ListCommandsCommand("list-commands", po, env);
            String[] remoteCommands = lcc.getRemoteCommands();
            String[] localCommands = lcc.getLocalCommands();
            String[] allCommands = new String[localCommands.length + remoteCommands.length];
            System.arraycopy(localCommands, 0, allCommands, 0, localCommands.length);
            System.arraycopy(remoteCommands, 0, allCommands, localCommands.length, remoteCommands.length);
            return allCommands;
        }
        catch (CommandValidationException cve) {
            return null;
        }
        catch (CommandException ce) {
            return null;
        }
    }

    public static String[] getLocalCommands(ProgramOptions po, Environment env) {
        try {
            ListCommandsCommand lcc = new ListCommandsCommand("list-commands", po, env);
            return lcc.getLocalCommands();
        }
        catch (CommandException ce) {
            return new String[0];
        }
    }

    public static void displayClosestMatch(String commandName, String[] commands, String msg) throws InvalidCommandException {
        block7: {
            try {
                int beginIndex = 0;
                int endIndex = commandName.length();
                if (commandName.startsWith("*")) {
                    beginIndex = 1;
                }
                if (commandName.endsWith("*")) {
                    endIndex = commandName.length() - 1;
                }
                String trimmedCommandName = commandName.substring(beginIndex, endIndex);
                Arrays.sort(commands);
                String[] matchedCommands = AsadminMain.getMatchedCommands(trimmedCommandName, commands);
                if (matchedCommands.length > 0 && matchedCommands.length < 75) {
                    System.out.println(msg != null ? msg : strings.get("ClosestMatchedCommands"));
                    for (String eachCommand : matchedCommands) {
                        System.out.println("    " + eachCommand);
                    }
                    break block7;
                }
                String nearestString = StringEditDistance.findNearest(commandName, commands);
                if (StringEditDistance.editDistance(commandName, nearestString) < 5) {
                    System.out.println(msg != null ? msg : strings.get("ClosestMatchedCommands"));
                    System.out.println("    " + nearestString);
                    break block7;
                }
                throw new InvalidCommandException(commandName);
            }
            catch (Exception e) {
                throw new InvalidCommandException(commandName);
            }
        }
    }

    private static String[] getMatchedCommands(String pattern, String[] commands) {
        ArrayList<String> matchedCommands = new ArrayList<String>();
        for (int i = 0; i < commands.length; ++i) {
            if (commands[i].indexOf(pattern) < 0) continue;
            matchedCommands.add(commands[i]);
        }
        return matchedCommands.toArray(new String[matchedCommands.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCommandToDebugLog(String[] args, int exit) {
        File log = AsadminMain.getDebugLogfile();
        if (log == null) {
            return;
        }
        Writer out = null;
        try {
            out = new BufferedWriter(new FileWriter(log, true));
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            Date date = new Date();
            out.write(dateFormat.format(date));
            out.write(" EXIT: " + exit);
            out.write(" asadmin ");
            if (args != null) {
                for (int i = 0; args != null && i < args.length; ++i) {
                    out.write(args[i] + " ");
                }
            }
        }
        catch (IOException e) {
        }
        finally {
            if (out != null) {
                try {
                    out.write("\n");
                    ((BufferedWriter)out).close();
                }
                catch (Exception e) {}
            }
        }
    }

    private static File getDebugLogfile() {
        String fname = AsadminMain.getEnvOrSysProp("AS_LOGFILE");
        if (fname == null) {
            return null;
        }
        File f = new File(fname);
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (f.isFile() && f.canWrite()) {
            return f;
        }
        return null;
    }

    private static String getEnvOrSysProp(String index) {
        String s1 = System.getProperty(index);
        String s2 = System.getenv(index);
        if (s1 != null) {
            return s1;
        }
        return s2;
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    static {
        strings = new LocalStringsImpl(AsadminMain.class);
        systemProps = new ASenvPropertyReader().getProps();
        String ir = "com.sun.aas.installRoot";
        String cr = "com.sun.aas.configRoot";
        String irVal = systemProps.get("com.sun.aas.installRoot");
        String crVal = systemProps.get("com.sun.aas.configRoot");
        if (AsadminMain.ok(irVal)) {
            System.setProperty("com.sun.aas.installRoot", irVal);
        }
        if (AsadminMain.ok(crVal)) {
            System.setProperty("com.sun.aas.configRoot", crVal);
        }
    }
}

