/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class CLILogger {
    private static boolean trace;
    private static boolean debug;
    private static CLILogger logger;
    private Logger s1asLogger;
    private static final String DEBUG_FLAG = "Debug";
    private static final String ENV_DEBUG_FLAG = "AS_DEBUG";
    private static final int kDefaultBufferSize = 512;
    private static final String PACKAGE_NAME = "com.sun.enterprise.admin.cli";

    protected CLILogger() {
        String sys = System.getProperty(DEBUG_FLAG);
        boolean env = Boolean.parseBoolean(System.getenv(ENV_DEBUG_FLAG));
        trace = Boolean.parseBoolean(System.getenv("AS_TRACE"));
        boolean bl = debug = sys != null || env;
        if (trace) {
            debug = true;
        }
        this.s1asLogger = Logger.getLogger(PACKAGE_NAME, null);
        if (trace) {
            this.s1asLogger.setLevel(Level.FINEST);
        } else if (CLILogger.isDebug()) {
            this.s1asLogger.setLevel(Level.FINER);
        } else {
            this.s1asLogger.setLevel(Level.INFO);
        }
        this.s1asLogger.addHandler(new CLILoggerHandler());
        this.s1asLogger.setUseParentHandlers(false);
    }

    public static boolean isDebug() {
        return debug;
    }

    public static synchronized CLILogger getInstance() {
        if (logger == null) {
            logger = new CLILogger();
        }
        return logger;
    }

    public Level getOutputLevel() {
        return this.s1asLogger.getLevel();
    }

    public void setOutputLevel(Level level) {
        if (!CLILogger.isDebug()) {
            this.s1asLogger.setLevel(level);
        }
    }

    public void printMessage(String message) {
        this.s1asLogger.log(Level.INFO, message);
    }

    public void printDetailMessage(String message) {
        this.s1asLogger.log(Level.FINE, message);
    }

    public void printWarning(String message) {
        this.s1asLogger.log(Level.WARNING, message);
    }

    public void printError(String message) {
        this.s1asLogger.log(Level.SEVERE, message);
    }

    public void printDebugMessage(String message) {
        this.s1asLogger.log(Level.FINER, message);
    }

    public void printTraceMessage(String message) {
        this.s1asLogger.log(Level.FINEST, message);
    }

    public void printExceptionStackTrace(Throwable e) {
        ByteArrayOutputStream output = new ByteArrayOutputStream(512);
        e.printStackTrace(new PrintStream(output));
        this.printDebugMessage(output.toString());
    }

    public class CLILoggerHandler
    extends Handler {
        public void publish(LogRecord logRecord) {
            if (logRecord.getLevel() == Level.SEVERE) {
                System.err.println(logRecord.getMessage());
            } else {
                System.out.println(logRecord.getMessage());
            }
        }

        public void close() throws SecurityException {
        }

        public void flush() {
        }
    }
}

