/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight;

import com.sun.enterprise.config.serverbeans.MonitoringService;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.glassfish.api.monitoring.DTraceContract;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.jvnet.hk2.component.Habitat;

public class FlashlightUtils {
    private static Habitat habitat;
    private static MonitoringService monConfig;
    private static DTraceContract dt;
    private static final Object LOCK;

    private FlashlightUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Habitat h, MonitoringService mc) {
        Object object = LOCK;
        synchronized (object) {
            if (habitat == null) {
                habitat = h;
                monConfig = mc;
                FlashlightUtils.setDTraceAvailabilty();
            }
        }
    }

    public static boolean isDtraceEnabled() {
        FlashlightUtils.ok();
        if (dt == null) {
            return false;
        }
        if (!Boolean.parseBoolean(monConfig.getMonitoringEnabled())) {
            return false;
        }
        return Boolean.parseBoolean(monConfig.getDtraceEnabled());
    }

    public static DTraceContract getDtraceEngine() {
        return FlashlightUtils.isDtraceEnabled() ? dt : null;
    }

    private static void setDTraceAvailabilty() {
        FlashlightUtils.ok();
        dt = null;
        if (!Boolean.parseBoolean(System.getenv("AS_DTRACE"))) {
            return;
        }
        dt = (DTraceContract)habitat.getByContract(DTraceContract.class);
        if (dt == null) {
            return;
        }
        if (!dt.isSupported()) {
            dt = null;
        }
    }

    public static String[] getParamNames(Method method) {
        String[] paramNames = new String[method.getParameterTypes().length];
        Annotation[][] allAnns = method.getParameterAnnotations();
        int index = 0;
        Annotation[][] arr$ = allAnns;
        int len$ = arr$.length;
        block0: for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] paramAnns;
            for (Annotation ann : paramAnns = arr$[i$]) {
                if (!(ann instanceof ProbeParam)) continue;
                paramNames[index++] = ((ProbeParam)ann).value();
                continue block0;
            }
        }
        if (index != paramNames.length) {
            throw new RuntimeException("All params have to be  named with a ProbeParam Annotation.  This method (" + method + ") did not have them.");
        }
        return paramNames;
    }

    private static void ok() {
        if (habitat == null || monConfig == null) {
            throw new RuntimeException("Internal Error: habitat was not set in " + FlashlightUtils.class);
        }
    }

    static {
        LOCK = new Object();
    }
}

