/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.client;

import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.glassfish.flashlight.provider.FlashlightProbe;

public class DTraceClientInvoker {
    private final FlashlightProbe probe;
    private final Object targetObject;
    private final Object[] args;
    private final Object[] fixArgs;
    private final Class targetClass;
    private final int numParams;
    private Method method;
    private static final boolean debug = Boolean.parseBoolean(System.getenv("AS_DEBUG"));
    private static final LocalStringsImpl strings = new LocalStringsImpl(DTraceClientInvoker.class);

    public DTraceClientInvoker(FlashlightProbe p, Object t, Object[] ps) {
        this.probe = p;
        this.targetObject = t;
        this.args = ps == null ? new Object[]{} : ps;
        this.targetClass = this.targetObject.getClass();
        this.numParams = this.args.length;
        this.fixArgs = new Object[this.numParams];
    }

    public void invoke() {
        try {
            this.matchMethod();
            this.method.invoke(this.targetObject, this.fixArgs);
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().warning(e.getMessage());
        }
    }

    private void matchMethod() {
        int numProbeParams;
        String metname = this.probe.getProviderJavaMethodName();
        Class[] probeParamTypes = this.probe.getParamTypes();
        int n = numProbeParams = probeParamTypes == null ? 0 : probeParamTypes.length;
        if (numProbeParams != this.numParams) {
            throw new RuntimeException(strings.get("dtraceinvoker_numparams", new Object[]{this.numParams, numProbeParams}));
        }
        for (Method m : this.targetClass.getMethods()) {
            Class[] paramTypes;
            if (!m.getName().equals(metname) || (paramTypes = m.getParameterTypes()).length != this.numParams || !this.compareParams(probeParamTypes, paramTypes)) continue;
            this.method = m;
            this.fixTheArgs(probeParamTypes, paramTypes);
            return;
        }
        throw new RuntimeException(strings.get("dtraceinvoker_cantfind", new Object[]{metname}));
    }

    private boolean compareParams(Class[] probep, Class[] dtracep) {
        for (int i = 0; i < probep.length; ++i) {
            Class probeClass = probep[i];
            Class dtraceClass = dtracep[i];
            if (probeClass.equals(dtraceClass) || dtraceClass.equals(String.class) && !probeClass.isPrimitive()) continue;
            return false;
        }
        return true;
    }

    private void fixTheArgs(Class[] probep, Class[] dtracep) {
        for (int i = 0; i < probep.length; ++i) {
            Class probeClass = probep[i];
            Class dtraceClass = dtracep[i];
            this.fixArgs[i] = probeClass.equals(dtraceClass) ? this.args[i] : this.args[i].toString();
        }
    }
}

